/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.LeakDetectorKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00100\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/LeakDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkInstanceField", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "field", "Lorg/jetbrains/uast/UField;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "FieldChecker", "lint-checks"})
public final class LeakDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final List<String> SUPER_CLASSES;

    @NotNull
    public List<String> applicableSuperClasses() {
        return SUPER_CLASSES;
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Class[] classArray;
        UMethod method;
        boolean isStatic;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)declaration));
        boolean isAnonymous = declaration instanceof UAnonymousClass;
        JavaEvaluator evaluator = context.getEvaluator();
        boolean bl = isStatic = evaluator.isStatic((PsiModifierListOwner)declaration) || containingClass == null;
        if (isStatic || isAnonymous) {
            for (UField uField : declaration.getFields()) {
                this.checkInstanceField(context, uField);
            }
            if (!isAnonymous) {
                return;
            }
        }
        String superClass = null;
        for (String cls : SUPER_CLASSES) {
            if (!evaluator.inheritsFrom((PsiClass)declaration, cls, false)) continue;
            superClass = cls;
            break;
        }
        if (superClass == null) {
            return;
        }
        UElement uastParent = declaration.getUastParent();
        if (uastParent != null && (method = (UMethod)UastUtils.getParentOfType((UElement)uastParent, UMethod.class, (boolean)true, (Class[])(classArray = new Class[]{UClass.class, UObjectLiteralExpression.class}))) != null && evaluator.isStatic((PsiModifierListOwner)method)) {
            return;
        }
        Class[] classArray2 = new Class[]{UMethod.class};
        UCallExpression invocation = (UCallExpression)UastUtils.getParentOfType((UElement)((UElement)declaration), UObjectLiteralExpression.class, (boolean)true, (Class[])classArray2);
        Object var10_18 = null;
        Location location = isAnonymous && invocation != null ? context.getCallLocation(invocation, false, false) : context.getNameLocation(declaration);
        Object name = null;
        if (isAnonymous) {
            name = "anonymous " + ((UAnonymousClass)declaration).getBaseClassReference().getQualifiedName();
        } else {
            name = declaration.getQualifiedName();
            if (name == null) {
                name = declaration.getName();
            }
        }
        String string = superClass.substring(StringsKt.lastIndexOf$default((CharSequence)superClass, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String superClassName = string;
        context.report(ISSUE, declaration, location, "This `" + superClassName + "` class should be static or leaks might occur (" + (String)name + ")");
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UField.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new FieldChecker(context);
    }

    private final void checkInstanceField(JavaContext context, UField field) {
        PsiType psiType = field.getType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return;
        }
        PsiClassType type = psiClassType;
        String string = type.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.canonicalText");
        String fqn = string;
        if (StringsKt.startsWith$default((String)fqn, (String)"java.", (boolean)false, (int)2, null)) {
            return;
        }
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return;
        }
        PsiClass cls = psiClass;
        if (LeakDetectorKt.access$isLeakCandidate(cls, context.getEvaluator()) && !LeakDetectorKt.access$isAppContext(cls, (PsiField)field) && !LeakDetectorKt.access$isInitializedToAppContext(context, field, cls)) {
            context.report(ISSUE, field, context.getLocation(field), "This field leaks a context object");
        }
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(LeakDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"StaticFieldLeak", (String)"Static Field Leaks", (String)"\n                A static field will leak contexts.\n\n                Non-static inner classes have an implicit reference to their outer class. \\\n                If that outer class is for example a `Fragment` or `Activity`, then this \\\n                reference means that the long-running handler/loader/task will hold a \\\n                reference to the activity which prevents it from getting garbage collected.\n\n                Similarly, direct field references to activities and fragments from these \\\n                longer running instances can cause leaks.\n\n                ViewModel classes should never point to Views or non-application Contexts.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = new String[]{"android.content.Loader", "android.support.v4.content.Loader", "androidx.loader.content.Loader", "android.os.AsyncTask", "android.arch.lifecycle.ViewModel", "androidx.lifecycle.ViewModel"};
        SUPER_CLASSES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/LeakDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "SUPER_CLASSES", "", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/LeakDetector$FieldChecker;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "report", "", "field", "Lcom/intellij/psi/PsiField;", "modifierList", "Lcom/intellij/psi/PsiModifierList;", "message", "", "visitField", "node", "Lorg/jetbrains/uast/UField;", "lint-checks"})
    private static final class FieldChecker
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public FieldChecker(@NotNull JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        public void visitField(@NotNull UField node) {
            block6: {
                PsiClass cls;
                PsiModifierList modifierList;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    modifierList = node.getModifierList();
                    if (modifierList == null || !modifierList.hasModifierProperty("static") || node.getUastParent() instanceof UAnonymousClass) {
                        return;
                    }
                    PsiType psiType = node.getType();
                    PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                    if (psiClassType == null) {
                        return;
                    }
                    PsiClassType type = psiClassType;
                    String string = type.getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.canonicalText");
                    String fqn = string;
                    if (StringsKt.startsWith$default((String)fqn, (String)"java.", (boolean)false, (int)2, null)) {
                        return;
                    }
                    PsiClass psiClass = type.resolve();
                    if (psiClass == null) {
                        return;
                    }
                    cls = psiClass;
                    if (!StringsKt.startsWith$default((String)fqn, (String)"android.", (boolean)false, (int)2, null)) break block5;
                    if (!LeakDetectorKt.access$isLeakCandidate(cls, this.context.getEvaluator()) || LeakDetectorKt.access$isAppContext(cls, (PsiField)node) || LeakDetectorKt.access$isInitializedToAppContext(this.context, node, cls)) break block6;
                    String message2 = "Do not place Android context classes in static fields; this is a memory leak";
                    this.report((PsiField)node, modifierList, message2);
                    break block6;
                }
                PsiField[] psiFieldArray = cls.getAllFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"cls.allFields");
                PsiField[] psiFieldArray2 = psiFieldArray;
                int n = psiFieldArray2.length;
                for (int i = 0; i < n; ++i) {
                    PsiClass innerCls;
                    String canonical;
                    PsiClassType innerType;
                    int count = i;
                    PsiField referenced = psiFieldArray2[i];
                    if (count == 20) break;
                    PsiType psiType = referenced.getType();
                    if ((psiType instanceof PsiClassType ? (PsiClassType)psiType : null) == null) continue;
                    innerType = innerType;
                    Intrinsics.checkNotNullExpressionValue((Object)innerType.getCanonicalText(), (String)"innerType.canonicalText");
                    if (StringsKt.startsWith$default((String)canonical, (String)"java.", (boolean)false, (int)2, null) || innerType.resolve() == null || !StringsKt.startsWith$default((String)canonical, (String)"android.", (boolean)false, (int)2, null) || !LeakDetectorKt.access$isLeakCandidate(innerCls, this.context.getEvaluator())) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)referenced, (String)"referenced");
                    if (LeakDetectorKt.access$isAppContext(innerCls, referenced) || LeakDetectorKt.access$isInitializedToAppContext(this.context, referenced, innerCls)) continue;
                    String message3 = "Do not place Android context classes in static fields (static reference to `" + cls.getName() + "` which has field `" + referenced.getName() + "` pointing to `" + innerCls.getName() + "`); this is a memory leak";
                    this.report((PsiField)node, modifierList, message3);
                    break;
                }
            }
        }

        private final void report(PsiField field, PsiModifierList modifierList, String message2) {
            PsiElement locationNode = (PsiElement)field;
            if (modifierList.hasExplicitModifier("static")) {
                for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof PsiKeyword) || !Intrinsics.areEqual((Object)"static", (Object)((PsiKeyword)child).getText())) continue;
                    locationNode = child;
                    break;
                }
            }
            Location location = this.context.getLocation(locationNode);
            JavaContext.report$default((JavaContext)this.context, (Issue)ISSUE, (PsiElement)((PsiElement)field), (Location)location, (String)message2, null, (int)16, null);
        }
    }
}

