/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.testframework;

import com.android.repository.Revision;
import com.android.repository.api.Channel;
import com.android.repository.api.Dependency;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySource;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RepoPackageImpl;
import com.android.repository.impl.meta.TypeDetails;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;

public abstract class FakePackage {
    private final String mPath;
    private Revision mVersion = new Revision(1);
    private Collection<Dependency> mDependencies = ImmutableList.of();
    private TypeDetails mDetails;
    private String mDisplayName = "fake package";
    private License mLicense;
    private boolean mObsolete;

    public FakePackage(String path) {
        this.mPath = path;
    }

    public void setTypeDetails(TypeDetails details) {
        this.mDetails = details;
    }

    public TypeDetails getTypeDetails() {
        return this.mDetails == null ? (TypeDetails)((Object)RepoManager.getGenericModule().createLatestFactory().createGenericDetailsType()) : this.mDetails;
    }

    public Revision getVersion() {
        return this.mVersion;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.mDisplayName = displayName;
    }

    public License getLicense() {
        return this.mLicense;
    }

    public void setLicense(License license) {
        this.mLicense = license;
    }

    public Collection<Dependency> getAllDependencies() {
        return this.mDependencies;
    }

    public String getPath() {
        return this.mPath;
    }

    public boolean obsolete() {
        return this.mObsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.mObsolete = obsolete;
    }

    public CommonFactory createFactory() {
        return RepoManager.getCommonModule().createLatestFactory();
    }

    public RepoPackageImpl asMarshallable() {
        throw new UnsupportedOperationException();
    }

    public int compareTo(RepoPackage o) {
        if (this instanceof LocalPackage != o instanceof LocalPackage) {
            return this instanceof LocalPackage ? 1 : -1;
        }
        return ComparisonChain.start().compare((Comparable)((Object)this.getPath()), (Comparable)((Object)o.getPath())).compare((Comparable)this.getVersion(), (Comparable)o.getVersion()).result();
    }

    public boolean equals(Object obj) {
        return obj instanceof RepoPackage && ((RepoPackage)obj).getPath().equals(this.getPath()) && ((RepoPackage)obj).getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getVersion()});
    }

    public String toString() {
        return this.mPath;
    }

    public void setDependencies(Collection<Dependency> dependencies) {
        this.mDependencies = dependencies;
    }

    public void setRevision(Revision revision) {
        this.mVersion = revision;
    }

    public static class FakeRemotePackage
    extends FakePackage
    implements RemotePackage {
        private FakeArchive mArchive = new FakeArchive();
        private Channel mChannel;

        public FakeRemotePackage(String path) {
            super(path);
        }

        public void setCompleteUrl(String url) {
            this.mArchive.setCompleteUrl(url);
        }

        public void setPatchInfo(String url, Revision src) {
            this.mArchive.setPatchInfo(url, src);
        }

        @Override
        public Archive getArchive() {
            return this.mArchive;
        }

        @Override
        public RepositorySource getSource() {
            return null;
        }

        public void setChannel(Channel channel) {
            this.mChannel = channel;
        }

        @Override
        public void setSource(RepositorySource source) {
        }

        @Override
        public File getInstallDir(RepoManager manager, ProgressIndicator progress) {
            return new File(manager.getLocalPath(), this.getPath().replace(';', File.separatorChar));
        }

        @Override
        public Channel getChannel() {
            return this.mChannel == null ? Channel.DEFAULT : this.mChannel;
        }

        @Override
        public int compareTo(RepoPackage other) {
            return super.compareTo(other);
        }

        private static class FakeArchive
        extends Archive {
            private String mCompleteUrl;
            private String mPatchUrl;
            private Revision mPatchSrc;

            private FakeArchive() {
            }

            public void setCompleteUrl(String url) {
                this.mCompleteUrl = url;
            }

            public void setPatchInfo(String url, Revision src) {
                this.mPatchUrl = url;
                this.mPatchSrc = src;
            }

            @Override
            public Archive.CompleteType getComplete() {
                if (this.mCompleteUrl != null) {
                    Archive.CompleteType result = this.createFactory().createCompleteType();
                    result.setUrl(this.mCompleteUrl);
                    return result;
                }
                return null;
            }

            @Override
            protected Archive.PatchesType getPatches() {
                if (this.mPatchUrl != null) {
                    Archive.PatchType patch = this.createFactory().createPatchType();
                    patch.setBasedOn(this.createFactory().createRevisionType(this.mPatchSrc));
                    patch.setUrl(this.mPatchUrl);
                    Archive.PatchesType result = this.createFactory().createPatchesType();
                    result.getPatch().add(patch);
                    return result;
                }
                return null;
            }

            @Override
            public CommonFactory createFactory() {
                return RepoManager.getCommonModule().createLatestFactory();
            }
        }
    }

    public static class FakeLocalPackage
    extends FakePackage
    implements LocalPackage {
        private File mLocation;

        @Override
        public File getLocation() {
            return this.mLocation;
        }

        @Override
        public void setInstalledPath(File root) {
            this.mLocation = root;
        }

        public FakeLocalPackage(String path) {
            super(path);
        }

        @Override
        public int compareTo(RepoPackage other) {
            return super.compareTo(other);
        }
    }
}

