/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.commonutils.gc;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;

public class GcUtils {
    public static int fullFinalization() {
        final CountDownLatch finalizerLatch = new CountDownLatch(1);
        ReferenceQueue queue = new ReferenceQueue();
        PhantomReference<1> ref = new PhantomReference<1>(new Object(){

            protected void finalize() {
                finalizerLatch.countDown();
            }
        }, queue);
        int gcIterationCnt = GcUtils.awaitForLatchAndReference(finalizerLatch, ref);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.NANOSECONDS).until(() -> queue.poll() != null);
        return gcIterationCnt;
    }

    private static int awaitForLatchAndReference(CountDownLatch latch, Reference<?> reference) {
        long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        boolean finalizationCalled = false;
        int gcIteration = 0;
        if (latch.getCount() == 0L) {
            finalizationCalled = true;
        }
        while (System.nanoTime() - deadline < 0L) {
            System.runFinalization();
            System.gc();
            ++gcIteration;
            if (!finalizationCalled) {
                try {
                    finalizationCalled = latch.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!finalizationCalled || !reference.isEnqueued()) continue;
            return gcIteration;
        }
        throw new RuntimeException("Latch failed to count down by timeout");
    }

    public static void tryToAllocateAllAvailableMemory() {
        try {
            int size;
            ArrayList<Object[]> allocations = new ArrayList<Object[]>();
            while ((size = (int)Runtime.getRuntime().freeMemory()) > 0) {
                Object[] part = new Object[Math.min(size, Integer.MAX_VALUE)];
                allocations.add(part);
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("catch expected exception: " + e.getMessage());
        }
    }
}

