/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.commonutils.gc;

import com.antkorwin.commonutils.gc.GcUtils;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public class LeakDetector
extends PhantomReference<Object> {
    private final String description;

    public LeakDetector(Object referent) {
        super(referent, new ReferenceQueue());
        this.description = String.valueOf(referent);
    }

    public void assertMemoryLeaksNotExist() {
        GcUtils.fullFinalization();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isEnqueued()).as("Object: " + this.description + " was leaked", new Object[0])).isTrue();
    }

    public void assertMemoryLeaksExist() {
        GcUtils.fullFinalization();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isEnqueued()).as("Object: " + this.description + " was collected by GC", new Object[0])).isFalse();
    }
}

