/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.commonutils.validation;

import com.antkorwin.commonutils.validation.ErrorInfo;
import com.antkorwin.commonutils.validation.ErrorInfoUnique;
import java.util.HashMap;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ErrorInfoCollisionDetector {
    public static void assertInPackage(String packageNameForScan) {
        Reflections reflections = new Reflections(packageNameForScan, new Scanner[0]);
        Set annotated = reflections.getTypesAnnotatedWith(ErrorInfoUnique.class);
        HashMap mapOfCodes = new HashMap();
        annotated.forEach(clazz -> {
            for (ErrorInfo e : (ErrorInfo[])clazz.getEnumConstants()) {
                if (mapOfCodes.containsKey(e.getCode())) {
                    ErrorInfo info = (ErrorInfo)mapOfCodes.get(e.getCode());
                    Assertions.fail((String)("Detected collisions in the next error info: \n" + e.toString() + "[" + e.getCode() + "]  / " + info.toString() + "[" + info.getCode() + "]\n - from " + e.getClass() + "\n - and " + info.getClass()));
                }
                mapOfCodes.put(e.getCode(), e);
            }
        });
    }
}

