/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.commonutils.validation;

import com.antkorwin.commonutils.exceptions.BaseException;
import com.antkorwin.commonutils.exceptions.ConditionValidationException;
import com.antkorwin.commonutils.exceptions.InternalException;
import com.antkorwin.commonutils.exceptions.NotFoundException;
import com.antkorwin.commonutils.exceptions.WrongArgumentException;
import com.antkorwin.commonutils.validation.ErrorInfo;
import com.antkorwin.commonutils.validation.InternalErrorInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Guard {
    public static void checkEntityExist(Object entity, ErrorInfo errorInfo) {
        if (entity == null) {
            throw new NotFoundException(errorInfo);
        }
    }

    public static void checkArgumentExist(Object argument, ErrorInfo errorInfo) {
        if (argument == null) {
            throw new WrongArgumentException(errorInfo);
        }
    }

    public static void check(boolean condition, ErrorInfo errorInfo) {
        if (!condition) {
            throw new ConditionValidationException(errorInfo);
        }
    }

    public static void check(boolean condition, Class<? extends RuntimeException> exceptionClass) {
        if (!condition) {
            try {
                throw exceptionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public static void check(boolean condition, Class<? extends RuntimeException> exceptionClass, String message) {
        if (!condition) {
            try {
                Constructor<? extends RuntimeException> ctor = exceptionClass.getConstructor(String.class);
                RuntimeException object = ctor.newInstance(message);
                throw object;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void check(boolean condition, Class<? extends RuntimeException> exceptionClass, String message, Exception cause) {
        if (!condition) {
            try {
                Constructor<? extends RuntimeException> ctor = exceptionClass.getConstructor(String.class);
                RuntimeException object = ctor.newInstance(message);
                object.initCause(cause);
                throw object;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T extends RuntimeException> void check(boolean condition, Class<T> exceptionType, ErrorInfo errorInfo) {
        if (!condition) {
            RuntimeException exception;
            try {
                exception = BaseException.class.isAssignableFrom(exceptionType) ? (RuntimeException)exceptionType.getConstructor(ErrorInfo.class).newInstance(errorInfo) : (RuntimeException)exceptionType.getConstructor(String.class).newInstance(errorInfo.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalException(InternalErrorInfo.EXCEPTION_CONSTRUCTOR_NOT_FOUND);
            }
            throw exception;
        }
    }
}

