/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.commonutils.validation;

import com.antkorwin.commonutils.validation.ErrorInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Assert;

public class GuardCheck {
    public static void check(Runnable action, Class<? extends Throwable> expectedExceptionClass) {
        boolean fail;
        block4: {
            fail = false;
            try {
                action.run();
                fail = true;
            }
            catch (Throwable t) {
                Throwable cause = t;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (GuardCheck.isSameException(expectedExceptionClass, cause)) break block4;
                Assert.fail((String)String.format("Bad exception type.\n\tExpected: %s,\n\tRecieved: %s", expectedExceptionClass.getName(), cause.getClass().getName()));
            }
        }
        if (fail) {
            Assert.fail((String)String.format("No exception was thrown, but expected: %s", expectedExceptionClass.getSimpleName()));
        }
    }

    private static boolean isSameException(Class<? extends Throwable> expectedClass, Throwable cause) {
        return expectedClass.isInstance(cause);
    }

    public static void check(Runnable action, Class<? extends Throwable> exceptionClass, ErrorInfo errorInfo) {
        try {
            action.run();
            Assert.fail((String)String.format("No exception was thrown, but expected: %s(%s)", exceptionClass.getSimpleName(), errorInfo));
        }
        catch (Throwable cause) {
            if (cause instanceof RuntimeException && exceptionClass.isInstance(cause)) {
                Assert.assertEquals((Object)errorInfo.getMessage(), (Object)cause.getMessage());
            }
            Assert.fail((String)String.format("Bad exception type.\n\tExpected: %s,\n\tRecieved: %s \nStackTrace:", exceptionClass.getName(), cause.getClass().getName(), ExceptionUtils.getStackTrace((Throwable)cause)));
        }
    }

    public static void checkNested(Runnable action, Class<? extends Throwable> exceptionClass, ErrorInfo errorInfo) {
        try {
            action.run();
            Assert.fail((String)String.format("No exception was thrown, but expected: %s(%s)", exceptionClass.getSimpleName(), errorInfo));
        }
        catch (Throwable t) {
            Throwable cause = t;
            if (cause instanceof RuntimeException && exceptionClass.isInstance(cause)) {
                Assert.assertEquals((Object)errorInfo.getMessage(), (Object)cause.getMessage());
                return;
            }
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof RuntimeException && exceptionClass.isInstance(cause.getCause())) {
                Assert.assertEquals((Object)errorInfo.getMessage(), (Object)cause.getCause().getMessage());
            }
            if (exceptionClass.isInstance(cause)) {
                Assert.assertEquals((Object)errorInfo.getMessage(), (Object)cause.getMessage());
            }
            Assert.fail((String)String.format("Bad exception type.\n\tExpected: %s,\n\tRecieved: %s", exceptionClass.getName(), cause.getClass().getName()));
        }
    }
}

