/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.response;

import com.apollographql.apollo.api.CustomTypeAdapter;
import com.apollographql.apollo.api.CustomTypeValue;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.FieldValueResolver;
import com.apollographql.apollo.api.internal.ResolveDelegate;
import com.apollographql.apollo.api.internal.ResponseReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001<B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0017\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u0004\u0018\u0001H$\"\b\b\u0001\u0010$*\u00020\u00192\u0006\u0010\u001c\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&J\u0017\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010)J/\u0010*\u001a\u0004\u0018\u0001H$\"\b\b\u0001\u0010$*\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H$0,H\u0016\u00a2\u0006\u0002\u0010-J\u0017\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u00100J2\u00101\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H$\u0018\u000102\"\b\b\u0001\u0010$*\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H$04H\u0016J\u0017\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u00107J/\u00108\u001a\u0004\u0018\u0001H$\"\b\b\u0001\u0010$*\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H$0,H\u0016\u00a2\u0006\u0002\u0010-J\u0012\u00109\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010:\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0019H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/apollographql/apollo/internal/response/RealResponseReader;", "R", "Lcom/apollographql/apollo/api/internal/ResponseReader;", "operationVariables", "Lcom/apollographql/apollo/api/Operation$Variables;", "recordSet", "fieldValueResolver", "Lcom/apollographql/apollo/api/internal/FieldValueResolver;", "scalarTypeAdapters", "Lcom/apollographql/apollo/api/ScalarTypeAdapters;", "resolveDelegate", "Lcom/apollographql/apollo/api/internal/ResolveDelegate;", "(Lcom/apollographql/apollo/api/Operation$Variables;Ljava/lang/Object;Lcom/apollographql/apollo/api/internal/FieldValueResolver;Lcom/apollographql/apollo/api/ScalarTypeAdapters;Lcom/apollographql/apollo/api/internal/ResolveDelegate;)V", "getFieldValueResolver$apollo_runtime", "()Lcom/apollographql/apollo/api/internal/FieldValueResolver;", "getOperationVariables", "()Lcom/apollographql/apollo/api/Operation$Variables;", "Ljava/lang/Object;", "getResolveDelegate$apollo_runtime", "()Lcom/apollographql/apollo/api/internal/ResolveDelegate;", "getScalarTypeAdapters$apollo_runtime", "()Lcom/apollographql/apollo/api/ScalarTypeAdapters;", "variableValues", "", "", "", "checkValue", "", "field", "Lcom/apollographql/apollo/api/ResponseField;", "value", "didResolve", "readBoolean", "", "(Lcom/apollographql/apollo/api/ResponseField;)Ljava/lang/Boolean;", "readCustomType", "T", "Lcom/apollographql/apollo/api/ResponseField$CustomTypeField;", "(Lcom/apollographql/apollo/api/ResponseField$CustomTypeField;)Ljava/lang/Object;", "readDouble", "", "(Lcom/apollographql/apollo/api/ResponseField;)Ljava/lang/Double;", "readFragment", "objectReader", "Lcom/apollographql/apollo/api/internal/ResponseReader$ObjectReader;", "(Lcom/apollographql/apollo/api/ResponseField;Lcom/apollographql/apollo/api/internal/ResponseReader$ObjectReader;)Ljava/lang/Object;", "readInt", "", "(Lcom/apollographql/apollo/api/ResponseField;)Ljava/lang/Integer;", "readList", "", "listReader", "Lcom/apollographql/apollo/api/internal/ResponseReader$ListReader;", "readLong", "", "(Lcom/apollographql/apollo/api/ResponseField;)Ljava/lang/Long;", "readObject", "readString", "shouldSkip", "willResolve", "ListItemReader", "apollo-runtime"})
public final class RealResponseReader<R>
implements ResponseReader {
    @NotNull
    private final Operation.Variables operationVariables;
    private final R recordSet;
    @NotNull
    private final FieldValueResolver<R> fieldValueResolver;
    @NotNull
    private final ScalarTypeAdapters scalarTypeAdapters;
    @NotNull
    private final ResolveDelegate<R> resolveDelegate;
    @NotNull
    private final Map<String, Object> variableValues;

    public RealResponseReader(@NotNull Operation.Variables operationVariables, R recordSet, @NotNull FieldValueResolver<R> fieldValueResolver, @NotNull ScalarTypeAdapters scalarTypeAdapters, @NotNull ResolveDelegate<R> resolveDelegate) {
        Intrinsics.checkParameterIsNotNull((Object)operationVariables, (String)"operationVariables");
        Intrinsics.checkParameterIsNotNull(fieldValueResolver, (String)"fieldValueResolver");
        Intrinsics.checkParameterIsNotNull((Object)scalarTypeAdapters, (String)"scalarTypeAdapters");
        Intrinsics.checkParameterIsNotNull(resolveDelegate, (String)"resolveDelegate");
        this.operationVariables = operationVariables;
        this.recordSet = recordSet;
        this.fieldValueResolver = fieldValueResolver;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.resolveDelegate = resolveDelegate;
        this.variableValues = this.operationVariables.valueMap();
    }

    @NotNull
    public final Operation.Variables getOperationVariables() {
        return this.operationVariables;
    }

    @NotNull
    public final FieldValueResolver<R> getFieldValueResolver$apollo_runtime() {
        return this.fieldValueResolver;
    }

    @NotNull
    public final ScalarTypeAdapters getScalarTypeAdapters$apollo_runtime() {
        return this.scalarTypeAdapters;
    }

    @NotNull
    public final ResolveDelegate<R> getResolveDelegate$apollo_runtime() {
        return this.resolveDelegate;
    }

    @Nullable
    public String readString(@NotNull ResponseField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        if (this.shouldSkip(field)) {
            return null;
        }
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar((Object)value);
        }
        this.didResolve(field);
        return value;
    }

    @Nullable
    public Integer readInt(@NotNull ResponseField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar((Object)value);
        }
        this.didResolve(field);
        BigDecimal bigDecimal = value;
        return bigDecimal == null ? null : Integer.valueOf(bigDecimal.intValue());
    }

    @Nullable
    public Long readLong(@NotNull ResponseField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar((Object)value);
        }
        this.didResolve(field);
        BigDecimal bigDecimal = value;
        return bigDecimal == null ? null : Long.valueOf(bigDecimal.longValue());
    }

    @Nullable
    public Double readDouble(@NotNull ResponseField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        if (this.shouldSkip(field)) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar((Object)value);
        }
        this.didResolve(field);
        BigDecimal bigDecimal = value;
        return bigDecimal == null ? null : Double.valueOf(bigDecimal.doubleValue());
    }

    @Nullable
    public Boolean readBoolean(@NotNull ResponseField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        if (this.shouldSkip(field)) {
            return null;
        }
        Boolean value = (Boolean)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
        } else {
            this.resolveDelegate.didResolveScalar((Object)value);
        }
        this.didResolve(field);
        return value;
    }

    @Nullable
    public <T> T readObject(@NotNull ResponseField field, @NotNull ResponseReader.ObjectReader<T> objectReader) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull(objectReader, (String)"objectReader");
        if (this.shouldSkip(field)) {
            return null;
        }
        Object value = this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        this.resolveDelegate.willResolveObject(field, value);
        Object parsedValue = null;
        if (value == null) {
            this.resolveDelegate.didResolveNull();
            object = null;
        } else {
            object = objectReader.read((ResponseReader)new RealResponseReader<Object>(this.operationVariables, value, this.fieldValueResolver, this.scalarTypeAdapters, this.resolveDelegate));
        }
        parsedValue = object;
        this.resolveDelegate.didResolveObject(field, value);
        this.didResolve(field);
        return (T)parsedValue;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T> List<T> readList(@NotNull ResponseField field, @NotNull ResponseReader.ListReader<T> listReader) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull(listReader, (String)"listReader");
        if (this.shouldSkip(field)) {
            return null;
        }
        List values = (List)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, values);
        this.willResolve(field, values);
        if (values == null) {
            this.resolveDelegate.didResolveNull();
            list = null;
        } else {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = values;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Object object;
                void value;
                void index;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                this.getResolveDelegate$apollo_runtime().willResolveElement((int)index);
                if (value == null) {
                    this.getResolveDelegate$apollo_runtime().didResolveNull();
                    object = null;
                } else {
                    object = listReader.read((ResponseReader.ListItemReader)new ListItemReader(field, value));
                }
                Object object2 = object;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it = object2;
                boolean bl5 = false;
                this.getResolveDelegate$apollo_runtime().didResolveElement((int)index);
                Object object3 = object2;
                collection.add(object3);
            }
            List list2 = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl6 = false;
            List it = list2;
            boolean bl7 = false;
            this.getResolveDelegate$apollo_runtime().didResolveList(values);
            list = list2;
        }
        List result = list;
        this.didResolve(field);
        return result != null ? Collections.unmodifiableList(result) : null;
    }

    @Nullable
    public <T> T readCustomType(@NotNull ResponseField.CustomTypeField field) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        if (this.shouldSkip((ResponseField)field)) {
            return null;
        }
        Object value = this.fieldValueResolver.valueFor(this.recordSet, (ResponseField)field);
        this.checkValue((ResponseField)field, value);
        this.willResolve((ResponseField)field, value);
        Object result = null;
        if (value == null) {
            this.resolveDelegate.didResolveNull();
            result = null;
        } else {
            CustomTypeAdapter typeAdapter = this.scalarTypeAdapters.adapterFor(field.getScalarType());
            result = typeAdapter.decode(CustomTypeValue.Companion.fromRawValue(value));
            this.checkValue((ResponseField)field, result);
            this.resolveDelegate.didResolveScalar(value);
        }
        this.didResolve((ResponseField)field);
        return (T)result;
    }

    @Nullable
    public <T> T readFragment(@NotNull ResponseField field, @NotNull ResponseReader.ObjectReader<T> objectReader) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull(objectReader, (String)"objectReader");
        if (this.shouldSkip(field)) {
            return null;
        }
        String value = (String)this.fieldValueResolver.valueFor(this.recordSet, field);
        this.checkValue(field, value);
        this.willResolve(field, value);
        if (value == null) {
            this.resolveDelegate.didResolveNull();
            this.didResolve(field);
            object = null;
        } else {
            this.resolveDelegate.didResolveScalar((Object)value);
            this.didResolve(field);
            if (field.getType() == ResponseField.Type.FRAGMENT) {
                for (ResponseField.Condition condition : field.getConditions()) {
                    if (!(condition instanceof ResponseField.TypeNameCondition) || ((ResponseField.TypeNameCondition)condition).getTypeNames().contains(value)) continue;
                    return null;
                }
                object = objectReader.read((ResponseReader)this);
            } else {
                object = null;
            }
        }
        return (T)object;
    }

    private final boolean shouldSkip(ResponseField field) {
        for (ResponseField.Condition condition : field.getConditions()) {
            if (!(condition instanceof ResponseField.BooleanCondition)) continue;
            Boolean conditionValue = (Boolean)this.variableValues.get(((ResponseField.BooleanCondition)condition).getVariableName());
            if (!(((ResponseField.BooleanCondition)condition).isInverted() ? Intrinsics.areEqual((Object)conditionValue, (Object)true) : Intrinsics.areEqual((Object)conditionValue, (Object)false))) continue;
            return true;
        }
        return false;
    }

    private final void willResolve(ResponseField field, Object value) {
        this.resolveDelegate.willResolve(field, this.operationVariables, value);
    }

    private final void didResolve(ResponseField field) {
        this.resolveDelegate.didResolve(field, this.operationVariables);
    }

    private final void checkValue(ResponseField field, Object value) {
        boolean bl = field.getOptional() || value != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"corrupted response reader, expected non null value for ", (Object)field.getFieldName());
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Nullable
    public <T> T readFragment(@NotNull ResponseField field, @NotNull Function1<? super ResponseReader, ? extends T> block) {
        return (T)ResponseReader.DefaultImpls.readFragment((ResponseReader)this, (ResponseField)field, block);
    }

    @Nullable
    public <T> List<T> readList(@NotNull ResponseField field, @NotNull Function1<? super ResponseReader.ListItemReader, ? extends T> block) {
        return ResponseReader.DefaultImpls.readList((ResponseReader)this, (ResponseField)field, block);
    }

    @Nullable
    public <T> T readObject(@NotNull ResponseField field, @NotNull Function1<? super ResponseReader, ? extends T> block) {
        return (T)ResponseReader.DefaultImpls.readObject((ResponseReader)this, (ResponseField)field, block);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001f\u0010\t\u001a\u0002H\n\"\b\b\u0001\u0010\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\u0013\"\b\b\u0001\u0010\n*\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\n0\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J%\u0010\u0018\u001a\u0002H\n\"\b\b\u0001\u0010\n*\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\n0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/apollographql/apollo/internal/response/RealResponseReader$ListItemReader;", "Lcom/apollographql/apollo/api/internal/ResponseReader$ListItemReader;", "field", "Lcom/apollographql/apollo/api/ResponseField;", "value", "", "(Lcom/apollographql/apollo/internal/response/RealResponseReader;Lcom/apollographql/apollo/api/ResponseField;Ljava/lang/Object;)V", "readBoolean", "", "readCustomType", "T", "scalarType", "Lcom/apollographql/apollo/api/ScalarType;", "(Lcom/apollographql/apollo/api/ScalarType;)Ljava/lang/Object;", "readDouble", "", "readInt", "", "readList", "", "listReader", "Lcom/apollographql/apollo/api/internal/ResponseReader$ListReader;", "readLong", "", "readObject", "objectReader", "Lcom/apollographql/apollo/api/internal/ResponseReader$ObjectReader;", "(Lcom/apollographql/apollo/api/internal/ResponseReader$ObjectReader;)Ljava/lang/Object;", "readString", "", "apollo-runtime"})
    private final class ListItemReader
    implements ResponseReader.ListItemReader {
        @NotNull
        private final ResponseField field;
        @NotNull
        private final Object value;

        public ListItemReader(@NotNull ResponseField field, Object value) {
            Intrinsics.checkParameterIsNotNull((Object)RealResponseReader.this, (String)"this$0");
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.field = field;
            this.value = value;
        }

        @NotNull
        public String readString() {
            RealResponseReader.this.getResolveDelegate$apollo_runtime().didResolveScalar(this.value);
            return (String)this.value;
        }

        public int readInt() {
            RealResponseReader.this.getResolveDelegate$apollo_runtime().didResolveScalar(this.value);
            return ((BigDecimal)this.value).intValue();
        }

        public long readLong() {
            RealResponseReader.this.getResolveDelegate$apollo_runtime().didResolveScalar(this.value);
            return ((BigDecimal)this.value).longValue();
        }

        public double readDouble() {
            RealResponseReader.this.getResolveDelegate$apollo_runtime().didResolveScalar(this.value);
            return ((BigDecimal)this.value).doubleValue();
        }

        public boolean readBoolean() {
            RealResponseReader.this.getResolveDelegate$apollo_runtime().didResolveScalar(this.value);
            return (Boolean)this.value;
        }

        @NotNull
        public <T> T readCustomType(@NotNull ScalarType scalarType) {
            Intrinsics.checkParameterIsNotNull((Object)scalarType, (String)"scalarType");
            CustomTypeAdapter typeAdapter = RealResponseReader.this.getScalarTypeAdapters$apollo_runtime().adapterFor(scalarType);
            RealResponseReader.this.getResolveDelegate$apollo_runtime().didResolveScalar(this.value);
            return (T)typeAdapter.decode(CustomTypeValue.Companion.fromRawValue(this.value));
        }

        @NotNull
        public <T> T readObject(@NotNull ResponseReader.ObjectReader<T> objectReader) {
            Intrinsics.checkParameterIsNotNull(objectReader, (String)"objectReader");
            Object value = this.value;
            RealResponseReader.this.getResolveDelegate$apollo_runtime().willResolveObject(this.field, value);
            Object item = objectReader.read((ResponseReader)new RealResponseReader<Object>(RealResponseReader.this.getOperationVariables(), value, RealResponseReader.this.getFieldValueResolver$apollo_runtime(), RealResponseReader.this.getScalarTypeAdapters$apollo_runtime(), RealResponseReader.this.getResolveDelegate$apollo_runtime()));
            RealResponseReader.this.getResolveDelegate$apollo_runtime().didResolveObject(this.field, value);
            return (T)item;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public <T> List<T> readList(@NotNull ResponseReader.ListReader<T> listReader) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Intrinsics.checkParameterIsNotNull(listReader, (String)"listReader");
            List values = (List)this.value;
            List list = values;
            RealResponseReader realResponseReader = RealResponseReader.this;
            boolean $i$f$mapIndexed = false;
            void var7_6 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Object object;
                void value;
                void index;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                realResponseReader.getResolveDelegate$apollo_runtime().willResolveElement((int)index);
                if (value == null) {
                    realResponseReader.getResolveDelegate$apollo_runtime().didResolveNull();
                    object = null;
                } else {
                    object = listReader.read((ResponseReader.ListItemReader)realResponseReader.new ListItemReader(this.field, value));
                }
                Object object2 = object;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it = object2;
                boolean bl5 = false;
                realResponseReader.getResolveDelegate$apollo_runtime().didResolveElement((int)index);
                Object object3 = object2;
                collection.add(object3);
            }
            List result = (List)destination$iv$iv;
            RealResponseReader.this.getResolveDelegate$apollo_runtime().didResolveList(values);
            list = Collections.unmodifiableList(result);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"unmodifiableList(result)");
            return list;
        }

        @NotNull
        public <T> List<T> readList(@NotNull Function1<? super ResponseReader.ListItemReader, ? extends T> block) {
            return ResponseReader.ListItemReader.DefaultImpls.readList((ResponseReader.ListItemReader)this, block);
        }

        @NotNull
        public <T> T readObject(@NotNull Function1<? super ResponseReader, ? extends T> block) {
            return (T)ResponseReader.ListItemReader.DefaultImpls.readObject((ResponseReader.ListItemReader)this, block);
        }
    }
}

