/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.images;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AccessibilityLevel;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.IConfigurationGetter;
import com.applitools.eyes.config.IConfigurationSetter;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.events.ValidationResult;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.images.EyesImagesScreenshot;
import com.applitools.eyes.images.IImagesCheckTarget;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;

public class Eyes
extends EyesBase
implements IConfigurationGetter,
IConfigurationSetter {
    private String title;
    private EyesImagesScreenshot screenshot;
    private String inferred;
    private Configuration config = new Configuration();

    public String getBaseAgentId() {
        return "eyes.images.java/3.160.3";
    }

    public String tryCaptureDom() {
        return null;
    }

    public void open(String appName, String testName, RectangleSize dimensions) throws EyesException {
        this.config.setAppName(appName);
        this.config.setTestName(testName);
        this.config.setViewportSize(dimensions);
        this.openBase();
    }

    public void open(String appName, String testName) {
        this.config.setAppName(appName);
        this.config.setTestName(testName);
        this.openBase();
    }

    public boolean check(String name, ICheckSettings checkSettings) {
        IImagesCheckTarget imagesCheckTarget;
        IImagesCheckTarget iImagesCheckTarget = imagesCheckTarget = checkSettings instanceof IImagesCheckTarget ? (IImagesCheckTarget)checkSettings : null;
        if (imagesCheckTarget == null) {
            return false;
        }
        BufferedImage image = imagesCheckTarget.getImage();
        if (this.viewportSize == null) {
            this.setViewportSize(new RectangleSize(image.getWidth(), image.getHeight()));
        }
        return this.checkImage_(RegionProvider.NULL_INSTANCE, image, name, false, checkSettings);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image) {
        return this.checkImage(image);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image, String tag) {
        return this.checkImage(image, tag);
    }

    @Deprecated
    public boolean checkWindow(BufferedImage image, String tag, boolean ignoreMismatch) {
        return this.checkImage(image, tag, ignoreMismatch);
    }

    public boolean checkImage(BufferedImage image) {
        return this.checkImage(image, null);
    }

    public boolean checkImage(BufferedImage image, String tag) {
        return this.checkImage(image, tag, false);
    }

    public boolean checkImage(BufferedImage image, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("CheckImage(Image, '%s', %b): Ignored", tag, ignoreMismatch));
            return false;
        }
        ArgumentGuard.notNull((Object)image, (String)"image cannot be null!");
        this.logger.verbose(String.format("CheckImage(Image, '%s', %b)", tag, ignoreMismatch));
        if (this.viewportSize == null) {
            this.setViewportSize(new RectangleSize(image.getWidth(), image.getHeight()));
        }
        return this.checkImage_(RegionProvider.NULL_INSTANCE, image, tag, ignoreMismatch, (ICheckSettings)new CheckSettings(-1));
    }

    public boolean checkImage(String path) {
        return this.checkImage(path, null);
    }

    public boolean checkImage(String path, String tag) {
        return this.checkImage(path, tag, false);
    }

    public boolean checkImage(String path, String tag, boolean ignoreMismatch) {
        return this.checkImage(ImageUtils.imageFromFile((String)path), tag, ignoreMismatch);
    }

    public boolean checkImage(byte[] image) {
        return this.checkImage(image, null);
    }

    public boolean checkImage(byte[] image, String tag) {
        return this.checkImage(image, tag, false);
    }

    public boolean checkImage(byte[] image, String tag, boolean ignoreMismatch) {
        return this.checkImage(ImageUtils.imageFromBytes((byte[])image), tag, ignoreMismatch);
    }

    public boolean checkRegion(BufferedImage image, final Region region, String tag, boolean ignoreMismatch) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("CheckRegion(Image, [%s], '%s', %b): Ignored", region, tag, ignoreMismatch));
            return false;
        }
        ArgumentGuard.notNull((Object)image, (String)"image cannot be null!");
        ArgumentGuard.notNull((Object)region, (String)"region cannot be null!");
        this.logger.verbose(String.format("CheckRegion(Image, [%s], '%s', %b)", region, tag, ignoreMismatch));
        if (this.viewportSize == null) {
            this.setViewportSize(new RectangleSize(image.getWidth(), image.getHeight()));
        }
        return this.checkImage_(new RegionProvider(){

            public Region getRegion() {
                return region;
            }
        }, image, tag, ignoreMismatch, (ICheckSettings)new CheckSettings(-1));
    }

    public void checkRegion(BufferedImage image, Region region, String tag) {
        this.checkRegion(image, region, tag, false);
    }

    public void checkRegion(BufferedImage image, Region region) {
        this.checkRegion(image, region, null, false);
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addTextTrigger(Region control, String text) {
        this.addTextTriggerBase(control, text);
    }

    public RectangleSize getViewportSize() {
        return this.viewportSize;
    }

    public SessionType getSessionType() {
        return this.config.getSessionType();
    }

    public FailureReports getFailureReports() {
        return this.config.getFailureReports();
    }

    public IConfigurationSetter setViewportSize(RectangleSize size) {
        ArgumentGuard.notNull((Object)size, (String)"size");
        this.viewportSize = new RectangleSize(size.getWidth(), size.getHeight());
        return this.config;
    }

    public IConfigurationSetter setSessionType(SessionType sessionType) {
        this.config.setSessionType(sessionType);
        return this.config;
    }

    public IConfigurationSetter setFailureReports(FailureReports failureReports) {
        this.config.setFailureReports(failureReports);
        return this.config;
    }

    protected String getInferredEnvironment() {
        return this.inferred != null ? this.inferred : "";
    }

    public void setInferredEnvironment(String inferred) {
        this.inferred = inferred;
    }

    public EyesScreenshot getScreenshot(ICheckSettingsInternal checkSettingsInternal) {
        return this.screenshot;
    }

    protected String getTitle() {
        return this.title;
    }

    protected String getAUTSessionId() {
        return "";
    }

    private boolean checkImage_(RegionProvider regionProvider, BufferedImage image, String tag, boolean ignoreMismatch, ICheckSettings checkSettings) {
        image = ImageUtils.normalizeImageType((BufferedImage)image);
        CutProvider cutProvider = (CutProvider)this.cutProviderHandler.get();
        if (!(cutProvider instanceof NullCutProvider)) {
            this.logger.verbose("cutting...");
            image = cutProvider.cut(image);
            this.debugScreenshotsProvider.save(image, "cut");
        }
        this.screenshot = new EyesImagesScreenshot(this.logger, image);
        return this.checkImage_(regionProvider, tag, ignoreMismatch, checkSettings);
    }

    private boolean checkImage_(RegionProvider regionProvider, String tag, boolean ignoreMismatch, ICheckSettings checkSettings) {
        this.title = tag != null ? tag : "";
        ValidationInfo validationInfo = this.fireValidationWillStartEvent(tag);
        MatchResult result = this.checkWindowBase(regionProvider, tag, ignoreMismatch, checkSettings, null);
        ValidationResult validationResult = new ValidationResult();
        validationResult.setAsExpected(result.getAsExpected());
        this.getSessionEventHandlers().validationEnded(this.getAUTSessionId(), validationInfo.getValidationId(), validationResult);
        return result.getAsExpected();
    }

    public IConfigurationSetter setAppName(String appName) {
        this.config.setAppName(appName);
        return this.config;
    }

    public IConfigurationSetter setTestName(String testName) {
        return this.config.setTestName(testName);
    }

    public String getAppName() {
        return this.config.getAppName();
    }

    public String getTestName() {
        return this.getConfigGetter().getTestName();
    }

    public IConfigurationSetter setBranchName(String branchName) {
        this.config.setBranchName(branchName);
        return this.config;
    }

    public IConfigurationSetter setAgentId(String agentId) {
        return this.config;
    }

    public String getBranchName() {
        return this.config.getBranchName();
    }

    public String getAgentId() {
        return null;
    }

    public IConfigurationSetter setParentBranchName(String branchName) {
        this.config.setParentBranchName(branchName);
        return this.config;
    }

    public String getParentBranchName() {
        return this.config.getParentBranchName();
    }

    public IConfigurationSetter setBaselineBranchName(String branchName) {
        this.config.setBaselineBranchName(branchName);
        return this.config;
    }

    public String getBaselineBranchName() {
        return this.config.getBaselineBranchName();
    }

    public IConfigurationSetter setSaveDiffs(Boolean saveDiffs) {
        this.config.setSaveDiffs(saveDiffs);
        return this.config;
    }

    public Boolean getSaveDiffs() {
        return this.config.getSaveDiffs();
    }

    public IConfigurationSetter setMatchTimeout(int ms) {
        int MIN_MATCH_TIMEOUT = 500;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return this.config;
        }
        this.logger.verbose("Setting match timeout to: " + ms);
        if (ms != 0 && 500 > ms) {
            throw new IllegalArgumentException("Match timeout must be set in milliseconds, and must be > 500");
        }
        this.config.setMatchTimeout(ms);
        return this.config;
    }

    public int getMatchTimeout() {
        return this.config.getMatchTimeout();
    }

    public IConfigurationSetter setSaveNewTests(boolean saveNewTests) {
        this.config.setSaveNewTests(saveNewTests);
        return this.config;
    }

    public boolean getSaveNewTests() {
        return this.config.getSaveNewTests();
    }

    public IConfigurationSetter setSaveFailedTests(boolean saveFailedTests) {
        this.config.setSaveFailedTests(saveFailedTests);
        return this.config;
    }

    public boolean getSaveFailedTests() {
        return this.config.getSaveFailedTests();
    }

    public IConfigurationSetter setBatch(BatchInfo batch) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return this.config;
        }
        this.logger.verbose("setBatch(" + batch + ")");
        this.config.setBatch(batch);
        return this.config;
    }

    protected IConfigurationGetter getConfigGetter() {
        return this.config;
    }

    protected IConfigurationSetter getConfigSetter() {
        return this.config;
    }

    public BatchInfo getBatch() {
        return this.config.getBatch();
    }

    public IConfigurationSetter setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        ArgumentGuard.notNull((Object)defaultMatchSettings, (String)"defaultMatchSettings");
        this.config.setDefaultMatchSettings(defaultMatchSettings);
        return this.config;
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.config.getDefaultMatchSettings();
    }

    public IConfigurationSetter setMatchLevel(MatchLevel matchLevel) {
        this.config.getDefaultMatchSettings().setMatchLevel(matchLevel);
        return this.config;
    }

    public IConfigurationSetter setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.config.setIgnoreDisplacements(isIgnoreDisplacements);
        return this.config;
    }

    public IConfigurationSetter setAccessibilityValidation(AccessibilityLevel accessibilityValidation) {
        return this.config.setAccessibilityValidation(accessibilityValidation);
    }

    public IConfigurationSetter setUseDom(boolean useDom) {
        return this.config.setUseDom(useDom);
    }

    public IConfigurationSetter setEnablePatterns(boolean enablePatterns) {
        return this.config.setUseDom(enablePatterns);
    }

    public MatchLevel getMatchLevel() {
        return this.config.getDefaultMatchSettings().getMatchLevel();
    }

    public boolean getIgnoreDisplacements() {
        return this.config.getIgnoreDisplacements();
    }

    public AccessibilityLevel getAccessibilityValidation() {
        return this.config.getAccessibilityValidation();
    }

    public boolean getUseDom() {
        return this.config.getUseDom();
    }

    public boolean getEnablePatterns() {
        return this.config.getEnablePatterns();
    }

    public boolean getIgnoreCaret() {
        Boolean ignoreCaret = this.config.getDefaultMatchSettings().getIgnoreCaret();
        return ignoreCaret == null ? true : ignoreCaret;
    }

    public IConfigurationSetter setIgnoreCaret(boolean value) {
        this.config.getDefaultMatchSettings().setIgnoreCaret(Boolean.valueOf(value));
        return this.config;
    }

    public int getStitchOverlap() {
        return this.config.getStitchOverlap();
    }

    public IConfigurationSetter setStitchOverlap(int pixels) {
        this.config.setStitchOverlap(pixels);
        return this.config;
    }

    public IConfigurationSetter setHostOS(String hostOS) {
        this.logger.log("Host OS: " + hostOS);
        if (hostOS == null || hostOS.isEmpty()) {
            this.config.setHostOS(null);
        } else {
            this.config.setHostOS(hostOS.trim());
        }
        return this.config;
    }

    public String getHostOS() {
        return this.config.getHostOS();
    }

    public IConfigurationSetter setHostApp(String hostApp) {
        this.logger.log("Host App: " + hostApp);
        if (hostApp == null || hostApp.isEmpty()) {
            this.config.setHostApp(null);
        } else {
            this.config.setHostApp(hostApp.trim());
        }
        return this.config;
    }

    public String getHostApp() {
        return this.config.getHostApp();
    }

    public void setBaselineName(String baselineName) {
        this.setBaselineEnvName(baselineName);
    }

    public String getBaselineName() {
        return this.getBaselineEnvName();
    }

    public IConfigurationSetter setBaselineEnvName(String baselineEnvName) {
        this.logger.log("Baseline environment name: " + baselineEnvName);
        if (baselineEnvName == null || baselineEnvName.isEmpty()) {
            this.config.setBaselineEnvName(null);
        } else {
            this.config.setBaselineEnvName(baselineEnvName.trim());
        }
        return this.config;
    }

    public IConfigurationSetter setEnvironmentName(String environmentName) {
        return this.config;
    }

    public String getBaselineEnvName() {
        return this.config.getBaselineEnvName();
    }

    public String getEnvironmentName() {
        return null;
    }

    public void setEnvName(String envName) {
        this.logger.log("Environment name: " + envName);
        if (envName == null || envName.isEmpty()) {
            this.config.setEnvironmentName(null);
        } else {
            this.config.setEnvironmentName(envName.trim());
        }
    }

    public String getEnvName() {
        return this.config.getEnvironmentName();
    }

    @Deprecated
    public void setAppEnvironment(String hostOS, String hostApp) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.log("Warning: SetAppEnvironment is deprecated! Please use 'setHostOS' and 'setHostApp'");
        this.logger.verbose("setAppEnvironment(" + hostOS + ", " + hostApp + ")");
        this.setHostOS(hostOS);
        this.setHostApp(hostApp);
    }

    public String getApiKey() {
        return super.getApiKey();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = new Configuration((IConfigurationGetter)config);
    }
}

