/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.images;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.exceptions.CoordinatesTypeConversionException;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;

public class EyesImagesScreenshot
extends EyesScreenshot {
    protected Region bounds;

    public EyesImagesScreenshot(Logger logger, BufferedImage image, Location location) {
        super(logger, image);
        ArgumentGuard.notNull((Object)location, (String)"location");
        this.bounds = new Region(location, new RectangleSize(image.getWidth(), image.getHeight()));
    }

    public EyesImagesScreenshot(Logger logger, BufferedImage image) {
        this(logger, image, new Location(0, 0));
    }

    public EyesScreenshot getSubScreenshot(Region region, boolean throwIfClipped) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        Region subScreenshotRegion = this.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        if (subScreenshotRegion.isSizeEmpty() || throwIfClipped && !subScreenshotRegion.getSize().equals((Object)region.getSize())) {
            throw new OutOfBoundsException(String.format("Region [%s] is out of screenshot bounds [%s]", region, this.bounds));
        }
        BufferedImage subScreenshotImage = ImageUtils.getImagePart((BufferedImage)this.image, (Region)subScreenshotRegion);
        Region relativeSubScreenshotRegion = this.convertRegionLocation(subScreenshotRegion, CoordinatesType.SCREENSHOT_AS_IS, CoordinatesType.CONTEXT_RELATIVE);
        return new EyesImagesScreenshot(this.logger, subScreenshotImage, relativeSubScreenshotRegion.getLocation());
    }

    public Location convertLocation(Location location, CoordinatesType from, CoordinatesType to) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)from, (String)"from");
        ArgumentGuard.notNull((Object)to, (String)"to");
        Location result = new Location(location);
        if (from == to) {
            return result;
        }
        switch (from) {
            case SCREENSHOT_AS_IS: {
                if (to == CoordinatesType.CONTEXT_RELATIVE) {
                    result.offset(this.bounds.getLeft(), this.bounds.getTop());
                    break;
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            case CONTEXT_RELATIVE: {
                if (to == CoordinatesType.SCREENSHOT_AS_IS) {
                    result.offset(-this.bounds.getLeft(), -this.bounds.getTop());
                    break;
                }
                throw new CoordinatesTypeConversionException(from, to);
            }
            default: {
                throw new CoordinatesTypeConversionException(from, to);
            }
        }
        return result;
    }

    public Location getLocationInScreenshot(Location location, CoordinatesType coordinatesType) throws OutOfBoundsException {
        ArgumentGuard.notNull((Object)location, (String)"location");
        ArgumentGuard.notNull((Object)coordinatesType, (String)"coordinatesType");
        location = this.convertLocation(location, coordinatesType, CoordinatesType.CONTEXT_RELATIVE);
        if (!this.bounds.contains(location)) {
            throw new OutOfBoundsException(String.format("Location %s ('%s') is not visible in screenshot!", location, coordinatesType));
        }
        return this.convertLocation(location, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
    }

    public Region getIntersectedRegion(Region region, CoordinatesType resultCoordinatesType) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        if (region.isSizeEmpty()) {
            return new Region((IRegion)region);
        }
        Region intersectedRegion = this.convertRegionLocation(region, region.getCoordinatesType(), CoordinatesType.CONTEXT_RELATIVE);
        intersectedRegion.intersect(this.bounds);
        if (region.isSizeEmpty()) {
            return region;
        }
        intersectedRegion.setLocation(this.convertLocation(intersectedRegion.getLocation(), CoordinatesType.CONTEXT_RELATIVE, resultCoordinatesType));
        return intersectedRegion;
    }
}

