/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.RestClient;
import com.applitools.connectivity.ServerConnector;
import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.utils.GeneralUtils;
import java.io.IOException;

public class UploadCallback
implements AsyncRequestCallback {
    private static final int UPLOAD_TIMEOUT = 60000;
    private static final int TIME_THRESHOLD = 20000;
    private final TaskListener<String> listener;
    private final ServerConnector serverConnector;
    private final String targetUrl;
    private final byte[] bytes;
    private final String contentType;
    private final String mediaType;
    private int sleepDuration = 5000;
    private int timePassed = 0;

    public UploadCallback(TaskListener<String> listener, ServerConnector serverConnector, String targetUrl, byte[] bytes, String contentType, String mediaType) {
        this.listener = listener;
        this.serverConnector = serverConnector;
        this.targetUrl = targetUrl;
        this.bytes = bytes;
        this.contentType = contentType;
        this.mediaType = mediaType;
    }

    public void onComplete(Response response) {
        int statusCode = response.getStatusCode();
        String statusPhrase = response.getStatusPhrase();
        response.close();
        if (statusCode == 200 || statusCode == 201) {
            this.listener.onComplete((Object)this.targetUrl);
            return;
        }
        String errorMessage = String.format("Status: %d %s.", statusCode, statusPhrase);
        if (statusCode < 500) {
            this.onFail(new IOException(String.format("Failed uploading image. %s", errorMessage)));
            return;
        }
        if (this.timePassed >= 60000) {
            this.onFail(new IOException("Failed uploading image"));
            return;
        }
        if (this.timePassed >= 20000) {
            this.sleepDuration = 10000;
        }
        try {
            Thread.sleep(this.sleepDuration);
        }
        catch (InterruptedException e) {
            this.onFail(e);
            return;
        }
        this.timePassed += this.sleepDuration;
        this.uploadDataAsync();
    }

    public void onFail(Throwable throwable) {
        GeneralUtils.logExceptionStackTrace((Logger)this.serverConnector.logger, (Stage)Stage.GENERAL, (Throwable)throwable, (String[])new String[0]);
        this.listener.onFail();
    }

    public void uploadDataAsync() {
        AsyncRequest request = this.serverConnector.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ((UploadCallback)UploadCallback.this).serverConnector.restClient.target(UploadCallback.this.targetUrl).asyncRequest(new String[]{UploadCallback.this.mediaType});
            }
        });
        request = request.header("X-Auth-Token", this.serverConnector.getRenderInfo().getAccessToken()).header("x-ms-blob-type", "BlockBlob");
        this.serverConnector.sendAsyncRequest(request, "PUT", this, this.bytes, this.contentType);
    }
}

