/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.locators;

import com.applitools.eyes.AppOutput;
import com.applitools.eyes.Region;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class BaseOcrRegion {
    private AppOutput appOutput;
    @JsonIgnore
    private String hint = null;
    private Float minMatch;
    private String language;
    private Region region = null;

    public BaseOcrRegion hint(String hint) {
        if (hint == null || !hint.isEmpty()) {
            this.hint = hint;
        }
        return this;
    }

    public BaseOcrRegion minMatch(float minMatch) {
        this.minMatch = Float.valueOf(minMatch);
        return this;
    }

    public BaseOcrRegion language(String language) {
        this.language = language;
        return this;
    }

    public BaseOcrRegion region(Region region) {
        this.region = region;
        return this;
    }

    public String getHint() {
        return this.hint;
    }

    public Float getMinMatch() {
        return this.minMatch;
    }

    public String getLanguage() {
        return this.language;
    }

    public AppOutput getAppOutput() {
        return this.appOutput;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setAppOutput(AppOutput appOutput) {
        this.appOutput = appOutput;
    }

    @JsonProperty(value="regions")
    public List<Map<String, Object>> getRegions() {
        if (this.appOutput == null) {
            return null;
        }
        Region regionToSend = this.region != null ? this.region : new Region(0, 0, this.appOutput.getScreenshot().getImage().getWidth(), this.appOutput.getScreenshot().getImage().getHeight());
        ArrayList<Map<String, Object>> regions = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("left", regionToSend.getLeft());
        props.put("top", regionToSend.getTop());
        props.put("width", regionToSend.getWidth());
        props.put("height", regionToSend.getHeight());
        if (this.hint != null) {
            props.put("expected", this.hint);
        }
        regions.add(props);
        return regions;
    }
}

