/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SessionStopInfo;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.services.CheckService;
import com.applitools.eyes.services.CloseService;
import com.applitools.eyes.services.OpenService;
import com.applitools.eyes.services.ServiceTaskListener;
import com.applitools.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;

public class ClassicRunner
extends EyesRunner {
    private final OpenService openService;
    private final CheckService checkService;
    private final CloseService closeService;
    private final List<TestResultContainer> allTestResult = new ArrayList<TestResultContainer>();

    public ClassicRunner() {
        this.openService = new OpenService(this.logger, this.serverConnector, 1);
        this.checkService = new CheckService(this.logger, this.serverConnector);
        this.closeService = new CloseService(this.logger, this.serverConnector);
    }

    @Override
    public TestResultsSummary getAllTestResultsImpl(boolean shouldThrowException) {
        if (shouldThrowException) {
            for (TestResultContainer testResults : this.allTestResult) {
                if (testResults.getException() == null) continue;
                throw new Error(testResults.getException());
            }
        }
        return new TestResultsSummary(this.allTestResult);
    }

    public void aggregateResult(TestResultContainer testResult) {
        this.allTestResult.add(testResult);
    }

    @Override
    public void setServerConnector(ServerConnector serverConnector) {
        super.setServerConnector(serverConnector);
        this.openService.setServerConnector(serverConnector);
        this.checkService.setServerConnector(serverConnector);
        this.closeService.setServerConnector(serverConnector);
    }

    public RunningSession open(final String testId, SessionStartInfo sessionStartInfo) {
        final SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("openBase %s", sessionStartInfo));
        this.openService.operate(testId, sessionStartInfo, new ServiceTaskListener<RunningSession>(){

            public void onComplete(RunningSession taskResponse) {
                listener.onComplete((Object)taskResponse);
            }

            public void onFail(Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)ClassicRunner.this.logger, (Stage)Stage.OPEN, (Throwable)t, (String[])new String[]{testId});
                listener.onFail();
            }
        });
        return (RunningSession)listener.get();
    }

    public MatchResult check(final String testId, MatchWindowData matchWindowData) {
        final SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("uploadImage %s", matchWindowData.getRunningSession()));
        this.checkService.tryUploadImage(testId, matchWindowData, new ServiceTaskListener<Void>(){

            public void onComplete(Void taskResponse) {
                listener.onComplete((Object)true);
            }

            public void onFail(Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)ClassicRunner.this.logger, (Stage)Stage.CHECK, (Type)Type.UPLOAD_COMPLETE, (Throwable)t, (String[])new String[]{testId});
                listener.onFail();
            }
        });
        Boolean result = (Boolean)listener.get();
        if (result == null || !result.booleanValue()) {
            throw new EyesException("Failed performing match with the server");
        }
        final SyncTaskListener matchListener = new SyncTaskListener(this.logger, String.format("performMatch %s", matchWindowData.getRunningSession()));
        this.checkService.matchWindow(testId, matchWindowData, new ServiceTaskListener<MatchResult>(){

            public void onComplete(MatchResult taskResponse) {
                matchListener.onComplete((Object)taskResponse);
            }

            public void onFail(Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)ClassicRunner.this.logger, (Stage)Stage.CHECK, (Type)Type.MATCH_COMPLETE, (Throwable)t, (String[])new String[]{testId});
                matchListener.onFail();
            }
        });
        return (MatchResult)matchListener.get();
    }

    public TestResults close(final String testId, SessionStopInfo sessionStopInfo) {
        final SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("stop session %s. isAborted: %b", sessionStopInfo.getRunningSession(), sessionStopInfo.isAborted()));
        this.closeService.operate(testId, sessionStopInfo, new ServiceTaskListener<TestResults>(){

            public void onComplete(TestResults taskResponse) {
                listener.onComplete((Object)taskResponse);
            }

            public void onFail(Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)ClassicRunner.this.logger, (Stage)Stage.CLOSE, (Throwable)t, (String[])new String[]{testId});
                listener.onFail();
            }
        });
        return (TestResults)listener.get();
    }
}

