/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.triggers;

import com.applitools.eyes.Location;
import com.applitools.eyes.Region;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Mouse;

public class EyesMouse
implements Mouse {
    private final EyesSeleniumDriver eyesDriver;
    private final Mouse mouse;
    private Location mouseLocation;

    public EyesMouse(EyesSeleniumDriver eyesDriver, Mouse mouse) {
        ArgumentGuard.notNull((Object)((Object)eyesDriver), (String)"eyesDriver");
        ArgumentGuard.notNull((Object)mouse, (String)"mouse");
        this.eyesDriver = eyesDriver;
        this.mouse = mouse;
        this.mouseLocation = new Location(0, 0);
    }

    protected void moveIfNeeded(Coordinates where) {
        if (where != null) {
            this.mouseMove(where);
        }
    }

    public void click(Coordinates where) {
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.Click);
        this.mouse.click(where);
    }

    public void doubleClick(Coordinates where) {
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.DoubleClick);
        this.mouse.doubleClick(where);
    }

    public void mouseDown(Coordinates where) {
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.Down);
        this.mouse.mouseDown(where);
    }

    public void mouseUp(Coordinates where) {
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.Up);
        this.mouse.mouseUp(where);
    }

    public void mouseMove(Coordinates where) {
        Location location = EyesDriverUtils.getPageLocation((Coordinates)where);
        if (location != null) {
            int newX = Math.max(0, location.getX());
            int newY = Math.max(0, location.getY());
            this.mouseLocation = new Location(newX, newY);
            this.addMouseTrigger(MouseAction.Move);
        }
        this.mouse.mouseMove(where);
    }

    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        int newY;
        int newX;
        Location location = EyesDriverUtils.getPageLocation((Coordinates)where);
        if (location != null) {
            newX = (int)((long)location.getX() + xOffset);
            newY = (int)((long)location.getY() + yOffset);
        } else {
            newX = (int)((long)this.mouseLocation.getX() + xOffset);
            newY = (int)((long)this.mouseLocation.getY() + yOffset);
        }
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        this.mouseLocation = new Location(newX, newY);
        this.addMouseTrigger(MouseAction.Move);
        this.mouse.mouseMove(where, xOffset, yOffset);
    }

    public void contextClick(Coordinates where) {
        this.moveIfNeeded(where);
        this.addMouseTrigger(MouseAction.RightClick);
        this.mouse.contextClick(where);
    }

    protected void addMouseTrigger(MouseAction action) {
        this.eyesDriver.getEyes().addMouseTrigger(action, Region.EMPTY, this.mouseLocation);
    }
}

