/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.wrappers;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;

public class EyesRemoteWebElement
extends RemoteWebElement {
    private final Logger logger;
    private final EyesSeleniumDriver eyesDriver;
    private final RemoteWebElement webElement;
    private static final String JS_GET_COMPUTED_STYLE_FORMATTED_STR = "var elem = arguments[0]; var styleProp = '%s'; if (window.getComputedStyle) { return window.getComputedStyle(elem, null).getPropertyValue(styleProp);} else if (elem.currentStyle) { return elem.currentStyle[styleProp];} else { return null;}";
    private static final String JS_GET_SCROLL_LEFT = "return arguments[0].scrollLeft;";
    private static final String JS_GET_SCROLL_TOP = "return arguments[0].scrollTop;";
    private static final String JS_GET_SCROLL_WIDTH = "return arguments[0].scrollWidth;";
    private static final String JS_GET_SCROLL_HEIGHT = "return arguments[0].scrollHeight;";
    private static final String JS_GET_SCROLL_SIZE = "return arguments[0].scrollWidth+ ';' + arguments[0].scrollHeight;";
    private static final String JS_SCROLL_TO_FORMATTED_STR = "arguments[0].scrollLeft = %d;arguments[0].scrollTop = %d;";
    private static final String JS_GET_SCROLL_POSITION = "return arguments[0].scrollLeft + ';' + arguments[0].scrollTop;";
    private static final String JS_GET_OVERFLOW = "return arguments[0].style.overflow;";
    private static final String JS_SET_OVERFLOW_FORMATTED_STR = "arguments[0].style.overflow = '%s'";
    private static final String JS_GET_CLIENT_WIDTH = "return arguments[0].clientWidth;";
    private static final String JS_GET_CLIENT_HEIGHT = "return arguments[0].clientHeight;";
    public static final String JS_GET_CLIENT_SIZE = "return arguments[0].clientWidth + ';' + arguments[0].clientHeight;";
    private static final String JS_GET_BORDER_WIDTHS_ARR = "var retVal = retVal || [];if (window.getComputedStyle) { var computedStyle = window.getComputedStyle(elem, null);retVal.push(computedStyle.getPropertyValue('border-left-width'));retVal.push(computedStyle.getPropertyValue('border-top-width'));retVal.push(computedStyle.getPropertyValue('border-right-width')); retVal.push(computedStyle.getPropertyValue('border-bottom-width'));} else if (elem.currentStyle) { retVal.push(elem.currentStyle['border-left-width']);retVal.push(elem.currentStyle['border-top-width']);retVal.push(elem.currentStyle['border-right-width']);retVal.push(elem.currentStyle['border-bottom-width']);} else { retVal.push(0,0,0,0);}";
    private final String JS_GET_BORDER_WIDTHS = "var retVal = retVal || [];if (window.getComputedStyle) { var computedStyle = window.getComputedStyle(elem, null);retVal.push(computedStyle.getPropertyValue('border-left-width'));retVal.push(computedStyle.getPropertyValue('border-top-width'));retVal.push(computedStyle.getPropertyValue('border-right-width')); retVal.push(computedStyle.getPropertyValue('border-bottom-width'));} else if (elem.currentStyle) { retVal.push(elem.currentStyle['border-left-width']);retVal.push(elem.currentStyle['border-top-width']);retVal.push(elem.currentStyle['border-right-width']);retVal.push(elem.currentStyle['border-bottom-width']);} else { retVal.push(0,0,0,0);}return retVal;";
    private static final String JS_GET_SIZE_AND_BORDER_WIDTHS = "var elem = arguments[0]; var retVal = [elem.clientWidth, elem.clientHeight]; var retVal = retVal || [];if (window.getComputedStyle) { var computedStyle = window.getComputedStyle(elem, null);retVal.push(computedStyle.getPropertyValue('border-left-width'));retVal.push(computedStyle.getPropertyValue('border-top-width'));retVal.push(computedStyle.getPropertyValue('border-right-width')); retVal.push(computedStyle.getPropertyValue('border-bottom-width'));} else if (elem.currentStyle) { retVal.push(elem.currentStyle['border-left-width']);retVal.push(elem.currentStyle['border-top-width']);retVal.push(elem.currentStyle['border-right-width']);retVal.push(elem.currentStyle['border-bottom-width']);} else { retVal.push(0,0,0,0);}return retVal;";
    private static final String JS_GET_BOUNDING_CLIENT_RECT_WITHOUT_BORDERS = "var el = arguments[0];var bcr = el.getBoundingClientRect();return (bcr.left + el.clientLeft) + ';' + (bcr.top + el.clientTop) + ';' + el.clientWidth + ';' + el.clientHeight;";
    private PositionProvider positionProvider;

    public EyesRemoteWebElement(Logger logger, EyesSeleniumDriver eyesDriver, WebElement webElement) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)((Object)eyesDriver), (String)"eyesDriver");
        ArgumentGuard.notNull((Object)webElement, (String)"webElement");
        this.logger = logger;
        this.eyesDriver = eyesDriver;
        webElement = EyesDriverUtils.getWrappedWebElement((WebElement)webElement);
        if (!(webElement instanceof RemoteWebElement)) {
            throw new EyesException("The input web element is not a RemoteWebElement.");
        }
        this.webElement = (RemoteWebElement)webElement;
        this.setParent(eyesDriver.getRemoteWebDriver());
        this.setId(this.webElement.getId());
        try {
            Method executeMethod = RemoteWebElement.class.getDeclaredMethod("execute", String.class, Map.class);
            executeMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new EyesException("Failed to find 'execute' method!");
        }
    }

    public static Region getClientBoundsWithoutBorders(WebElement element, EyesSeleniumDriver driver) {
        String result = (String)driver.executeScript(JS_GET_BOUNDING_CLIENT_RECT_WITHOUT_BORDERS, element);
        String[] data = result.split(";");
        return new Region(Math.round(Float.parseFloat(data[0])), Math.round(Float.parseFloat(data[1])), Math.round(Float.parseFloat(data[2])), Math.round(Float.parseFloat(data[3])));
    }

    public Region getBounds() {
        Point weLocation = this.webElement.getLocation();
        int left = weLocation.getX();
        int top = weLocation.getY();
        int width = 0;
        int height = 0;
        try {
            Dimension weSize = this.webElement.getSize();
            width = weSize.getWidth();
            height = weSize.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (left < 0) {
            width = Math.max(0, width + left);
            left = 0;
        }
        if (top < 0) {
            height = Math.max(0, height + top);
            top = 0;
        }
        return new Region(left, top, width, height, CoordinatesType.CONTEXT_RELATIVE);
    }

    public String getComputedStyle(String propStyle) {
        String scriptToExec = String.format(JS_GET_COMPUTED_STYLE_FORMATTED_STR, propStyle);
        return (String)this.eyesDriver.executeScript(scriptToExec, new Object[]{this});
    }

    public int getComputedStyleInteger(String propStyle) {
        return Math.round(Float.parseFloat(this.getComputedStyle(propStyle).trim().replace("px", "")));
    }

    public int getScrollLeft() {
        return (int)Math.ceil(Double.parseDouble(this.eyesDriver.executeScript(JS_GET_SCROLL_LEFT, new Object[]{this}).toString()));
    }

    public int getScrollTop() {
        return (int)Math.ceil(Double.parseDouble(this.eyesDriver.executeScript(JS_GET_SCROLL_TOP, new Object[]{this}).toString()));
    }

    public Location getScrollLocation() {
        Object position = this.eyesDriver.executeScript(JS_GET_SCROLL_POSITION, new Object[]{this});
        return EyesDriverUtils.parseLocationString((Object)position);
    }

    public int getScrollWidth() {
        return (int)Math.ceil(Double.parseDouble(this.eyesDriver.executeScript(JS_GET_SCROLL_WIDTH, new Object[]{this}).toString()));
    }

    public int getScrollHeight() {
        return (int)Math.ceil(Double.parseDouble(this.eyesDriver.executeScript(JS_GET_SCROLL_HEIGHT, new Object[]{this}).toString()));
    }

    public int getClientWidth() {
        return (int)Math.ceil(Double.parseDouble(this.eyesDriver.executeScript(JS_GET_CLIENT_WIDTH, new Object[]{this}).toString()));
    }

    public int getClientHeight() {
        return (int)Math.ceil(Double.parseDouble(this.eyesDriver.executeScript(JS_GET_CLIENT_HEIGHT, new Object[]{this}).toString()));
    }

    public boolean canScrollVertically() {
        return this.getScrollHeight() > this.getClientHeight();
    }

    public int getBorderLeftWidth() {
        return this.getComputedStyleInteger("border-left-width");
    }

    public int getBorderRightWidth() {
        return this.getComputedStyleInteger("border-right-width");
    }

    public int getBorderTopWidth() {
        return this.getComputedStyleInteger("border-top-width");
    }

    public int getBorderBottomWidth() {
        return this.getComputedStyleInteger("border-bottom-width");
    }

    public Location scrollTo(Location location) {
        Object position = this.eyesDriver.executeScript(String.format(JS_SCROLL_TO_FORMATTED_STR, location.getX(), location.getY()) + JS_GET_SCROLL_POSITION, new Object[]{this});
        return EyesDriverUtils.parseLocationString((Object)position);
    }

    public String getOverflow() {
        return this.eyesDriver.executeScript(JS_GET_OVERFLOW, new Object[]{this}).toString();
    }

    public String setOverflow(String overflow) {
        return EyesDriverUtils.setOverflow((JavascriptExecutor)this.eyesDriver, (String)overflow, (WebElement)this);
    }

    public void click() {
        SeleniumEyes eyes = this.eyesDriver.getEyes();
        if (eyes != null) {
            Region currentControl = this.getBounds();
            eyes.addMouseTrigger(MouseAction.Click, (WebElement)this);
        }
        this.webElement.click();
    }

    public WebDriver getWrappedDriver() {
        return this.eyesDriver;
    }

    public void setFileDetector(FileDetector detector) {
        this.webElement.setFileDetector(detector);
    }

    public void submit() {
        this.webElement.submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        SeleniumEyes eyes = this.eyesDriver.getEyes();
        if (eyes != null) {
            for (CharSequence keys : keysToSend) {
                String text = String.valueOf(keys);
                eyes.addTextTrigger((WebElement)this, text);
            }
        }
        this.webElement.sendKeys(keysToSend);
    }

    public void clear() {
        this.webElement.clear();
    }

    public String getTagName() {
        return this.webElement.getTagName();
    }

    public String getAttribute(String name) {
        return this.webElement.getAttribute(name);
    }

    public boolean isSelected() {
        return this.webElement.isSelected();
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public String getText() {
        return this.webElement.getText();
    }

    public static String getInnerText(Logger logger, EyesSeleniumDriver driver, WebElement element) {
        try {
            return (String)driver.executeScript("return arguments[0].innerText", element);
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)t, (String[])new String[0]);
            return null;
        }
    }

    public String getCssValue(String propertyName) {
        return this.webElement.getCssValue(propertyName);
    }

    private WebElement wrapElement(WebElement elementToWrap) {
        Object resultElement = elementToWrap;
        if (elementToWrap instanceof RemoteWebElement) {
            resultElement = new EyesRemoteWebElement(this.logger, this.eyesDriver, elementToWrap);
        }
        return resultElement;
    }

    private List<WebElement> wrapElements(List<WebElement> elementsToWrap) {
        ArrayList<WebElement> wrappedElementsList = new ArrayList<WebElement>(elementsToWrap.size());
        for (WebElement currentElement : elementsToWrap) {
            if (currentElement instanceof RemoteWebElement) {
                wrappedElementsList.add((WebElement)new EyesRemoteWebElement(this.logger, this.eyesDriver, currentElement));
                continue;
            }
            wrappedElementsList.add(currentElement);
        }
        return wrappedElementsList;
    }

    public List<WebElement> findElements(By by) {
        return this.wrapElements(this.webElement.findElements(by));
    }

    public WebElement findElement(By by) {
        return this.wrapElement(this.webElement.findElement(by));
    }

    public WebElement findElementById(String using) {
        return this.wrapElement(this.webElement.findElementById(using));
    }

    public List<WebElement> findElementsById(String using) {
        return this.wrapElements(this.webElement.findElementsById(using));
    }

    public WebElement findElementByLinkText(String using) {
        return this.wrapElement(this.webElement.findElementByLinkText(using));
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.wrapElements(this.webElement.findElementsByLinkText(using));
    }

    public WebElement findElementByName(String using) {
        return this.wrapElement(this.webElement.findElementByName(using));
    }

    public List<WebElement> findElementsByName(String using) {
        return this.wrapElements(this.webElement.findElementsByName(using));
    }

    public WebElement findElementByClassName(String using) {
        return this.wrapElement(this.webElement.findElementByClassName(using));
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.wrapElements(this.webElement.findElementsByClassName(using));
    }

    public WebElement findElementByCssSelector(String using) {
        return this.wrapElement(this.webElement.findElementByCssSelector(using));
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.wrapElements(this.webElement.findElementsByCssSelector(using));
    }

    public WebElement findElementByXPath(String using) {
        return this.wrapElement(this.webElement.findElementByXPath(using));
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.wrapElements(this.webElement.findElementsByXPath(using));
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.wrapElement(this.webElement.findElementByPartialLinkText(using));
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.wrapElements(this.webElement.findElementsByPartialLinkText(using));
    }

    public WebElement findElementByTagName(String using) {
        return this.wrapElement(this.webElement.findElementByTagName(using));
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.wrapElements(this.webElement.findElementsByTagName(using));
    }

    public boolean equals(Object obj) {
        return obj instanceof RemoteWebElement && this.webElement.equals(obj);
    }

    public int hashCode() {
        return this.webElement.hashCode();
    }

    public boolean isDisplayed() {
        return this.webElement.isDisplayed();
    }

    public Point getLocation() {
        String elementId = this.getId();
        Response response = this.execute("getElementLocation", (Map)ImmutableMap.of((Object)"id", (Object)elementId));
        Map rawPoint = (Map)response.getValue();
        int x = (int)Math.round(((Number)rawPoint.get("x")).doubleValue());
        int y = (int)Math.round(((Number)rawPoint.get("y")).doubleValue());
        return new Point(x, y);
    }

    public Dimension getSize() {
        String elementId = this.getId();
        Response response = this.execute("getElementSize", (Map)ImmutableMap.of((Object)"id", (Object)elementId));
        Map rawSize = (Map)response.getValue();
        int width = (int)Math.ceil(((Number)rawSize.get("width")).doubleValue());
        int height = (int)Math.ceil(((Number)rawSize.get("height")).doubleValue());
        return new Dimension(width, height);
    }

    public RectangleSize getClientSize() {
        Object retVal = this.eyesDriver.executeScript(JS_GET_CLIENT_SIZE, new Object[]{this});
        if (retVal == null) {
            return null;
        }
        String sizeStr = (String)retVal;
        sizeStr = sizeStr.replace("px", "");
        String[] parts = sizeStr.split(";");
        return new RectangleSize(Math.round(Float.parseFloat(parts[0])), Math.round(Float.parseFloat(parts[1])));
    }

    public Coordinates getCoordinates() {
        return this.webElement.getCoordinates();
    }

    public String toString() {
        return "EyesRemoteWebElement: " + this.webElement.getId();
    }

    public PositionProvider getPositionProvider() {
        return this.positionProvider;
    }

    public void setPositionProvider(PositionProvider positionProvider) {
        this.positionProvider = positionProvider;
    }

    public SizeAndBorders getSizeAndBorders() {
        Object retVal = this.eyesDriver.executeScript(JS_GET_SIZE_AND_BORDER_WIDTHS, new Object[]{this});
        List esAsList = (List)retVal;
        return new SizeAndBorders(((Long)esAsList.get(0)).intValue(), ((Long)esAsList.get(1)).intValue(), Math.round(Float.parseFloat(((String)esAsList.get(2)).replace("px", ""))), Math.round(Float.parseFloat(((String)esAsList.get(3)).replace("px", ""))), Math.round(Float.parseFloat(((String)esAsList.get(4)).replace("px", ""))), Math.round(Float.parseFloat(((String)esAsList.get(5)).replace("px", ""))));
    }

    public Rectangle getBoundingClientRect() {
        return EyesRemoteWebElement.getBoundingClientRect((WebElement)this, (JavascriptExecutor)this.eyesDriver, this.logger);
    }

    public static Region getClientBounds(WebElement element, JavascriptExecutor driver, Logger logger) {
        Rectangle r = EyesRemoteWebElement.getBoundingClientRect(element, driver, logger);
        return new Region(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static Rectangle getBoundingClientRect(WebElement element, JavascriptExecutor driver, Logger logger) {
        String retVal = (String)driver.executeScript("var r = arguments[0].getBoundingClientRect();return r.left+';'+r.top+';'+r.width+';'+r.height+';'+r.right+';'+r.bottom", new Object[]{element});
        String[] parts = retVal.split(";");
        String left = parts[0];
        String top = parts[1];
        String height = parts[3].equals("undefined") ? parts[5] : parts[3];
        String width = parts[2].equals("undefined") ? parts[4] : parts[2];
        return new Rectangle(Math.round(Float.parseFloat(left)), Math.round(Float.parseFloat(top)), Math.round(Float.parseFloat(height)), Math.round(Float.parseFloat(width)));
    }

    public RectangleSize getScrollSize() {
        return EyesRemoteWebElement.getScrollSize((WebElement)this, (JavascriptExecutor)this.eyesDriver, this.logger);
    }

    public Location getCurrentCssStitchingLocation() {
        try {
            String data = (String)this.eyesDriver.executeScript("var el=arguments[0]; return el.style.transform", this.webElement);
            if (data == null || !data.startsWith("translate(")) {
                return null;
            }
            String x = data.substring(data.indexOf("(") + 1, data.indexOf(","));
            String y = data.substring(data.indexOf(",") + 1, data.lastIndexOf(")"));
            x = x.split("px")[0];
            y = y.split("px")[0];
            return new Location(-NumberFormat.getInstance().parse(x.trim()).intValue(), -NumberFormat.getInstance().parse(y.trim()).intValue());
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)t, (String[])new String[0]);
            return null;
        }
    }

    public static RectangleSize getScrollSize(WebElement element, JavascriptExecutor driver, Logger logger) {
        Object retVal = driver.executeScript(JS_GET_SCROLL_SIZE, new Object[]{element});
        if (retVal == null) {
            return RectangleSize.EMPTY;
        }
        String sizeStr = (String)retVal;
        sizeStr = sizeStr.replace("px", "");
        String[] parts = sizeStr.split(";");
        return new RectangleSize(Math.round(Float.parseFloat(parts[0])), Math.round(Float.parseFloat(parts[1])));
    }
}

