package com.arakelian.docker.junit;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link DockerConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDockerConfig.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "DockerConfig"})
public final class ImmutableDockerConfig implements DockerConfig {
  private final String image;
  private final String name;
  private final String[] ports;
  private final boolean alwaysRemoveContainer;

  private ImmutableDockerConfig(ImmutableDockerConfig.Builder builder) {
    this.image = builder.image;
    this.name = builder.name;
    this.ports = builder.ports;
    this.alwaysRemoveContainer = builder.alwaysRemoveContainerIsSet()
        ? builder.alwaysRemoveContainer
        : DockerConfig.super.isAlwaysRemoveContainer();
  }

  /**
   * @return The value of the {@code image} attribute
   */
  @Override
  public String getImage() {
    return image;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return A cloned {@code ports} array
   */
  @Override
  public String[] getPorts() {
    return ports.clone();
  }

  /**
   * @return The value of the {@code alwaysRemoveContainer} attribute
   */
  @Override
  public boolean isAlwaysRemoveContainer() {
    return alwaysRemoveContainer;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDockerConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDockerConfig
        && equalTo((ImmutableDockerConfig) another);
  }

  private boolean equalTo(ImmutableDockerConfig another) {
    return image.equals(another.image)
        && name.equals(another.name)
        && Arrays.equals(ports, another.ports)
        && alwaysRemoveContainer == another.alwaysRemoveContainer;
  }

  /**
   * Computes a hash code from attributes: {@code image}, {@code name}, {@code ports}, {@code alwaysRemoveContainer}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + image.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Arrays.hashCode(ports);
    h += (h << 5) + Booleans.hashCode(alwaysRemoveContainer);
    return h;
  }

  /**
   * Prints the immutable value {@code DockerConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DockerConfig")
        .omitNullValues()
        .add("image", image)
        .add("name", name)
        .add("ports", Arrays.toString(ports))
        .add("alwaysRemoveContainer", alwaysRemoveContainer)
        .toString();
  }

  /**
   * Creates a builder for {@link ImmutableDockerConfig ImmutableDockerConfig}.
   * @return A new ImmutableDockerConfig builder
   */
  public static ImmutableDockerConfig.Builder builder() {
    return new ImmutableDockerConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDockerConfig ImmutableDockerConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_IMAGE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_PORTS = 0x4L;
    private static final long OPT_BIT_ALWAYS_REMOVE_CONTAINER = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private String image;
    private String name;
    private String[] ports;
    private boolean alwaysRemoveContainer;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DockerConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DockerConfig instance) {
      Objects.requireNonNull(instance, "instance");
      image(instance.getImage());
      name(instance.getName());
      ports(instance.getPorts());
      alwaysRemoveContainer(instance.isAlwaysRemoveContainer());
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#getImage() image} attribute.
     * @param image The value for image 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder image(String image) {
      this.image = Objects.requireNonNull(image, "image");
      initBits &= ~INIT_BIT_IMAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#getPorts() ports} attribute.
     * @param ports The elements for ports
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(String... ports) {
      this.ports = ports.clone();
      initBits &= ~INIT_BIT_PORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerConfig#isAlwaysRemoveContainer() alwaysRemoveContainer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerConfig#isAlwaysRemoveContainer() alwaysRemoveContainer}.</em>
     * @param alwaysRemoveContainer The value for alwaysRemoveContainer 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder alwaysRemoveContainer(boolean alwaysRemoveContainer) {
      this.alwaysRemoveContainer = alwaysRemoveContainer;
      optBits |= OPT_BIT_ALWAYS_REMOVE_CONTAINER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDockerConfig ImmutableDockerConfig}.
     * @return An immutable instance of DockerConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDockerConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDockerConfig(this);
    }

    private boolean alwaysRemoveContainerIsSet() {
      return (optBits & OPT_BIT_ALWAYS_REMOVE_CONTAINER) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_IMAGE) != 0) attributes.add("image");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PORTS) != 0) attributes.add("ports");
      return "Cannot build DockerConfig, some of required attributes are not set " + attributes;
    }
  }
}
