/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabaseAsync;
import com.arangodb.ArangoEdgeCollectionAsync;
import com.arangodb.ArangoGraphAsync;
import com.arangodb.ArangoVertexCollectionAsync;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.internal.ArangoEdgeCollectionAsyncImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoVertexCollectionAsyncImpl;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.ReplaceEdgeDefinitionOptions;
import com.arangodb.model.VertexCollectionCreateOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ArangoGraphAsyncImpl
extends InternalArangoGraph
implements ArangoGraphAsync {
    private final ArangoDatabaseAsync db;

    protected ArangoGraphAsyncImpl(ArangoDatabaseAsyncImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabaseAsync db() {
        return this.db;
    }

    @Override
    public CompletableFuture<Boolean> exists() {
        return ((CompletableFuture)this.getInfo().thenApply(Objects::nonNull)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && ArangoErrors.matches(aEx = (ArangoDBException)e, 404, ArangoErrors.ERROR_GRAPH_NOT_FOUND)) {
                return false;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public CompletableFuture<GraphEntity> create(Iterable<EdgeDefinition> edgeDefinitions) {
        return this.db().createGraph(this.name(), edgeDefinitions);
    }

    @Override
    public CompletableFuture<GraphEntity> create(Iterable<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return this.db().createGraph(this.name(), edgeDefinitions, options);
    }

    @Override
    public CompletableFuture<Void> drop() {
        return this.executorAsync().execute(this::dropRequest, (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> drop(boolean dropCollections) {
        return this.executorAsync().execute(() -> this.dropRequest(dropCollections), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<GraphEntity> getInfo() {
        return this.executorAsync().execute(this::getInfoRequest, this.getInfoResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<String>> getVertexCollections() {
        return this.executorAsync().execute(this::getVertexCollectionsRequest, this.getVertexCollectionsResponseDeserializer());
    }

    @Override
    public CompletableFuture<GraphEntity> addVertexCollection(String name) {
        return this.addVertexCollection(name, new VertexCollectionCreateOptions());
    }

    @Override
    public CompletableFuture<GraphEntity> addVertexCollection(String name, VertexCollectionCreateOptions options) {
        return this.executorAsync().execute(() -> this.addVertexCollectionRequest(name, options), this.addVertexCollectionResponseDeserializer());
    }

    @Override
    public ArangoVertexCollectionAsync vertexCollection(String name) {
        return new ArangoVertexCollectionAsyncImpl(this, name);
    }

    @Override
    public ArangoEdgeCollectionAsync edgeCollection(String name) {
        return new ArangoEdgeCollectionAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<Collection<String>> getEdgeDefinitions() {
        return this.executorAsync().execute(this::getEdgeDefinitionsRequest, this.getEdgeDefinitionsDeserializer());
    }

    @Override
    public CompletableFuture<GraphEntity> addEdgeDefinition(EdgeDefinition definition) {
        return this.executorAsync().execute(() -> this.addEdgeDefinitionRequest(definition), this.addEdgeDefinitionResponseDeserializer());
    }

    @Override
    public CompletableFuture<GraphEntity> replaceEdgeDefinition(EdgeDefinition definition) {
        return this.replaceEdgeDefinition(definition, new ReplaceEdgeDefinitionOptions());
    }

    @Override
    public CompletableFuture<GraphEntity> replaceEdgeDefinition(EdgeDefinition definition, ReplaceEdgeDefinitionOptions options) {
        return this.executorAsync().execute(() -> this.replaceEdgeDefinitionRequest(definition, options), this.replaceEdgeDefinitionResponseDeserializer());
    }
}

