/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.serde;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.RequestContextHolder;
import com.arangodb.internal.serde.InternalAnnotationIntrospector;
import com.arangodb.internal.serde.InternalModule;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.serde.RawUserDataValue;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.internal.serde.UserDataDeserializer;
import com.arangodb.internal.serde.UserDataSerializer;
import com.arangodb.serde.ArangoSerde;
import com.arangodb.util.RawBytes;
import com.arangodb.util.RawJson;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonp.JSONPModule;
import jakarta.json.JsonException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InternalSerdeImpl
implements InternalSerde {
    private static final Logger LOG = LoggerFactory.getLogger(InternalSerdeImpl.class);
    private final ArangoSerde userSerde;
    private final ObjectMapper mapper;

    InternalSerdeImpl(ObjectMapper mapper, ArangoSerde userSerde, Module protocolModule) {
        this.mapper = mapper;
        this.userSerde = userSerde;
        mapper.deactivateDefaultTyping();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION});
        mapper.registerModule(InternalModule.get(this));
        if (protocolModule != null) {
            mapper.registerModule(protocolModule);
        }
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new InternalAnnotationIntrospector(new UserDataSerializer(this), new UserDataDeserializer(this)));
        try {
            mapper.registerModule((Module)new JSONPModule());
        }
        catch (JsonException e) {
            LOG.debug("Jakarta JSON-P provider not found, handling of JSON-P datatypes is disabled", (Throwable)e);
        }
    }

    @Override
    public byte[] serialize(Object value) {
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw ArangoDBException.of(e);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Class<T> clazz) {
        return this.deserialize(content, (Type)clazz);
    }

    @Override
    public String toJsonString(byte[] content) {
        if (content == null) {
            return "";
        }
        try {
            return SerdeUtils.INSTANCE.writeJson(this.mapper.readTree(content));
        }
        catch (Exception e) {
            return "[Unparsable data]";
        }
    }

    @Override
    public byte[] extract(byte[] content, String jsonPointer) {
        byte[] byArray;
        block13: {
            if (!jsonPointer.startsWith("/")) {
                throw new ArangoDBException("Unsupported JSON pointer: " + jsonPointer);
            }
            String[] parts = jsonPointer.substring(1).split("/");
            JsonParser parser = this.mapper.getFactory().createParser(content);
            try {
                int match = 0;
                int level = 0;
                JsonToken token = parser.nextToken();
                if (token != JsonToken.START_OBJECT) {
                    throw new ArangoDBException("Unable to parse token: " + token);
                }
                do {
                    if ((token = parser.nextToken()) == JsonToken.START_OBJECT) {
                        ++level;
                    }
                    if (token == JsonToken.END_OBJECT) {
                        --level;
                    }
                    if (token != null && level >= match) continue;
                    throw new ArangoDBException("Unable to parse JSON pointer: " + jsonPointer);
                } while (token != JsonToken.FIELD_NAME || match != level || !parts[match].equals(parser.getText()) || ++match != parts.length);
                parser.nextToken();
                byArray = SerdeUtils.extractBytes(parser);
                if (parser == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ArangoDBException.of(e);
                }
            }
            parser.close();
        }
        return byArray;
    }

    @Override
    public JsonNode parse(byte[] content, String jsonPointer) {
        try {
            return this.mapper.readTree(content).at(jsonPointer);
        }
        catch (IOException e) {
            throw ArangoDBException.of(e);
        }
    }

    @Override
    public byte[] serializeUserData(Object value) {
        if (value == null) {
            return this.serialize(null);
        }
        Class<?> clazz = value.getClass();
        if (RawBytes.class.equals(clazz)) {
            return ((RawBytes)value).get();
        }
        if (RawJson.class.equals(clazz) && "JSON".equals(this.mapper.getFactory().getFormatName())) {
            return ((RawJson)value).get().getBytes(StandardCharsets.UTF_8);
        }
        if (SerdeUtils.isManagedClass(clazz)) {
            return this.serialize(value);
        }
        return this.userSerde.serialize(value);
    }

    @Override
    public byte[] serializeCollectionUserData(Iterable<?> value) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (JsonGenerator gen = this.mapper.getFactory().createGenerator((OutputStream)os);){
            gen.writeStartArray();
            for (Object o : value) {
                gen.writeRawValue((SerializableString)new RawUserDataValue(this.serializeUserData(o)));
            }
            gen.writeEndArray();
            gen.flush();
        }
        catch (IOException e) {
            throw ArangoDBException.of(e);
        }
        return os.toByteArray();
    }

    @Override
    public <T> T deserializeUserData(byte[] content, Class<T> clazz) {
        if (SerdeUtils.isManagedClass(clazz)) {
            return this.deserialize(content, clazz);
        }
        return this.userSerde.deserialize(content, clazz, RequestContextHolder.INSTANCE.getCtx());
    }

    @Override
    public <T> T deserializeUserData(byte[] content, JavaType clazz) {
        try {
            if (SerdeUtils.isManagedClass(clazz.getRawClass())) {
                return (T)this.mapper.readerFor(clazz).readValue(content);
            }
            return this.deserializeUserData(content, clazz.getRawClass());
        }
        catch (IOException e) {
            throw ArangoDBException.of(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDocument(byte[] content) {
        try (JsonParser p = this.mapper.getFactory().createParser(content);){
            if (p.nextToken() != JsonToken.START_OBJECT) {
                boolean bl = false;
                return bl;
            }
            int level = 1;
            while (level >= 1) {
                String fieldName;
                JsonToken t = p.nextToken();
                if (level == 1 && t == JsonToken.FIELD_NAME && ((fieldName = p.getText()).equals("_id") || fieldName.equals("_key") || fieldName.equals("_rev"))) {
                    boolean bl = true;
                    return bl;
                }
                if (t.isStructStart()) {
                    ++level;
                    continue;
                }
                if (!t.isStructEnd()) continue;
                --level;
            }
            if (p.currentToken() == JsonToken.END_OBJECT) return false;
            throw new JsonMappingException((Closeable)p, "Expected END_OBJECT but got " + p.currentToken());
        }
        catch (IOException e) {
            throw ArangoDBException.of(e);
        }
    }

    @Override
    public ArangoSerde getUserSerde() {
        return this.userSerde;
    }

    @Override
    public <T> T deserialize(JsonNode node, Type type) {
        try {
            return (T)this.mapper.readerFor(this.mapper.constructType(type)).readValue(node);
        }
        catch (IOException e) {
            throw ArangoDBException.of(e);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Type type) {
        if (content == null || content.length == 0) {
            return null;
        }
        if (RawBytes.class.equals((Object)type)) {
            return (T)RawBytes.of(content);
        }
        if (RawJson.class.equals((Object)type) && "JSON".equals(this.mapper.getFactory().getFormatName())) {
            return (T)RawJson.of(new String(content, StandardCharsets.UTF_8));
        }
        try {
            return (T)this.mapper.readerFor(this.mapper.constructType(type)).readValue(content);
        }
        catch (IOException e) {
            throw ArangoDBException.of(e);
        }
    }

    static {
        SerdeUtils.checkSupportedJacksonVersion();
    }
}

