/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.net.AccessType;

public final class RequestUtils {
    public static final String HEADER_ALLOW_DIRTY_READ = "x-arango-allow-dirty-read";

    private RequestUtils() {
    }

    public static InternalRequest allowDirtyRead(InternalRequest request) {
        return request.putHeaderParam(HEADER_ALLOW_DIRTY_READ, "true");
    }

    public static AccessType determineAccessType(InternalRequest request) {
        if (request.containsHeaderParam(HEADER_ALLOW_DIRTY_READ)) {
            return AccessType.DIRTY_READ;
        }
        if (request.getRequestType() == RequestType.GET) {
            return AccessType.READ;
        }
        return AccessType.WRITE;
    }
}

