/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.ReplicationFactor;
import com.arangodb.model.CollectionSchema;
import com.arangodb.model.ComputedValue;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CollectionPropertiesOptions {
    private Boolean cacheEnabled;
    private List<ComputedValue> computedValues;
    private ReplicationFactor replicationFactor;
    private CollectionSchema schema;
    private Boolean waitForSync;
    private Integer writeConcern;

    public Boolean getCacheEnabled() {
        return this.cacheEnabled;
    }

    public CollectionPropertiesOptions cacheEnabled(Boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        return this;
    }

    public List<ComputedValue> getComputedValues() {
        return this.computedValues;
    }

    public CollectionPropertiesOptions computedValues(ComputedValue ... computedValues) {
        if (this.computedValues == null) {
            this.computedValues = new ArrayList<ComputedValue>();
        }
        Collections.addAll(this.computedValues, computedValues);
        return this;
    }

    public ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    public CollectionPropertiesOptions replicationFactor(ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CollectionSchema getSchema() {
        return this.schema;
    }

    public CollectionPropertiesOptions schema(CollectionSchema schema) {
        this.schema = schema;
        return this;
    }

    public Boolean getWaitForSync() {
        return this.waitForSync;
    }

    public CollectionPropertiesOptions waitForSync(Boolean waitForSync) {
        this.waitForSync = waitForSync;
        return this;
    }

    public Integer getWriteConcern() {
        return this.writeConcern;
    }

    public CollectionPropertiesOptions writeConcern(Integer writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }
}

