/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackJsonDeserializer;
import com.arangodb.velocypack.VPackJsonSerializer;
import com.arangodb.velocypack.VPackParserModule;
import com.arangodb.velocypack.VPackParserSetupContext;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.deps.com.fasterxml.jackson.core.JsonFactory;
import com.arangodb.velocypack.deps.com.fasterxml.jackson.core.JsonGenerator;
import com.arangodb.velocypack.deps.com.fasterxml.jackson.core.JsonParser;
import com.arangodb.velocypack.deps.com.fasterxml.jackson.core.JsonToken;
import com.arangodb.velocypack.deps.com.fasterxml.jackson.core.SerializableString;
import com.arangodb.velocypack.deps.com.fasterxml.jackson.core.io.CharacterEscapes;
import com.arangodb.velocypack.deps.com.fasterxml.jackson.core.io.SerializedString;
import com.arangodb.velocypack.exception.VPackBuilderException;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.internal.util.DateUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VPackParser {
    private static final char OBJECT_OPEN = '{';
    private static final char OBJECT_CLOSE = '}';
    private static final char ARRAY_OPEN = '[';
    private static final char ARRAY_CLOSE = ']';
    private static final char FIELD = ':';
    private static final char SEPARATOR = ',';
    private static final String NULL = "null";
    private static final String NON_REPRESENTABLE_TYPE = "(non-representable type)";
    private final Map<ValueType, VPackJsonDeserializer> deserializers;
    private final Map<String, Map<ValueType, VPackJsonDeserializer>> deserializersByName;
    private final Map<Class<?>, VPackJsonSerializer<?>> serializers;
    private final Map<String, Map<Class<?>, VPackJsonSerializer<?>>> serializersByName;

    @Deprecated
    public VPackParser() {
        this(new HashMap(), new HashMap(), new HashMap<ValueType, VPackJsonDeserializer>(), new HashMap<String, Map<ValueType, VPackJsonDeserializer>>());
    }

    private VPackParser(Map<Class<?>, VPackJsonSerializer<?>> serializers, Map<String, Map<Class<?>, VPackJsonSerializer<?>>> serializersByName, Map<ValueType, VPackJsonDeserializer> deserializers, Map<String, Map<ValueType, VPackJsonDeserializer>> deserializersByName) {
        this.serializers = serializers;
        this.serializersByName = serializersByName;
        this.deserializers = deserializers;
        this.deserializersByName = deserializersByName;
    }

    @Deprecated
    public VPackParser registerDeserializer(String attribute, ValueType type, VPackJsonDeserializer deserializer) {
        Map<ValueType, VPackJsonDeserializer> byName = this.deserializersByName.get(attribute);
        if (byName == null) {
            byName = new HashMap<ValueType, VPackJsonDeserializer>();
            this.deserializersByName.put(attribute, byName);
        }
        byName.put(type, deserializer);
        return this;
    }

    @Deprecated
    public VPackParser registerDeserializer(ValueType type, VPackJsonDeserializer deserializer) {
        this.deserializers.put(type, deserializer);
        return this;
    }

    @Deprecated
    public <T> VPackParser registerSerializer(String attribute, Class<T> type, VPackJsonSerializer<T> serializer) {
        Map<Class<?>, VPackJsonSerializer<?>> byName = this.serializersByName.get(attribute);
        if (byName == null) {
            byName = new HashMap();
            this.serializersByName.put(attribute, byName);
        }
        byName.put(type, serializer);
        return this;
    }

    @Deprecated
    public <T> VPackParser registerSerializer(Class<T> type, VPackJsonSerializer<T> serializer) {
        this.serializers.put(type, serializer);
        return this;
    }

    public String toJson(VPackSlice vpack) throws VPackException {
        return this.toJson(vpack, false);
    }

    public String toJson(VPackSlice vpack, boolean includeNullValues) throws VPackException {
        StringBuilder json = new StringBuilder();
        this.parse(null, null, vpack, json, includeNullValues);
        return json.toString();
    }

    private VPackJsonDeserializer getDeserializer(String attribute, ValueType type) {
        VPackJsonDeserializer deserializer = null;
        Map<ValueType, VPackJsonDeserializer> byName = this.deserializersByName.get(attribute);
        if (byName != null) {
            deserializer = byName.get((Object)type);
        }
        if (deserializer == null) {
            deserializer = this.deserializers.get((Object)type);
        }
        return deserializer;
    }

    private VPackJsonSerializer<?> getSerializer(String attribute, Class<?> type) {
        VPackJsonSerializer<?> serializer = null;
        Map<Class<?>, VPackJsonSerializer<?>> byName = this.serializersByName.get(attribute);
        if (byName != null) {
            serializer = byName.get(type);
        }
        if (serializer == null) {
            serializer = this.serializers.get(type);
        }
        return serializer;
    }

    private void parse(VPackSlice parent, String attribute, VPackSlice value, StringBuilder json, boolean includeNullValues) throws VPackException {
        VPackJsonDeserializer deserializer = null;
        if (attribute != null) {
            VPackParser.appendField(attribute, json);
            deserializer = this.getDeserializer(attribute, value.getType());
        }
        if (deserializer != null) {
            deserializer.deserialize(parent, attribute, value, json);
        } else if (value.isObject()) {
            this.parseObject(value, json, includeNullValues);
        } else if (value.isArray()) {
            this.parseArray(value, json, includeNullValues);
        } else if (value.isBoolean()) {
            json.append(value.getAsBoolean());
        } else if (value.isString()) {
            json.append(VPackParser.toJSONString(value.getAsString()));
        } else if (value.isDouble()) {
            json.append(value.getAsDouble());
        } else if (value.isInt()) {
            json.append(value.getAsLong());
        } else if (value.isNumber()) {
            json.append(value.getAsNumber());
        } else if (value.isDate()) {
            json.append(VPackParser.toJSONString(DateUtil.format(value.getAsDate())));
        } else if (value.isNull()) {
            json.append(NULL);
        } else {
            json.append(VPackParser.toJSONString(NON_REPRESENTABLE_TYPE));
        }
    }

    private static void appendField(String attribute, StringBuilder json) {
        json.append(VPackParser.toJSONString(attribute));
        json.append(':');
    }

    private void parseObject(VPackSlice value, StringBuilder json, boolean includeNullValues) throws VPackException {
        json.append('{');
        int added = 0;
        Iterator<Map.Entry<String, VPackSlice>> iterator = value.objectIterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VPackSlice> next = iterator.next();
            VPackSlice nextValue = next.getValue();
            if (nextValue.isNull() && !includeNullValues) continue;
            if (added++ > 0) {
                json.append(',');
            }
            this.parse(value, next.getKey(), nextValue, json, includeNullValues);
        }
        json.append('}');
    }

    private void parseArray(VPackSlice value, StringBuilder json, boolean includeNullValues) throws VPackException {
        json.append('[');
        int added = 0;
        Iterator<VPackSlice> iterator = value.arrayIterator();
        while (iterator.hasNext()) {
            VPackSlice valueAt = iterator.next();
            if (valueAt.isNull() && !includeNullValues) continue;
            if (added++ > 0) {
                json.append(',');
            }
            this.parse(value, null, valueAt, json, includeNullValues);
        }
        json.append(']');
    }

    public VPackSlice fromJson(String json) throws VPackException {
        return this.fromJson(json, false);
    }

    public VPackSlice fromJson(String json, VPackBuilder builder) throws VPackException {
        return this.fromJson(json, false, builder);
    }

    public VPackSlice fromJson(String json, boolean includeNullValues) throws VPackException {
        return this.fromJson(json, includeNullValues, new VPackBuilder());
    }

    public VPackSlice fromJson(String json, boolean includeNullValues, VPackBuilder builder) throws VPackException {
        try {
            this.parse(json, builder, includeNullValues);
        }
        catch (IOException e) {
            throw new VPackBuilderException(e);
        }
        return builder.slice();
    }

    public VPackSlice fromJson(Iterable<String> jsons) throws VPackException {
        return this.fromJson(jsons, false);
    }

    public VPackSlice fromJson(Iterable<String> jsons, VPackBuilder builder) throws VPackException {
        return this.fromJson(jsons, false, builder);
    }

    public VPackSlice fromJson(Iterable<String> jsons, boolean includeNullValues) throws VPackException {
        return this.fromJson(jsons, includeNullValues, new VPackBuilder());
    }

    public VPackSlice fromJson(Iterable<String> jsons, boolean includeNullValues, VPackBuilder builder) throws VPackException {
        try {
            builder.add(ValueType.ARRAY);
            for (String json : jsons) {
                this.parse(json, builder, includeNullValues);
            }
        }
        catch (IOException e) {
            throw new VPackBuilderException(e);
        }
        builder.close();
        return builder.slice();
    }

    private void parse(String json, VPackBuilder builder, boolean includeNullValues) throws IOException {
        JsonToken token;
        JsonParser parser = new JsonFactory().createParser(json);
        String fieldName = null;
        while (!parser.isClosed() && (token = parser.nextToken()) != null) {
            switch (token) {
                case START_OBJECT: 
                case VALUE_EMBEDDED_OBJECT: {
                    builder.add(fieldName, ValueType.OBJECT);
                    fieldName = null;
                    break;
                }
                case START_ARRAY: {
                    builder.add(fieldName, ValueType.ARRAY);
                    fieldName = null;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    builder.close();
                    break;
                }
                case FIELD_NAME: {
                    fieldName = parser.getCurrentName();
                    break;
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    this.parseValue(builder, fieldName, parser.getBooleanValue());
                    fieldName = null;
                    break;
                }
                case VALUE_NULL: {
                    if (includeNullValues) {
                        builder.add(fieldName, ValueType.NULL);
                    }
                    fieldName = null;
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    this.parseValue(builder, fieldName, parser.getDoubleValue());
                    fieldName = null;
                    break;
                }
                case VALUE_NUMBER_INT: {
                    this.parseValue(builder, fieldName, parser.getLongValue());
                    fieldName = null;
                    break;
                }
                case VALUE_STRING: {
                    this.parseValue(builder, fieldName, parser.getValueAsString());
                    fieldName = null;
                    break;
                }
                case NOT_AVAILABLE: {
                    fieldName = null;
                }
            }
        }
    }

    private void parseValue(VPackBuilder builder, String fieldName, Object value) {
        VPackJsonSerializer<?> serializer = this.getSerializer(fieldName, value.getClass());
        if (serializer != null) {
            serializer.serialize(builder, fieldName, value);
        } else if (String.class.isAssignableFrom(value.getClass())) {
            builder.add(fieldName, (String)value);
        } else if (Boolean.class.isAssignableFrom(value.getClass())) {
            builder.add(fieldName, (Boolean)value);
        } else if (Double.class.isAssignableFrom(value.getClass())) {
            builder.add(fieldName, (Double)value);
        } else if (Long.class.isAssignableFrom(value.getClass())) {
            builder.add(fieldName, (Long)value);
        }
    }

    public static String toJSONString(String text) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = new JsonFactory().setCharacterEscapes(new CustomCharacterEscapes()).createGenerator(writer);
            generator.writeString(text);
            generator.close();
        }
        catch (IOException e) {
            throw new VPackBuilderException(e);
        }
        return writer.toString();
    }

    static class CustomCharacterEscapes
    extends CharacterEscapes {
        private static final long serialVersionUID = -1774622969327286211L;
        private static final SerializedString escapeSlash = new SerializedString("\\/");
        private final int[] _asciiEscapes = CustomCharacterEscapes.standardAsciiEscapesForJSON();

        public CustomCharacterEscapes() {
            this._asciiEscapes[47] = -2;
        }

        @Override
        public int[] getEscapeCodesForAscii() {
            return this._asciiEscapes;
        }

        @Override
        public SerializableString getEscapeSequence(int i) {
            if (i == 47) {
                return escapeSlash;
            }
            return null;
        }
    }

    public static class Builder
    implements VPackParserSetupContext<Builder> {
        private final Map<ValueType, VPackJsonDeserializer> deserializers = new HashMap<ValueType, VPackJsonDeserializer>();
        private final Map<String, Map<ValueType, VPackJsonDeserializer>> deserializersByName = new HashMap<String, Map<ValueType, VPackJsonDeserializer>>();
        private final Map<Class<?>, VPackJsonSerializer<?>> serializers = new HashMap();
        private final Map<String, Map<Class<?>, VPackJsonSerializer<?>>> serializersByName = new HashMap();

        @Override
        public Builder registerDeserializer(String attribute, ValueType type, VPackJsonDeserializer deserializer) {
            Map<ValueType, VPackJsonDeserializer> byName = this.deserializersByName.get(attribute);
            if (byName == null) {
                byName = new HashMap<ValueType, VPackJsonDeserializer>();
                this.deserializersByName.put(attribute, byName);
            }
            byName.put(type, deserializer);
            return this;
        }

        @Override
        public Builder registerDeserializer(ValueType type, VPackJsonDeserializer deserializer) {
            this.deserializers.put(type, deserializer);
            return this;
        }

        @Override
        public <T> Builder registerSerializer(String attribute, Class<T> type, VPackJsonSerializer<T> serializer) {
            Map<Class<?>, VPackJsonSerializer<?>> byName = this.serializersByName.get(attribute);
            if (byName == null) {
                byName = new HashMap();
                this.serializersByName.put(attribute, byName);
            }
            byName.put(type, serializer);
            return this;
        }

        @Override
        public <T> Builder registerSerializer(Class<T> type, VPackJsonSerializer<T> serializer) {
            this.serializers.put(type, serializer);
            return this;
        }

        @Override
        public Builder registerModule(VPackParserModule module) {
            module.setup(this);
            return this;
        }

        @Override
        public Builder registerModules(VPackParserModule ... modules) {
            for (VPackParserModule module : modules) {
                this.registerModule(module);
            }
            return this;
        }

        public synchronized VPackParser build() {
            return new VPackParser(new HashMap(this.serializers), new HashMap(this.serializersByName), new HashMap<ValueType, VPackJsonDeserializer>(this.deserializers), new HashMap<String, Map<ValueType, VPackJsonDeserializer>>(this.deserializersByName));
        }
    }
}

