/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.barcoderecognition;

import com.aspose.barcode.barcoderecognition.BarCodeExtendedParameters;
import com.aspose.barcode.barcoderecognition.BarCodeRegionParameters;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.barcoderecognition.SingleDecodeType;
import com.aspose.barcode.internal.aaq.qq;
import com.aspose.barcode.internal.aaq.ww;
import com.aspose.barcode.internal.bbz.tt;
import com.aspose.barcode.internal.ms.System.Text.vv;
import com.aspose.barcode.internal.zzr.sse;
import com.aspose.barcode.internal.zzr.ttq;
import com.aspose.barcode.internal.zzr.ttr;
import java.nio.charset.Charset;

public final class BarCodeResult {
    private double a;
    private int b;
    private String c;
    private byte[] d;
    private SingleDecodeType e;
    private BarCodeRegionParameters f;
    private BarCodeExtendedParameters g;

    public double getReadingQuality() {
        return this.a;
    }

    public int getConfidence() {
        return this.b;
    }

    public String getCodeText() {
        return this.c;
    }

    public byte[] getCodeBytes() {
        return this.d;
    }

    public SingleDecodeType getCodeType() {
        return this.e;
    }

    public String getCodeTypeName() {
        return this.e.getTypeName();
    }

    public BarCodeRegionParameters getRegion() {
        return this.f;
    }

    public BarCodeExtendedParameters getExtended() {
        return this.g;
    }

    public String getCodeText(Charset encoding) {
        try {
            return vv.fromJava(encoding).getString(this.d, 0, this.d.length);
        }
        catch (RuntimeException runtimeException) {
            return ttr.a;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BarCodeResult)) {
            return false;
        }
        BarCodeResult barCodeResult = (BarCodeResult)obj;
        return this.e == barCodeResult.e && ttr.e(this.c, barCodeResult.c) && BarCodeResult.a(this.d, barCodeResult.d) && this.b == barCodeResult.b && this.a == barCodeResult.a && this.f.equals(barCodeResult.f) && this.g.equals(barCodeResult.g);
    }

    public int hashCode() {
        return 0x4F ^ this.e.hashCode() ^ this.c.hashCode() ^ BarCodeResult.a(this.d) ^ this.b ^ ttq.a(this.a) ^ this.f.hashCode() ^ this.g.hashCode();
    }

    public String toString() {
        return ttr.a("CodeType = {0}, CodeText = \"{1}\", Confidence = {2}, ReadingQuality = {3}", this.e, this.c, tt.b(this.b), tt.a(this.a));
    }

    public Object deepClone() {
        return new BarCodeResult(this);
    }

    public BarCodeResult(BarCodeResult result) {
        this.a = result.a;
        this.b = result.b;
        this.c = result.c;
        this.d = new byte[result.d.length];
        System.arraycopy(result.d, 0, this.d, 0, result.d.length);
        this.e = result.e;
        this.f = new BarCodeRegionParameters(result.f);
        this.g = new BarCodeExtendedParameters(result.g);
    }

    BarCodeResult(qq aResult) {
        this.a = aResult.g;
        this.b = this.a(aResult);
        this.c = this.b(aResult);
        this.d = this.a(this.c);
        this.e = aResult.b;
        this.f = new BarCodeRegionParameters(aResult);
        this.g = new BarCodeExtendedParameters(aResult);
    }

    private static boolean a(byte[] byArray, byte[] byArray2) {
        if (sse.b(byArray, byArray2)) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) == (byArray2[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    private static int a(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i] & 0xFF;
        }
        return n;
    }

    private int a(qq qq2) {
        if (qq2.f) {
            return 0;
        }
        if (DecodeType.is2D(qq2.b)) {
            return 100;
        }
        return 80;
    }

    private String b(qq qq2) {
        boolean bl = qq2.b.containsAny(DecodeType.DATABAR_OMNI_DIRECTIONAL, DecodeType.DATABAR_TRUNCATED, DecodeType.DATABAR_STACKED_OMNI_DIRECTIONAL, DecodeType.DATABAR_STACKED, DecodeType.DATABAR_LIMITED, DecodeType.EAN_13, DecodeType.ISMN, DecodeType.ISBN, DecodeType.UPCA, DecodeType.EAN_8, DecodeType.UPCE, DecodeType.MATRIX_2_OF_5, DecodeType.CODE_39_STANDARD, DecodeType.CODE_39_EXTENDED, DecodeType.PZN, DecodeType.IATA_2_OF_5, DecodeType.INTERLEAVED_2_OF_5, DecodeType.ITALIAN_POST_25, DecodeType.ITF_14, DecodeType.ITF_6, DecodeType.OPC, DecodeType.DEUTSCHE_POST_IDENTCODE, DecodeType.DEUTSCHE_POST_LEITCODE, DecodeType.STANDARD_2_OF_5, DecodeType.MSI);
        String string = qq2.c;
        if (tt.b((Object)qq2, ww.class) && bl) {
            string = ttr.a(string, ((ww)qq2).h);
        }
        return string;
    }

    private byte[] a(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }
}

