/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.complexbarcode.HIBCPASDataLocation;
import com.aspose.barcode.complexbarcode.HIBCPASDataType;
import com.aspose.barcode.complexbarcode.HIBCPASRecord;
import com.aspose.barcode.complexbarcode.IComplexCodetext;
import com.aspose.barcode.generation.BaseEncodeType;
import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.internal.bbz.tt;
import com.aspose.barcode.internal.ccq.cc;
import com.aspose.barcode.internal.ms.System.Text.bbd;
import com.aspose.barcode.internal.nne.rr;
import com.aspose.barcode.internal.wwt.jj;
import com.aspose.barcode.internal.zzr.eee;
import com.aspose.barcode.internal.zzr.ttr;
import com.aspose.barcode.internal.zzr.uuq;

public class HIBCPASCodetext
implements IComplexCodetext {
    private BaseEncodeType a = EncodeTypes.HIBC_CODE_39_PAS;
    private int b;
    private jj<HIBCPASRecord> c = new jj();

    public void setBarcodeType(BaseEncodeType value) {
        if (value != EncodeTypes.HIBC_CODE_39_PAS && value != EncodeTypes.HIBC_CODE_128_PAS && value != EncodeTypes.HIBC_AZTEC_PAS && value != EncodeTypes.HIBC_DATA_MATRIX_PAS && value != EncodeTypes.HIBCQRPAS) {
            throw new BarCodeException("Encode type is not supported.");
        }
        this.a = value;
    }

    public int getDataLocation() {
        return this.b;
    }

    public void setDataLocation(int value) {
        this.b = value;
    }

    public jj<HIBCPASRecord> getRecords() {
        return this.c;
    }

    public void addRecord(int dataType, String data) {
        this.addRecord(new HIBCPASRecord(dataType, data));
    }

    public void addRecord(HIBCPASRecord record) {
        if (ttr.b(record.getData())) {
            throw new BarCodeException("Data cannot be null or empty.");
        }
        if (record.getData().length() > 15) {
            throw new BarCodeException("Length of data must be up to 15 symblos.");
        }
        if (!rr.b(record.getData(), true)) {
            throw new BarCodeException("Data must be alphanumeric string.");
        }
        this.c.b(record);
    }

    public void clear() {
        this.c.clear();
    }

    @Override
    public BaseEncodeType getBarcodeType() {
        return this.a;
    }

    @Override
    public String getConstructedCodetext() {
        bbd bbd2 = new bbd();
        bbd2.a("+/");
        bbd2.a((char)(((byte)this.getDataLocation() & 0xFF) + 65));
        for (int i = 0; i < this.c.size(); ++i) {
            bbd2.a((char)(((byte)this.c.b(i).getDataType() & 0xFF) + 65));
            bbd2.a(this.c.b(i).getData());
            if (i == this.c.size() - 1) continue;
            bbd2.a('/');
        }
        String string = new cc(bbd2.toString()).a();
        bbd2.a(string);
        return bbd2.toString();
    }

    @Override
    public void initFromString(String constructedCodetext) {
        if (ttr.b(constructedCodetext)) {
            throw new BarCodeException("Codetext is empty.");
        }
        if (!ttr.b(constructedCodetext, "+/")) {
            throw new BarCodeException("Codetext is not HIBC PAS codetext.");
        }
        String string = new cc(ttr.b(constructedCodetext, 0, constructedCodetext.length() - 1)).a();
        if (string == null || constructedCodetext.charAt(constructedCodetext.length() - 1) != string.charAt(0)) {
            throw new BarCodeException("Incorrect check char");
        }
        if (constructedCodetext.length() < 3) {
            throw new BarCodeException("Data location is not provided. Codetext is too short");
        }
        int n = constructedCodetext.charAt(2) - 65;
        if (!uuq.isDefined(tt.a(HIBCPASDataLocation.class), tt.b(n))) {
            throw new BarCodeException(ttr.a(new Object[]{"Incorrect data location. '", tt.a(constructedCodetext.charAt(2)), "' is not valid data location."}));
        }
        this.setDataLocation(n);
        if (constructedCodetext.length() < 4) {
            throw new BarCodeException("No data records. Codetext is too short");
        }
        String string2 = ttr.b(constructedCodetext, 3, constructedCodetext.length() - 4);
        String[] stringArray = ttr.a(string2, '/');
        this.c = new jj(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            HIBCPASRecord hIBCPASRecord = new HIBCPASRecord();
            if (ttr.b(stringArray[i])) continue;
            int n2 = stringArray[i].charAt(0) - 65;
            if (!uuq.isDefined(tt.a(HIBCPASDataType.class), tt.b(n2))) {
                throw new BarCodeException(ttr.a(new Object[]{"Incorrect data type. '", tt.a(stringArray[i].charAt(0)), "' is not valid data type."}));
            }
            hIBCPASRecord.setDataType(n2);
            hIBCPASRecord.setData(ttr.e(stringArray[i], 1));
            this.c.b(hIBCPASRecord);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!tt.b(obj, HIBCPASCodetext.class)) {
            return false;
        }
        HIBCPASCodetext hIBCPASCodetext = (HIBCPASCodetext)obj;
        if (this.c != null && hIBCPASCodetext.c == null || this.c == null && hIBCPASCodetext.c != null) {
            return false;
        }
        if (this.c != null && hIBCPASCodetext.c != null) {
            if (this.c.size() != hIBCPASCodetext.c.size()) {
                return false;
            }
            for (int i = 0; i < this.c.size(); ++i) {
                if (this.c.b(i).equals(hIBCPASCodetext.c.b(i))) continue;
                return false;
            }
        }
        return this.getDataLocation() == hIBCPASCodetext.getDataLocation();
    }

    public int hashCode() {
        int n = -1900531381;
        n = n * -1521134295 + this.a.hashCode();
        n = n * -1521134295 + eee.a(this.getDataLocation());
        n = n * -1521134295 + this.c.hashCode();
        return n;
    }
}

