/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.DataStreamSupporter;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.FileStreamContainer;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IImageCreator;
import com.aspose.imaging.IImageExporter;
import com.aspose.imaging.IImageLoaderDescriptor;
import com.aspose.imaging.IObjectWithBounds;
import com.aspose.imaging.ImageCreatorsRegistry;
import com.aspose.imaging.ImageExportersRegistry;
import com.aspose.imaging.ImageLoadersRegistry;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.ProgressEventHandler;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.ImageCreateException;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.ImageLoadException;
import com.aspose.imaging.coreexceptions.ImageSaveException;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.aN.a;
import com.aspose.imaging.internal.aN.aP;
import com.aspose.imaging.internal.aN.aa;
import com.aspose.imaging.internal.aN.bl;
import com.aspose.imaging.internal.aN.cs;
import com.aspose.imaging.internal.aN.ct;
import com.aspose.imaging.internal.aN.e;
import com.aspose.imaging.internal.aN.g;
import com.aspose.imaging.internal.jW.i;
import com.aspose.imaging.internal.kT.b;
import com.aspose.imaging.internal.lA.D;
import com.aspose.imaging.internal.lI.u;
import com.aspose.imaging.internal.lI.w;
import com.aspose.imaging.internal.lV.f;
import com.aspose.imaging.internal.ln.I;
import com.aspose.imaging.internal.mh.aD;
import com.aspose.imaging.internal.mh.aV;
import com.aspose.imaging.internal.mh.bC;
import com.aspose.imaging.internal.qx.d;
import com.aspose.imaging.internal.ri.c;
import com.aspose.imaging.j;
import com.aspose.imaging.k;
import com.aspose.imaging.l;
import com.aspose.imaging.m;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.n;
import com.aspose.imaging.o;
import com.aspose.imaging.p;
import com.aspose.imaging.progressmanagement.EventType;
import com.aspose.imaging.progressmanagement.ProgressEventHandlerInfo;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.Enum;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.io.File;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds,
com.aspose.imaging.internal.kh.b,
com.aspose.imaging.internal.kh.c {
    public static final f<g> e = new f();
    public static final f<e> f = new f();
    public static final f<a> g = new f();
    private static final String j = "Cannot open an image. The image file format may be not supported at the moment.";
    private final AtomicReference<i> k = new AtomicReference<Object>(null);
    private final Color l = Color.getWhite();
    public com.aspose.imaging.internal.jE.o h;
    protected StreamContainer i;
    private int m = 0;
    private WeakReference<Image> n = new WeakReference<Object>(null);
    private IColorPalette o;
    private Object p;
    private boolean q = false;
    private boolean r;
    private InterruptMonitor s;
    private ProgressEventHandlerInfo t;
    private u u;
    private boolean v = false;
    private com.aspose.imaging.internal.ly.l w;
    private boolean x;

    protected Image() {
    }

    protected Image(IColorPalette iColorPalette) {
        this.o = iColorPalette;
    }

    public static boolean canLoad(String string) {
        return Image.canLoad(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoad(String string, LoadOptions loadOptions) {
        Object object = SyncOperation;
        synchronized (object) {
            boolean bl2;
            FileStream fileStream = File.open(string, 3, 3, 3);
            try {
                bl2 = Image.a((Stream)fileStream, loadOptions);
            }
            catch (Throwable throwable) {
                fileStream.dispose();
                throw throwable;
            }
            fileStream.dispose();
            return bl2;
        }
    }

    public static boolean canLoad(InputStream inputStream) {
        Stream stream = Stream.fromJava(inputStream);
        return Image.a(stream, null);
    }

    public static boolean c(Stream stream) {
        return Image.a(stream, null);
    }

    public static boolean canLoad(InputStream inputStream, LoadOptions loadOptions) {
        return Image.a(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean a(Stream stream, LoadOptions loadOptions) {
        boolean bl2;
        cs cs2 = ct.a().a(stream);
        try {
            bl2 = ImageLoadersRegistry.a(cs2, loadOptions) != null;
        }
        finally {
            ct.a().a(cs2);
        }
        return bl2;
    }

    public static Image create(ImageOptionsBase imageOptionsBase, int n2, int n3) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("imageOptions");
        }
        if (imageOptionsBase.getSource() == null) {
            throw new ArgumentNullException("imageOptions", "Please specify source for the image creation.");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("width", "Expected positive width value.");
        }
        if (n3 <= 0) {
            throw new ArgumentOutOfRangeException("height", "Expected positive height value.");
        }
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bB.g.a(Image.a(imageOptionsBase, n2, n3, Image.a(com.aspose.imaging.internal.jE.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image create(Image[] imageArray) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bB.g.a(new bl(imageArray, false, Image.a(com.aspose.imaging.internal.jE.m.a(bl.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image create(Image[] imageArray, boolean bl2) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bB.g.a(new bl(imageArray, bl2, Image.a(com.aspose.imaging.internal.jE.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(String string) {
        FileStream fileStream = File.open(string, 3, 1, 1);
        cs cs2 = ct.a().a(fileStream, false, true);
        try {
            long l2 = Image.f(cs2);
            return l2;
        }
        finally {
            ct.a().a(cs2);
            if (cs2.a() <= 0) {
                cs2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(String string, LoadOptions loadOptions) {
        FileStreamContainer fileStreamContainer = FileStreamContainer.openFileStream(string, true);
        boolean bl2 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.bB.g.a(Image.a(fileStreamContainer, loadOptions, Image.a(com.aspose.imaging.internal.jE.m.a(Image.class.getSimpleName()), loadOptions, blArray)), blArray[0]);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                fileStreamContainer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(String string) {
        FileStreamContainer fileStreamContainer = FileStreamContainer.openFileStream(string, true);
        boolean bl2 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.bB.g.a(Image.a(fileStreamContainer, null, Image.a(com.aspose.imaging.internal.jE.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                fileStreamContainer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(RandomAccessFile randomAccessFile, LoadOptions loadOptions) {
        com.aspose.imaging.internal.ko.a a2 = new com.aspose.imaging.internal.ko.a(randomAccessFile);
        boolean bl2 = true;
        try {
            Image image = Image.b(a2, loadOptions);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                a2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(RandomAccessFile randomAccessFile) {
        com.aspose.imaging.internal.ko.a a2 = new com.aspose.imaging.internal.ko.a(randomAccessFile);
        boolean bl2 = true;
        try {
            Image image = Image.b(a2, null);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                a2.close();
            }
        }
    }

    public static Image load(InputStream inputStream, LoadOptions loadOptions) {
        return Image.b(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image b(Stream stream, LoadOptions loadOptions) {
        boolean bl2 = loadOptions != null && loadOptions.e();
        StreamContainer streamContainer = new StreamContainer(stream, 0L, bl2);
        boolean bl3 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.bB.g.a(Image.a(streamContainer, loadOptions, Image.a(com.aspose.imaging.internal.jE.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
            bl3 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl3) {
                streamContainer.dispose();
            }
        }
    }

    public static Image load(InputStream inputStream) {
        return Image.d(Stream.fromJava(inputStream));
    }

    public static Image d(Stream stream) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bB.g.a(Image.a(stream, null, Image.a(com.aspose.imaging.internal.jE.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image c(Stream stream, LoadOptions loadOptions) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bB.g.a(Image.a(stream, loadOptions, Image.a(com.aspose.imaging.internal.jE.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image a(Stream stream, LoadOptions loadOptions, com.aspose.imaging.internal.jE.o o2) {
        StreamContainer streamContainer = new StreamContainer(stream, 0L, false);
        return Image.a(streamContainer, loadOptions, o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image a(Stream stream, long l2, LoadOptions loadOptions, com.aspose.imaging.internal.jE.o o2) {
        boolean bl2 = loadOptions != null && loadOptions.e();
        StreamContainer streamContainer = new StreamContainer(stream, 0L, bl2);
        streamContainer.setPosition(l2);
        boolean bl3 = true;
        try {
            Image image = Image.a(streamContainer, loadOptions, o2);
            bl3 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl3) {
                streamContainer.close();
            }
        }
    }

    public static Image a(Stream stream, long l2) {
        return Image.a(stream, l2, null, null);
    }

    public static Image e(Stream stream) {
        return Image.a(stream, 0L, null, null);
    }

    public static long getFileFormat(InputStream inputStream) {
        return Image.f(Stream.fromJava(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long f(Stream stream) {
        cs cs2 = ct.a().a(stream);
        Object object = cs2.getSyncRoot();
        synchronized (object) {
            long l2;
            try {
                l2 = Image.a((Stream)cs2, false);
                ct.a().a(cs2);
            }
            catch (Throwable throwable) {
                ct.a().a(cs2);
                throw throwable;
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long a(Stream stream, boolean bl2) {
        long l2 = 0L;
        long l3 = stream.getPosition();
        IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.a(stream, null, false);
        if (iImageLoaderDescriptor != null) {
            l2 = iImageLoaderDescriptor.getSupportedFormat();
        } else if (!bl2) {
            stream.setPosition(l3);
            try {
                if (!com.aspose.imaging.internal.kS.b.b(stream)) {
                    long l4 = l2;
                    return l4;
                }
                Stream stream2 = com.aspose.imaging.internal.kS.b.a(stream);
                if (stream2 == null) {
                    long l5 = l2;
                    return l5;
                }
                try {
                    long l6 = Image.a(stream2, true);
                    stream2.dispose();
                    return l6;
                }
                catch (Throwable throwable) {
                    try {
                        stream2.dispose();
                        throw throwable;
                    }
                    catch (RuntimeException runtimeException) {
                        long l7 = 0L;
                        return l7;
                    }
                }
            }
            finally {
                stream.setPosition(l3);
            }
        }
        return l2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle, new Rectangle(new Point(), new Size(bC.a(n2), bC.a(n3))));
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle, n2, n3);
        if (nArray.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = aV.a("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", new Object[]{rectangle2.getWidth() * rectangle2.getHeight(), nArray.length});
            throw new ImageException(string);
        }
        return rectangle2;
    }

    public static int getProportionalWidth(int n2, int n3, int n4) {
        double d2 = (double)n4 / (double)n3;
        return com.aspose.imaging.internal.rj.d.e(d2 * (double)n2 + 0.5);
    }

    public static int getProportionalHeight(int n2, int n3, int n4) {
        double d2 = (double)n4 / (double)n2;
        return com.aspose.imaging.internal.rj.d.e(d2 * (double)n3 + 0.5);
    }

    protected static void a(long[] lArray, Stream stream) {
        for (g g2 : e.a()) {
            g2.a(lArray, stream);
        }
    }

    private static void a(long[] lArray, long l2) {
        for (e e2 : f.a()) {
            e2.a(lArray, l2);
        }
    }

    public static com.aspose.imaging.internal.jE.o a(String string, LoadOptions loadOptions, boolean[] blArray) {
        List<a> list;
        blArray[0] = false;
        if (com.aspose.imaging.internal.jE.l.d()) {
            com.aspose.imaging.internal.jE.l.a(new com.aspose.imaging.i(), new j());
        }
        if ((list = g.a()) != null) {
            com.aspose.imaging.internal.jE.o o2 = null;
            if (loadOptions == null || !loadOptions.d()) {
                o2 = new com.aspose.imaging.internal.jE.o();
            }
            for (a a2 : list) {
                blArray[0] = a2.a(string, o2, null);
            }
            return o2;
        }
        return null;
    }

    private static void a(ProgressEventHandlerInfo progressEventHandlerInfo, EventType eventType) {
        if (progressEventHandlerInfo != null) {
            progressEventHandlerInfo.a(eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Image a(ImageOptionsBase imageOptionsBase, int n2, int n3, com.aspose.imaging.internal.jE.o o2) {
        Object object;
        StreamSource streamSource = (StreamSource)((Object)com.aspose.imaging.internal.rj.d.a(imageOptionsBase.getSource(), StreamSource.class));
        Stream stream = streamSource != null ? streamSource.getStream() : null;
        Object object2 = object = cs.a(stream, stream == null ? new Object() : stream);
        synchronized (object2) {
            ProgressEventHandlerInfo progressEventHandlerInfo = null;
            if (imageOptionsBase.getProgressEventHandler() != null) {
                progressEventHandlerInfo = ProgressEventHandlerInfo.a(4);
                progressEventHandlerInfo.a(imageOptionsBase.getProgressEventHandler());
            }
            Image.a(progressEventHandlerInfo, EventType.Initialization);
            StreamContainer streamContainer = imageOptionsBase.getSource().getStreamContainer();
            boolean bl2 = true;
            try {
                Image image;
                block20: {
                    IImageCreator iImageCreator = ImageCreatorsRegistry.createFirstSupportedCreator(imageOptionsBase);
                    if (iImageCreator == null) {
                        throw new ImageLoadException("Cannot create a new image. The image file format may be not supported at the moment.");
                    }
                    Image.a(progressEventHandlerInfo, EventType.PreProcessing);
                    Image image2 = iImageCreator.create(streamContainer, imageOptionsBase, n2, n3);
                    try {
                        i i2;
                        image2.t = progressEventHandlerInfo;
                        Image.a(progressEventHandlerInfo, EventType.Processing);
                        image2.a(streamContainer);
                        if (imageOptionsBase.b() != null) {
                            i2 = imageOptionsBase.b().f();
                        } else {
                            ImageOptionsBase imageOptionsBase2 = imageOptionsBase;
                            i i3 = com.aspose.imaging.internal.jW.i.a.f();
                            if (imageOptionsBase2 != null) {
                                i3.c(imageOptionsBase2.getBufferSizeHint());
                            }
                            i2 = i3;
                        }
                        i i4 = i2;
                        image2.a(i4, true);
                        image2.a(o2);
                        Image.a(progressEventHandlerInfo, EventType.Finalization);
                        if (!imageOptionsBase.a()) {
                            Image.a(image2.d, (long)image2.getWidth() * (long)image2.getHeight());
                        }
                        bl2 = false;
                        image = image2;
                        if (!bl2) break block20;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl2) {
                                image2.close();
                            }
                            throw throwable;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageCreateException("Image creation failed.", runtimeException);
                        }
                        catch (Error error) {
                            throw new ImageCreateException("Image creation failed.", error);
                        }
                    }
                    image2.close();
                }
                return image;
            }
            finally {
                if (bl2) {
                    streamContainer.close();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Image a(StreamContainer var0, LoadOptions var1_1, com.aspose.imaging.internal.jE.o var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean b(String string) {
        try {
            return this.a(string, null);
        }
        catch (RuntimeException runtimeException) {
            throw new FrameworkException("DoAPICallHook", runtimeException);
        }
    }

    public final boolean a(String string, com.aspose.imaging.internal.jE.c c2) {
        if (com.aspose.imaging.internal.jE.l.d()) {
            com.aspose.imaging.internal.jE.l.a(new k(this), new l(this));
        }
        if (this.h == null) {
            this.h = new com.aspose.imaging.internal.jE.o();
        }
        for (a a2 : g.a()) {
            if (!a2.a(string, this.h, c2)) continue;
            this.a(this.h);
        }
        return true;
    }

    public final <T> boolean a(Class<T> clazz, String string) {
        try {
            return this.a(clazz, string, null);
        }
        catch (RuntimeException runtimeException) {
            throw new FrameworkException("DoAPICallHook<T>", runtimeException);
        }
    }

    public final <T> boolean a(Class<T> clazz, String string, com.aspose.imaging.internal.jE.c c2) {
        List<a> list;
        if (com.aspose.imaging.internal.jE.l.d()) {
            com.aspose.imaging.internal.jE.l.a(new m(this), new n(this));
        }
        if ((list = g.a()) == null) {
            return false;
        }
        if (this.h == null) {
            this.h = new com.aspose.imaging.internal.jE.o();
        }
        for (a a2 : list) {
            if (!a2.a(com.aspose.imaging.internal.jE.m.a(clazz.getSimpleName(), string), this.h, c2)) continue;
            this.a(this.h);
        }
        return true;
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty(), this.getSize());
    }

    public Image getContainer() {
        return (Image)this.n.get();
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.o;
    }

    public void setPalette(IColorPalette iColorPalette) {
        if (this.o != iColorPalette) {
            IColorPalette iColorPalette2 = this.o;
            this.onPaletteChanging(iColorPalette2, iColorPalette);
            this.o = iColorPalette;
            this.onPaletteChanged(iColorPalette2, iColorPalette);
        }
    }

    public boolean isUsePalette() {
        return false;
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    public InterruptMonitor getInterruptMonitor() {
        return this.s;
    }

    public void setInterruptMonitor(InterruptMonitor interruptMonitor) {
        this.s = interruptMonitor;
    }

    public final int getBufferSizeHint() {
        return this.h().b();
    }

    public final void setBufferSizeHint(int n2) {
        i i2 = this.h();
        if (!aD.a(i2, com.aspose.imaging.internal.jW.i.a)) {
            i2.c(n2);
        }
    }

    public boolean isAutoAdjustPalette() {
        return this.r;
    }

    public void setAutoAdjustPalette(boolean bl2) {
        this.r = bl2;
    }

    public boolean hasBackgroundColor() {
        return this.v;
    }

    public long getFileFormat() {
        return 0L;
    }

    public Color getBackgroundColor() {
        return this.l;
    }

    public void setBackgroundColor(boolean bl2) {
        this.v = bl2;
    }

    public void setBackgroundColor(Color color) {
        color.CloneTo(this.l);
    }

    public boolean f() {
        return this.q;
    }

    public void d(boolean bl2) {
        this.q = bl2;
    }

    public final com.aspose.imaging.internal.ly.l g() {
        if (this.w == null) {
            this.w = new com.aspose.imaging.internal.ly.l();
        }
        return this.w;
    }

    public i h() {
        i i2 = this.k.get();
        return i2 != null ? i2 : com.aspose.imaging.internal.jW.i.a;
    }

    @Override
    public boolean D_() {
        return this.h().c();
    }

    public int i() {
        if (this.h == null && this.getContainer() != null) {
            this.h = this.getContainer().h;
        }
        if (this.h == null) {
            return 0;
        }
        return this.h.a();
    }

    @Override
    @com.aspose.imaging.internal.rj.g
    public final ProgressEventHandler getIProgressEventHandler() {
        if (this.t == null) {
            return null;
        }
        return this.t.a();
    }

    @Override
    @com.aspose.imaging.internal.rj.g
    public final ProgressEventHandlerInfo getProgressEventHandlerInfo() {
        return this.t;
    }

    public boolean canSave(ImageOptionsBase imageOptionsBase) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        this.verifyNotDisposed();
        return ImageExportersRegistry.getFirstSupportedDescriptor(this, imageOptionsBase) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n2, int n3) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                this.resize(n2, n3, 7);
            }
            finally {
                this.c(true);
            }
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    public abstract void resize(int var1, int var2, int var3);

    public abstract void resize(int var1, int var2, ImageResizeSettings var3);

    public ImageOptionsBase getDefaultOptions(Object[] objectArray) {
        return null;
    }

    public ImageOptionsBase getOriginalOptions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.b(2);
            try {
                this.b(bl2);
                this.resizeWidthProportionally(n2, 7);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.b(3);
            try {
                this.b(bl2);
                this.resizeHeightProportionally(n2, 7);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    public void resizeWidthProportionally(int n2, int n3) {
        int n4 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), n2);
        this.resize(n2, n4, n3);
    }

    public void resizeHeightProportionally(int n2, int n3) {
        int n4 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), n2);
        this.resize(n4, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int n2, ImageResizeSettings imageResizeSettings) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                int n3 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), n2);
                this.resize(n2, n3, imageResizeSettings);
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int n2, ImageResizeSettings imageResizeSettings) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                int n3 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), n2);
                this.resize(n3, n2, imageResizeSettings);
            }
            finally {
                this.c(true);
            }
        }
    }

    public abstract void rotateFlip(int var1);

    @Override
    public final void save() {
        if (this.n.get() != null) {
            throw new FrameworkException("The result of this method is unpredictable since the current image has Container defined. Use the parent Container's Save() method instead.");
        }
        this.a(Image.class, com.aspose.imaging.internal.jE.m.c());
        super.save();
        if (this.i != null) {
            this.i.setPosition(0L);
            Stream stream = this.getDataStreamContainer().a();
            stream.setPosition(0L);
            com.aspose.imaging.internal.kS.b.a(stream, this.i.a());
        }
    }

    @Override
    public void save(String string) {
        ImageOptionsBase imageOptionsBase;
        if (string == null) {
            throw new ArgumentNullException("filePath");
        }
        this.a(Image.class, com.aspose.imaging.internal.jE.m.c());
        if (!this.a(string) && (imageOptionsBase = aa.a(string, this)) != null) {
            this.save(string, imageOptionsBase);
            return;
        }
        super.save(string);
    }

    public void save(String string, ImageOptionsBase imageOptionsBase) {
        this.save(string, imageOptionsBase, Rectangle.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        aa.a(string, imageOptionsBase);
        try {
            FileStream fileStream = File.create(string);
            try {
                this.a(fileStream, imageOptionsBase, rectangle);
                fileStream.flush();
            }
            finally {
                fileStream.dispose();
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (Error error) {
            throw new ImageLoadException("Image saving failed.", error);
        }
        catch (ImageSaveException imageSaveException) {
            throw imageSaveException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image saving failed.", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile randomAccessFile, ImageOptionsBase imageOptionsBase) {
        com.aspose.imaging.internal.ko.a a2 = new com.aspose.imaging.internal.ko.a(randomAccessFile);
        try {
            this.a(a2, imageOptionsBase, Rectangle.getEmpty());
        }
        finally {
            a2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile randomAccessFile, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        com.aspose.imaging.internal.ko.a a2 = new com.aspose.imaging.internal.ko.a(randomAccessFile);
        try {
            this.a(a2, imageOptionsBase, rectangle);
        }
        finally {
            a2.dispose();
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase) {
        if (outputStream instanceof d) {
            this.a(((d)outputStream).a(), imageOptionsBase, Rectangle.getEmpty());
        } else {
            com.aspose.imaging.internal.ri.c.a(new o(this, outputStream, imageOptionsBase));
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        if (outputStream instanceof d) {
            this.a(((d)outputStream).a(), imageOptionsBase, rectangle);
        } else {
            com.aspose.imaging.internal.ri.c.a(new p(this, outputStream, imageOptionsBase, rectangle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("optionsBase");
        }
        if (!(rectangle.isEmpty() || rectangle.getWidth() > 0 && rectangle.getHeight() > 0)) {
            throw new ArgumentOutOfRangeException("boundsRectangle", "Rectangle should have positive width and height");
        }
        boolean bl2 = false;
        try {
            Object object;
            Object object2 = this.c;
            synchronized (object2) {
                this.isRecursiveCall = bl2 = this.isSameSourceStream_internalized(stream);
                this.MutuallyExclusiveOperationIsNotRunningEvent_internalized.waitOne();
                if (imageOptionsBase.getProgressEventHandler() != null) {
                    this.t = ProgressEventHandlerInfo.a(4);
                    this.t.a(imageOptionsBase.getProgressEventHandler());
                } else if (this.t != null) {
                    this.t.b(this.t.getMaxValue() + 4);
                    imageOptionsBase.setProgressEventHandler(this.t.a());
                }
                object = this.SyncNonExclusiveOperation_internalized;
                synchronized (object) {
                    if (this.NonExclusiveRunningOperationsCount_internalized.incrementAndGet() > 0) {
                        this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.reset();
                    }
                }
            }
            this.a(Image.class, com.aspose.imaging.internal.jE.m.c(), new com.aspose.imaging.internal.jE.g(imageOptionsBase));
            Image.a(this.t, EventType.Initialization);
            object2 = ImageExportersRegistry.createFirstSupportedExporter(this, imageOptionsBase);
            if (object2 == null) {
                object = this.getCanNotSaveMessage(imageOptionsBase);
                throw new ArgumentException((String)object, "optionsBase");
            }
            object = this.a(imageOptionsBase, rectangle, (IImageExporter)object2);
            Image image = ((aP)object).c();
            cs cs2 = null;
            try {
                Image.a(this.t, EventType.PreProcessing);
                image.a(image.h);
                cs2 = ct.a().a(stream);
                Object object3 = cs2.getSyncRoot();
                synchronized (object3) {
                    cs2.setPosition(0L);
                    image.tryCacheImage(cs2);
                    Image.a(this.t, EventType.Processing);
                    object2.export(image, cs2.toOutputStream(), imageOptionsBase, rectangle);
                    Image.a(this.t, EventType.Finalization);
                    this.b(cs2);
                }
                ct.a().a(cs2);
                ((aP)object).a();
            }
            catch (Throwable throwable) {
                ct.a().a(cs2);
                ((aP)object).a();
                throw throwable;
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image export failed.", runtimeException);
        }
        finally {
            Object object = this.SyncNonExclusiveOperation_internalized;
            synchronized (object) {
                if (bl2) {
                    this.isRecursiveCall = false;
                }
                if (this.NonExclusiveRunningOperationsCount_internalized.decrementAndGet() <= 0) {
                    this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.set();
                }
            }
        }
    }

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public D a(ImageOptionsBase imageOptionsBase, int n2, Rectangle rectangle) {
        if (this.m > 0) {
            throw new NotImplementedException();
        }
        ++this.m;
        int[] nArray = new int[]{0};
        Stream stream = this.a(imageOptionsBase, rectangle.Clone(), nArray);
        com.aspose.imaging.internal.lK.g g2 = new com.aspose.imaging.internal.lK.g();
        com.aspose.imaging.internal.lA.m m2 = (com.aspose.imaging.internal.lA.m)g2.a(stream);
        this.m = 0;
        return (D)m2.a(nArray[0]);
    }

    public InputStream getSerializedStream(ImageOptionsBase imageOptionsBase, Rectangle rectangle, int[] nArray) {
        Stream stream = this.a(imageOptionsBase, rectangle, nArray);
        stream.setPosition(0L);
        return Stream.toJava(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream a(ImageOptionsBase imageOptionsBase, Rectangle rectangle, int[] nArray) {
        com.aspose.imaging.internal.lK.g g2 = new com.aspose.imaging.internal.lK.g();
        boolean bl2 = true;
        I i2 = new I();
        try {
            g2.a(i2, this.a(imageOptionsBase, 1, rectangle));
            bl2 = false;
        }
        finally {
            if (bl2) {
                i2.dispose();
            }
        }
        nArray[0] = 0;
        return i2;
    }

    public Object j() {
        return this.p;
    }

    public void a(Object object) {
        this.p = object;
    }

    public boolean a(com.aspose.imaging.internal.jE.o o2) {
        if (o2 == null) {
            return false;
        }
        if (com.aspose.imaging.internal.jE.l.d()) {
            throw new FrameworkException("Plugin license is not ready");
        }
        if (this.h == null || this.h != o2) {
            this.h = o2;
        }
        return true;
    }

    public void a(Image image) {
        this.n = new WeakReference<Image>(image);
        this.k();
    }

    protected final void updateContainer(Image image) {
        this.a(image);
    }

    public final void a(EventType eventType) {
        if (this.t != null) {
            this.t.c(this.t.getValue() + 1);
            this.t.a(eventType, this.t.getValue());
        }
    }

    public final void a(int n2) {
        if (this.t != null) {
            this.t.b(this.t.getMaxValue() + n2);
        }
    }

    public void k() {
        Image image = this.getContainer();
        if (image != null) {
            this.a(image.h);
        } else {
            this.a((com.aspose.imaging.internal.jE.o)null);
        }
    }

    public void a(i i2, boolean bl2) {
        if (this.x) {
            i i3 = this.k.getAndSet(aD.a(i2, com.aspose.imaging.internal.jW.i.a) ? null : i2);
            if (i3 != null && !aD.a(i3, i2)) {
                i3.dispose();
            }
        } else {
            this.k.set(aD.a(i2, com.aspose.imaging.internal.jW.i.a) ? null : i2);
        }
        this.x = bl2;
    }

    protected boolean b(int n2) {
        return false;
    }

    protected String getCanNotSaveMessage(ImageOptionsBase imageOptionsBase) {
        return "Cannot save to the specified format as it is not supported at the moment";
    }

    public Image a(ImageOptionsBase imageOptionsBase) {
        return this;
    }

    public boolean l() {
        Image image = (Image)this.n.get();
        return this.r || image != null && image.l();
    }

    public final boolean m() {
        return this.u != null;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle, this.getWidth(), this.getHeight());
    }

    protected Image getImage2Export(ImageOptionsBase imageOptionsBase, Rectangle rectangle, IImageExporter iImageExporter) {
        return this;
    }

    public aP a(ImageOptionsBase imageOptionsBase, Rectangle rectangle, IImageExporter iImageExporter) {
        return new aP(this.getImage2Export(imageOptionsBase, rectangle, iImageExporter), false);
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] nArray) {
        return Image.getFittingRectangle(rectangle, nArray, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.b(com.aspose.imaging.internal.jE.m.c());
    }

    protected final void releaseResources() {
        this.o = null;
        i i2 = this.k.getAndSet(null);
        if (i2 != null && this.x) {
            i2.dispose();
        }
        if (this.w != null) {
            this.w.dispose();
        }
        if (this.u != null) {
            com.aspose.imaging.internal.lI.w.b().b(this.u);
        }
    }

    protected void releaseReferences() {
        this.releaseResources();
    }

    @Override
    protected void releaseManagedResources() {
        this.releaseResources();
        if (this.i != null) {
            try {
                IDisposable iDisposable;
                StreamContainer streamContainer = this.i;
                Stream stream = streamContainer.a();
                if (stream instanceof cs) {
                    iDisposable = (cs)stream;
                    ((cs)iDisposable).e();
                    if (((cs)iDisposable).a() <= 0) {
                        ((cs)iDisposable).dispose();
                        streamContainer.dispose();
                    }
                } else {
                    stream.dispose();
                    streamContainer.dispose();
                }
                iDisposable = this.getDataStreamContainer();
                Stream stream2 = ((StreamContainer)iDisposable).a();
                if (com.aspose.imaging.internal.rj.d.b((Object)stream2, cs.class)) {
                    cs cs2 = (cs)stream2;
                    Stream stream3 = cs2.b();
                    String string = stream3 instanceof FileStream ? ((FileStream)stream3).getName() : null;
                    stream2.dispose();
                    ((DisposableObject)iDisposable).dispose();
                    if (File.exists(string)) {
                        File.delete(string);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.releaseManagedResources();
    }

    static {
        new b().run();
    }

    protected static final class ImageOperation
    extends Enum {
        public static final int Blend = 0;
        public static final int Resize = 1;
        public static final int ResizeWidthProportionally = 2;
        public static final int ResizeHeightProportionally = 3;
        public static final int Filter = 4;
        public static final int LoadPixels = 5;
        public static final int SavePixels = 6;
        public static final int Crop = 7;
        public static final int BinarizeFixed = 8;
        public static final int BinarizeOtsu = 9;
        public static final int BinarizeBradley = 10;
        public static final int Grayscale = 11;
        public static final int AdjustBrightness = 12;
        public static final int AdjustContrast = 13;
        public static final int AdjustGamma = 14;
        public static final int Rotate = 15;
        public static final int RotateFlip = 16;

        private ImageOperation() {
        }

        static {
            Enum.register(new a());
        }

        private static final class a
        extends Enum.SimpleEnum {
            a() {
                super(ImageOperation.class, Integer.class);
                this.addConstant("Blend", 0L);
                this.addConstant("Resize", 1L);
                this.addConstant("ResizeWidthProportionally", 2L);
                this.addConstant("ResizeHeightProportionally", 3L);
                this.addConstant("Filter", 4L);
                this.addConstant("LoadPixels", 5L);
                this.addConstant("SavePixels", 6L);
                this.addConstant("Crop", 7L);
                this.addConstant("BinarizeFixed", 8L);
                this.addConstant("BinarizeOtsu", 9L);
                this.addConstant("BinarizeBradley", 10L);
                this.addConstant("Grayscale", 11L);
                this.addConstant("AdjustBrightness", 12L);
                this.addConstant("AdjustContrast", 13L);
                this.addConstant("AdjustGamma", 14L);
                this.addConstant("Rotate", 15L);
                this.addConstant("RotateFlip", 16L);
            }
        }
    }
}

