/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.IImageCreator;
import com.aspose.imaging.IImageCreatorDescriptor;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.extensions.FileFormatExtensions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.aY.A;
import com.aspose.imaging.internal.aY.C;
import com.aspose.imaging.internal.aY.E;
import com.aspose.imaging.internal.aY.b;
import com.aspose.imaging.internal.aY.d;
import com.aspose.imaging.internal.aY.f;
import com.aspose.imaging.internal.aY.h;
import com.aspose.imaging.internal.aY.j;
import com.aspose.imaging.internal.aY.l;
import com.aspose.imaging.internal.aY.n;
import com.aspose.imaging.internal.aY.p;
import com.aspose.imaging.internal.aY.r;
import com.aspose.imaging.internal.aY.t;
import com.aspose.imaging.internal.aY.v;
import com.aspose.imaging.internal.aY.y;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ImageCreatorsRegistry {
    private static final List<IImageCreatorDescriptor> a = new ArrayList<IImageCreatorDescriptor>();
    private static final ReadWriteLock b = new ReentrantReadWriteLock();

    private ImageCreatorsRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRegisteredFormats() {
        long l2 = 0L;
        b.readLock().lock();
        try {
            for (IImageCreatorDescriptor iImageCreatorDescriptor : a) {
                l2 |= iImageCreatorDescriptor.getSupportedFormat();
            }
        }
        finally {
            b.readLock().unlock();
        }
        return l2;
    }

    public static IImageCreatorDescriptor[] getRegisteredDescriptors() {
        b.readLock().lock();
        try {
            IImageCreatorDescriptor[] iImageCreatorDescriptorArray = a.toArray(new IImageCreatorDescriptor[0]);
            return iImageCreatorDescriptorArray;
        }
        finally {
            b.readLock().unlock();
        }
    }

    public static void register(IImageCreatorDescriptor iImageCreatorDescriptor) {
        if (iImageCreatorDescriptor == null) {
            throw new NullPointerException("creatorDescriptor");
        }
        b.writeLock().lock();
        try {
            a.add(iImageCreatorDescriptor);
        }
        finally {
            b.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IImageCreatorDescriptor getFirstSupportedDescriptor(ImageOptionsBase imageOptionsBase) {
        if (imageOptionsBase == null) {
            throw new NullPointerException("imageOptions");
        }
        b.readLock().lock();
        try {
            for (int i2 = a.size() - 1; i2 >= 0; --i2) {
                IImageCreatorDescriptor iImageCreatorDescriptor = a.get(i2);
                if (!iImageCreatorDescriptor.canCreate(imageOptionsBase)) continue;
                IImageCreatorDescriptor iImageCreatorDescriptor2 = iImageCreatorDescriptor;
                return iImageCreatorDescriptor2;
            }
        }
        finally {
            b.readLock().unlock();
        }
        return null;
    }

    public static IImageCreator createFirstSupportedCreator(ImageOptionsBase imageOptionsBase) {
        IImageCreator iImageCreator = null;
        IImageCreatorDescriptor iImageCreatorDescriptor = ImageCreatorsRegistry.getFirstSupportedDescriptor(imageOptionsBase);
        if (iImageCreatorDescriptor != null) {
            iImageCreator = iImageCreatorDescriptor.createInstance();
        }
        return iImageCreator;
    }

    public static void registerCreator(IImageCreatorDescriptor iImageCreatorDescriptor) {
        if (iImageCreatorDescriptor == null) {
            throw new NullPointerException("creatorDescriptor");
        }
        if (!FileFormatExtensions.isSingleFormatDefined(iImageCreatorDescriptor.getSupportedFormat())) {
            throw new ArgumentException("Creator should support only single file format.", "creatorDescriptor");
        }
        b.writeLock().lock();
        try {
            a.add(iImageCreatorDescriptor);
        }
        finally {
            b.writeLock().unlock();
        }
    }

    public static void unregisterCreator(IImageCreatorDescriptor iImageCreatorDescriptor) {
        if (iImageCreatorDescriptor == null) {
            throw new NullPointerException("creatorDescriptor");
        }
        b.writeLock().lock();
        try {
            a.remove(iImageCreatorDescriptor);
        }
        finally {
            b.writeLock().unlock();
        }
    }

    static {
        b.writeLock().lock();
        try {
            a.add(new n());
            a.add(new r());
            a.add(new t());
            a.add(new A());
            a.add(new b());
            a.add(new C());
            a.add(new d());
            a.add(new f());
            a.add(new v());
            a.add(new l());
            a.add(new p());
            a.add(new E());
            a.add(new j());
            a.add(new h());
            a.add(new y());
        }
        finally {
            b.writeLock().unlock();
        }
    }
}

