/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.IImageExporter;
import com.aspose.imaging.IImageExporterDescriptor;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.extensions.FileFormatExtensions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.bx.A;
import com.aspose.imaging.internal.bx.C;
import com.aspose.imaging.internal.bx.E;
import com.aspose.imaging.internal.bx.G;
import com.aspose.imaging.internal.bx.I;
import com.aspose.imaging.internal.bx.N;
import com.aspose.imaging.internal.bx.P;
import com.aspose.imaging.internal.bx.R;
import com.aspose.imaging.internal.bx.U;
import com.aspose.imaging.internal.bx.W;
import com.aspose.imaging.internal.bx.b;
import com.aspose.imaging.internal.bx.d;
import com.aspose.imaging.internal.bx.f;
import com.aspose.imaging.internal.bx.k;
import com.aspose.imaging.internal.bx.m;
import com.aspose.imaging.internal.bx.o;
import com.aspose.imaging.internal.bx.q;
import com.aspose.imaging.internal.bx.t;
import com.aspose.imaging.internal.bx.v;
import com.aspose.imaging.internal.bx.x;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ImageExportersRegistry {
    private static final List<IImageExporterDescriptor> a = new ArrayList<IImageExporterDescriptor>();
    private static final ReentrantReadWriteLock b = new ReentrantReadWriteLock();

    private ImageExportersRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRegisteredFormats() {
        long l2 = 0L;
        b.readLock().lock();
        try {
            for (IImageExporterDescriptor iImageExporterDescriptor : a) {
                l2 |= iImageExporterDescriptor.getSupportedFormat();
            }
        }
        finally {
            b.readLock().unlock();
        }
        return l2;
    }

    public static IImageExporterDescriptor[] getRegisteredExporterDescriptors() {
        b.readLock().lock();
        try {
            IImageExporterDescriptor[] iImageExporterDescriptorArray = a.toArray(new IImageExporterDescriptor[0]);
            return iImageExporterDescriptorArray;
        }
        finally {
            b.readLock().unlock();
        }
    }

    public static void register(IImageExporterDescriptor iImageExporterDescriptor) {
        if (iImageExporterDescriptor == null) {
            throw new NullPointerException("exporterDescriptor");
        }
        b.writeLock().lock();
        try {
            a.add(iImageExporterDescriptor);
        }
        finally {
            b.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IImageExporterDescriptor getFirstSupportedDescriptor(Image image, ImageOptionsBase imageOptionsBase) {
        b.readLock().lock();
        try {
            for (int i2 = a.size() - 1; i2 >= 0; --i2) {
                IImageExporterDescriptor iImageExporterDescriptor = a.get(i2);
                if (!iImageExporterDescriptor.canExport(image, imageOptionsBase)) continue;
                IImageExporterDescriptor iImageExporterDescriptor2 = iImageExporterDescriptor;
                return iImageExporterDescriptor2;
            }
        }
        finally {
            b.readLock().unlock();
        }
        return null;
    }

    public static IImageExporter createFirstSupportedExporter(Image image, ImageOptionsBase imageOptionsBase) {
        IImageExporter iImageExporter = null;
        IImageExporterDescriptor iImageExporterDescriptor = ImageExportersRegistry.getFirstSupportedDescriptor(image, imageOptionsBase);
        if (iImageExporterDescriptor != null) {
            iImageExporter = iImageExporterDescriptor.createInstance();
        }
        return iImageExporter;
    }

    public static void registerExporter(IImageExporterDescriptor iImageExporterDescriptor) {
        if (iImageExporterDescriptor == null) {
            throw new NullPointerException("exporterDescriptor");
        }
        if (!FileFormatExtensions.isSingleFormatDefined(iImageExporterDescriptor.getSupportedFormat())) {
            throw new ArgumentException("Exporter should support only single file format.", "exporterDescriptor");
        }
        b.writeLock().lock();
        try {
            a.add(iImageExporterDescriptor);
        }
        finally {
            b.writeLock().unlock();
        }
    }

    public static void unregisterExporter(IImageExporterDescriptor iImageExporterDescriptor) {
        if (iImageExporterDescriptor == null) {
            throw new NullPointerException("exporterDescriptor");
        }
        b.writeLock().lock();
        try {
            a.remove(iImageExporterDescriptor);
        }
        finally {
            b.writeLock().unlock();
        }
    }

    public static boolean a() {
        return a.isEmpty();
    }

    static {
        b.writeLock().lock();
        try {
            a.add(new t());
            a.add(new R());
            a.add(new d());
            a.add(new C());
            a.add(new G());
            a.add(new P());
            a.add(new b());
            a.add(new I());
            a.add(new f());
            a.add(new A());
            a.add(new q());
            a.add(new x());
            a.add(new E());
            a.add(new U());
            a.add(new k());
            a.add(new o());
            a.add(new W());
            a.add(new N());
            a.add(new v());
            a.add(new m());
        }
        finally {
            b.writeLock().unlock();
        }
    }
}

