/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IImageLoader;
import com.aspose.imaging.IImageLoaderDescriptor;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.extensions.FileFormatExtensions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.aN.aN;
import com.aspose.imaging.internal.aN.cs;
import com.aspose.imaging.internal.aN.ct;
import com.aspose.imaging.internal.jI.A;
import com.aspose.imaging.internal.jI.C;
import com.aspose.imaging.internal.jI.F;
import com.aspose.imaging.internal.jI.H;
import com.aspose.imaging.internal.jI.K;
import com.aspose.imaging.internal.jI.O;
import com.aspose.imaging.internal.jI.Q;
import com.aspose.imaging.internal.jI.S;
import com.aspose.imaging.internal.jI.X;
import com.aspose.imaging.internal.jI.Z;
import com.aspose.imaging.internal.jI.c;
import com.aspose.imaging.internal.jI.e;
import com.aspose.imaging.internal.jI.g;
import com.aspose.imaging.internal.jI.i;
import com.aspose.imaging.internal.jI.k;
import com.aspose.imaging.internal.jI.m;
import com.aspose.imaging.internal.jI.o;
import com.aspose.imaging.internal.jI.q;
import com.aspose.imaging.internal.jI.s;
import com.aspose.imaging.internal.jI.u;
import com.aspose.imaging.internal.jI.w;
import com.aspose.imaging.internal.jI.y;
import com.aspose.imaging.internal.kj.a;
import com.aspose.imaging.internal.kj.b;
import com.aspose.imaging.internal.mh.aD;
import com.aspose.imaging.internal.mh.aV;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericCollection;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.KeyValuePair;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.collections.Generic.SortedList;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ImageLoadersRegistry {
    private static final SortedList<Long, IImageLoaderDescriptor> a = new SortedList(24, new b());
    private static final ReentrantReadWriteLock b = new ReentrantReadWriteLock();

    private ImageLoadersRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRegisteredFormats() {
        long l2 = 0L;
        b.readLock().lock();
        try {
            for (IImageLoaderDescriptor iImageLoaderDescriptor : a.getValues()) {
                l2 |= iImageLoaderDescriptor.getSupportedFormat();
            }
            long l3 = l2;
            return l3;
        }
        finally {
            b.readLock().unlock();
        }
    }

    public static IImageLoaderDescriptor[] getRegisteredDescriptors() {
        b.readLock().lock();
        try {
            IGenericCollection iGenericCollection = a.getValues();
            IImageLoaderDescriptor[] iImageLoaderDescriptorArray = new IImageLoaderDescriptor[iGenericCollection.size()];
            iGenericCollection.copyToTArray(iImageLoaderDescriptorArray, 0);
            IImageLoaderDescriptor[] iImageLoaderDescriptorArray2 = iImageLoaderDescriptorArray;
            return iImageLoaderDescriptorArray2;
        }
        finally {
            b.readLock().unlock();
        }
    }

    public static void register(IImageLoaderDescriptor iImageLoaderDescriptor) {
        if (iImageLoaderDescriptor == null) {
            throw new NullPointerException("imageLoaderDescriptor");
        }
        b.writeLock().lock();
        try {
            if (!a.containsKey(iImageLoaderDescriptor.getSupportedFormat())) {
                a.addItem(iImageLoaderDescriptor.getSupportedFormat(), iImageLoaderDescriptor);
            }
        }
        finally {
            b.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IImageLoaderDescriptor getFirstSupportedDescriptorByTypeName(String string) {
        IImageLoaderDescriptor iImageLoaderDescriptor = null;
        b.readLock().lock();
        try {
            for (IImageLoaderDescriptor iImageLoaderDescriptor2 : a.getValues()) {
                if (!aV.e(aD.b(iImageLoaderDescriptor2).u(), string)) continue;
                iImageLoaderDescriptor = iImageLoaderDescriptor2;
            }
            IGenericEnumerator iGenericEnumerator = iImageLoaderDescriptor;
            return iGenericEnumerator;
        }
        finally {
            b.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IImageLoaderDescriptor getFirstSupportedDescriptorByFileFormat(long l2) {
        Object object;
        b.readLock().lock();
        try {
            Object[] objectArray = new IImageLoaderDescriptor[]{null};
            a.tryGetValue(l2, objectArray);
            object = objectArray[0];
        }
        finally {
            b.readLock().unlock();
        }
        return object;
    }

    public static IImageLoaderDescriptor getFirstSupportedDescriptor(InputStream inputStream, LoadOptions loadOptions) {
        LoadOptions loadOptions2 = loadOptions;
        Stream stream = Stream.fromJava(inputStream);
        return ImageLoadersRegistry.a(stream, loadOptions2, true);
    }

    public static IImageLoaderDescriptor a(Stream stream, LoadOptions loadOptions) {
        return ImageLoadersRegistry.a(stream, loadOptions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IImageLoaderDescriptor a(Stream stream, LoadOptions loadOptions, boolean bl2) {
        if (loadOptions != null && loadOptions.getConcurrentImageProcessing()) {
            b.readLock().lock();
            try {
                Object object;
                SortedList<Long, IImageLoaderDescriptor> sortedList = new SortedList<Long, IImageLoaderDescriptor>(a);
                Object object2 = object = cs.a(stream);
                synchronized (object2) {
                    IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.a(stream, loadOptions, bl2, sortedList);
                    return iImageLoaderDescriptor;
                }
            }
            finally {
                b.readLock().unlock();
            }
        }
        return ImageLoadersRegistry.a(stream, loadOptions, bl2, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IImageLoaderDescriptor a(Stream stream, LoadOptions loadOptions, boolean bl2, SortedList<Long, IImageLoaderDescriptor> sortedList) {
        IImageLoaderDescriptor iImageLoaderDescriptor;
        block16: {
            IDisposable iDisposable;
            String string = null;
            cs[] csArray = new cs[]{null};
            boolean bl3 = cs.a((Object)stream, csArray);
            cs cs2 = csArray[0];
            if (bl3 && cs2.b() instanceof FileStream && !cs2.c()) {
                iDisposable = (FileStream)cs2.b();
                string = com.aspose.imaging.internal.mw.k.e(((FileStream)iDisposable).getName());
                stream.seek(0L, 0);
            }
            iDisposable = new StreamContainer(stream);
            List<Long> list = com.aspose.imaging.internal.kj.a.a(string);
            boolean bl4 = list != null && !list.isEmpty();
            try {
                IImageLoaderDescriptor iImageLoaderDescriptor2;
                LoadOptions loadOptions2 = loadOptions;
                IDisposable iDisposable2 = iDisposable;
                List<Long> list2 = list;
                if (list2 == null) {
                    iImageLoaderDescriptor2 = null;
                } else {
                    IImageLoaderDescriptor iImageLoaderDescriptor3 = null;
                    Iterator iterator = list2.iterator();
                    Object[] objectArray = new IImageLoaderDescriptor[]{null};
                    while (iterator.hasNext() && iImageLoaderDescriptor3 == null) {
                        boolean bl5 = a.tryGetValue((Long)iterator.next(), objectArray);
                        Object object = objectArray[0];
                        if (!bl5) continue;
                        iImageLoaderDescriptor3 = ImageLoadersRegistry.a((IImageLoaderDescriptor)object, (StreamContainer)iDisposable2, loadOptions2);
                    }
                    iImageLoaderDescriptor2 = iImageLoaderDescriptor = iImageLoaderDescriptor3;
                }
                if (iImageLoaderDescriptor != null) break block16;
                for (KeyValuePair keyValuePair : a) {
                    if (bl4 && list.contains(keyValuePair.getKey()) || (iImageLoaderDescriptor = ImageLoadersRegistry.a((IImageLoaderDescriptor)keyValuePair.getValue(), (StreamContainer)iDisposable, loadOptions)) == null) continue;
                    break;
                }
            }
            finally {
                Object object = ((StreamContainer)iDisposable).getSyncRoot();
                synchronized (object) {
                    if (!((StreamContainer)iDisposable).isStreamDisposedOnClose() && bl2) {
                        csArray[0] = cs2;
                        boolean bl6 = cs.a(iDisposable, csArray);
                        cs2 = csArray[0];
                        if (bl6) {
                            ct.a().a(cs2);
                        }
                    }
                }
                ((StreamContainer)iDisposable).seekBegin();
                ((DisposableObject)iDisposable).close();
            }
        }
        return iImageLoaderDescriptor;
    }

    public static void a(java.util.List<IImageLoaderDescriptor> list) {
        b.writeLock().lock();
        try {
            for (IImageLoaderDescriptor iImageLoaderDescriptor : list) {
                if (a.containsKey(iImageLoaderDescriptor.getSupportedFormat())) continue;
                a.addItem(iImageLoaderDescriptor.getSupportedFormat(), iImageLoaderDescriptor);
            }
        }
        finally {
            b.writeLock().unlock();
        }
    }

    public static void b(java.util.List<IImageLoaderDescriptor> list) {
        b.writeLock().lock();
        try {
            for (IImageLoaderDescriptor iImageLoaderDescriptor : list) {
                if (iImageLoaderDescriptor == null) continue;
                a.removeItemByKey(iImageLoaderDescriptor.getSupportedFormat());
            }
        }
        finally {
            b.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IImageLoader a(long l2) {
        b.readLock().lock();
        try {
            Object[] objectArray = new IImageLoaderDescriptor[]{null};
            a.tryGetValue(l2, objectArray);
            IImageLoader iImageLoader = objectArray[0] != null ? objectArray[0].createInstance() : null;
            return iImageLoader;
        }
        finally {
            b.readLock().unlock();
        }
    }

    private static IImageLoaderDescriptor a(IImageLoaderDescriptor iImageLoaderDescriptor, StreamContainer streamContainer, LoadOptions loadOptions) {
        streamContainer.seekBegin();
        IImageLoaderDescriptor iImageLoaderDescriptor2 = null;
        if (iImageLoaderDescriptor instanceof aN) {
            aN aN2 = (aN)iImageLoaderDescriptor;
            iImageLoaderDescriptor2 = aN2.a(streamContainer, loadOptions);
        } else if (iImageLoaderDescriptor.canLoad(streamContainer, loadOptions)) {
            iImageLoaderDescriptor2 = iImageLoaderDescriptor;
        }
        return iImageLoaderDescriptor2;
    }

    private static IImageLoaderDescriptor a(java.util.List<Long> list, StreamContainer streamContainer, LoadOptions loadOptions) {
        if (list == null) {
            return null;
        }
        IImageLoaderDescriptor iImageLoaderDescriptor = null;
        Iterator<Long> iterator = list.iterator();
        Object[] objectArray = new IImageLoaderDescriptor[]{null};
        while (iterator.hasNext() && iImageLoaderDescriptor == null) {
            boolean bl2 = a.tryGetValue(iterator.next(), objectArray);
            Object object = objectArray[0];
            if (!bl2) continue;
            iImageLoaderDescriptor = ImageLoadersRegistry.a((IImageLoaderDescriptor)object, streamContainer, loadOptions);
        }
        return iImageLoaderDescriptor;
    }

    public static IImageLoader createFirstSupportedLoader(InputStream inputStream, LoadOptions loadOptions) {
        return ImageLoadersRegistry.b(Stream.fromJava(inputStream), loadOptions, true);
    }

    public static IImageLoader b(Stream stream, LoadOptions loadOptions, boolean bl2) {
        IImageLoader iImageLoader = null;
        IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.a(stream, loadOptions, bl2);
        if (iImageLoaderDescriptor != null) {
            iImageLoader = iImageLoaderDescriptor.createInstance();
        }
        return iImageLoader;
    }

    public static void registerLoader(IImageLoaderDescriptor iImageLoaderDescriptor) {
        if (iImageLoaderDescriptor == null) {
            throw new NullPointerException("loaderDescriptor");
        }
        if (!FileFormatExtensions.isSingleFormatDefined(iImageLoaderDescriptor.getSupportedFormat())) {
            throw new ArgumentException("Loader should support only single file format.", "loaderDescriptor");
        }
        ImageLoadersRegistry.register(iImageLoaderDescriptor);
    }

    public static void unregisterLoader(IImageLoaderDescriptor iImageLoaderDescriptor) {
        if (iImageLoaderDescriptor == null) {
            throw new NullPointerException("loaderDescriptor");
        }
        b.writeLock().lock();
        try {
            int n2 = a.indexOfValue(iImageLoaderDescriptor);
            if (n2 >= 0) {
                a.removeAt(n2);
            }
        }
        finally {
            b.writeLock().unlock();
        }
    }

    static {
        ArrayList<IImageLoaderDescriptor> arrayList = new ArrayList<IImageLoaderDescriptor>(30);
        arrayList.add(new O());
        arrayList.add(new m());
        arrayList.add(new K());
        arrayList.add(new Q());
        arrayList.add(new c());
        arrayList.add(new C());
        arrayList.add(new S());
        arrayList.add(new e());
        arrayList.add(new g());
        arrayList.add(new y());
        arrayList.add(new w());
        arrayList.add(new A());
        arrayList.add(new o());
        arrayList.add(new X());
        arrayList.add(new s());
        arrayList.add(new q());
        arrayList.add(new u());
        arrayList.add(new Z());
        arrayList.add(new F());
        arrayList.add(new i());
        arrayList.add(new k());
        arrayList.add(new H());
        ImageLoadersRegistry.a(arrayList);
    }
}

