/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.extensions;

import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.imageoptions.VectorRasterizationOptions;
import com.aspose.imaging.internal.aN.N;
import com.aspose.imaging.sources.StreamSource;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;

public final class ImageExtensions {
    private ImageExtensions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RasterImage fromJava(BufferedImage bufferedImage, Rectangle rectangle) {
        RasterImage rasterImage;
        Class<?> clazz;
        int[] nArray = bufferedImage.getRGB(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), null, 0, rectangle.getWidth());
        try {
            clazz = Class.forName(Image.class.getPackage().getName() + ".imageoptions.PngOptions");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(Image.class.getPackage().getName() + ".imageoptions.BmpOptions");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new FrameworkException("PNG/BMP image is unsupported.");
            }
        }
        try {
            ImageOptionsBase imageOptionsBase = (ImageOptionsBase)clazz.newInstance();
            imageOptionsBase.setSource(new StreamSource());
            rasterImage = (RasterImage)Image.create(imageOptionsBase, rectangle.getWidth(), rectangle.getHeight());
            boolean bl2 = true;
            try {
                rasterImage.saveArgb32Pixels(new Rectangle(0, 0, rectangle.getWidth(), rectangle.getHeight()), nArray);
                bl2 = false;
            }
            finally {
                if (bl2) {
                    rasterImage.close();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FrameworkException("PNG/BMP image is unsupported.", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new FrameworkException("PNG/BMP image is unsupported.", instantiationException);
        }
        return rasterImage;
    }

    public static RasterImage fromJava(BufferedImage bufferedImage) {
        return ImageExtensions.fromJava(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public static BufferedImage toJava(Image image) {
        return ImageExtensions.toJava(image, image.getBounds(), 2);
    }

    public static BufferedImage toJava(Image image, int n2) {
        return ImageExtensions.toJava(image, image.getBounds(), n2);
    }

    public static BufferedImage toJava(Image image, Rectangle rectangle) {
        return ImageExtensions.toJava(image, rectangle, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toJava(Image disposableObject, Rectangle rectangle, int n2) {
        BufferedImage bufferedImage;
        Serializable serializable;
        if (disposableObject == null) {
            throw new NullPointerException("Parameter image must be not null!");
        }
        DisposableObject disposableObject2 = null;
        String string = null;
        if (!(disposableObject instanceof RasterImage)) {
            string = N.c();
            try {
                serializable = Class.forName(Image.class.getPackage().getName() + ".imageoptions.PngOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    serializable = Class.forName(Image.class.getPackage().getName() + ".imageoptions.BmpOptions");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new FrameworkException("Non-raster images is unsupported.", classNotFoundException2);
                }
            }
            try {
                ImageOptionsBase imageOptionsBase = (ImageOptionsBase)((Class)serializable).newInstance();
                imageOptionsBase.setVectorRasterizationOptions((VectorRasterizationOptions)disposableObject.getDefaultOptions(new Object[]{disposableObject.getBackgroundColor(), disposableObject.getWidth(), disposableObject.getHeight()}));
                disposableObject.save(string, imageOptionsBase);
                disposableObject2 = (RasterImage)Image.load(string);
                disposableObject = disposableObject2;
            }
            catch (RuntimeException runtimeException) {
                File file = new File(string);
                if (file.exists() && file.delete()) {
                    com.aspose.imaging.internal.mo.a.b("File could not be deleted: " + string);
                }
                throw runtimeException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FrameworkException("Non-raster images is unsupported.", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new FrameworkException("Non-raster images is unsupported.", instantiationException);
            }
        }
        try {
            serializable = (RasterImage)disposableObject;
            bufferedImage = new BufferedImage(rectangle.getWidth(), rectangle.getHeight(), n2);
            a a2 = new a(bufferedImage);
            ((RasterImage)((Object)serializable)).loadPartialArgb32Pixels(rectangle, a2);
        }
        finally {
            if (disposableObject2 != null) {
                disposableObject2.dispose();
                serializable = new File(string);
                if (((File)serializable).exists() && ((File)serializable).delete()) {
                    com.aspose.imaging.internal.mo.a.b("File could not be deleted: " + string);
                }
            }
        }
        return bufferedImage;
    }

    static class a
    implements IPartialArgb32PixelLoader {
        private final BufferedImage a;

        public a(BufferedImage bufferedImage) {
            this.a = bufferedImage;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.a.getWidth();
            int n3 = this.a.getHeight();
            if (point.getY() == rectangle.getY() && point.getX() == rectangle.getX() && point2.getX() - point.getX() == n2 && point2.getY() - point.getY() == n3) {
                this.a.setRGB(0, 0, n2, n3, nArray, 0, n2);
            } else {
                int n4 = point.getX() - rectangle.getX();
                int n5 = point.getY() - rectangle.getY();
                n2 = point2.getX() - point.getX();
                n3 = point2.getY() - point.getY();
                this.a.setRGB(n4, n5, n2, n3, nArray, 0, n2);
            }
        }
    }
}

