/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.jpeg;

import com.aspose.imaging.Color;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.ResolutionSetting;
import com.aspose.imaging.ResolutionUnit;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.imageformats.JpegException;
import com.aspose.imaging.exif.JpegExifData;
import com.aspose.imaging.fileformats.jpeg.JFIFData;
import com.aspose.imaging.fileformats.jpeg.a;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffBigEndianStreamWriter;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.imageoptions.JpegOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.aN.aO;
import com.aspose.imaging.internal.aN.bQ;
import com.aspose.imaging.internal.aN.bt;
import com.aspose.imaging.internal.aN.bx;
import com.aspose.imaging.internal.aN.cs;
import com.aspose.imaging.internal.aN.ct;
import com.aspose.imaging.internal.aN.cv;
import com.aspose.imaging.internal.fY.E;
import com.aspose.imaging.internal.fY.I;
import com.aspose.imaging.internal.fY.Q;
import com.aspose.imaging.internal.fY.T;
import com.aspose.imaging.internal.fY.V;
import com.aspose.imaging.internal.fY.b;
import com.aspose.imaging.internal.fY.e;
import com.aspose.imaging.internal.fY.l;
import com.aspose.imaging.internal.fY.n;
import com.aspose.imaging.internal.fY.o;
import com.aspose.imaging.internal.fY.r;
import com.aspose.imaging.internal.fY.t;
import com.aspose.imaging.internal.gc.c;
import com.aspose.imaging.internal.gc.g;
import com.aspose.imaging.internal.jE.m;
import com.aspose.imaging.internal.mh.aV;
import com.aspose.imaging.internal.mh.au;
import com.aspose.imaging.internal.na.j;
import com.aspose.imaging.internal.rj.d;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.EnumExtensions;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPackage;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class JpegImage
extends RasterCachedImage {
    private static final int j = 65535;
    private int k;
    private JpegOptions l;
    private int m;
    private boolean n;
    private StreamSource o;
    private StreamSource p;
    private final List<Image> q = new List();
    private byte[] r;

    public JpegImage(String string) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        this.a(new Q(string));
    }

    public JpegImage(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    JpegImage(Stream stream) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a(new Q(stream));
    }

    public JpegImage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("rasterImage");
        }
        this.a(new Q(rasterImage), rasterImage.getWidth(), rasterImage.getHeight());
    }

    public JpegImage(int n2, int n3) {
        this(new JpegOptions(), n2, n3);
    }

    public JpegImage(JpegOptions jpegOptions, int n2, int n3) {
        this.l = jpegOptions;
        this.m = n2;
        this.k = n3;
    }

    private JpegImage(int n2, int n3, int n4, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        this.a(iRasterImageArgb32PixelLoader, n2, n3);
        switch (n4) {
            case 0: {
                this.l.setColorType(0);
                break;
            }
            case 1: {
                this.l.setColorType(4);
                break;
            }
            case 3: {
                this.l.setColorType(1);
                break;
            }
            case 4: {
                this.l.setColorType(2);
                break;
            }
            case 5: {
                this.l.setColorType(3);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("pixelFormat");
            }
        }
    }

    @Override
    public long getFileFormat() {
        return 8L;
    }

    public JpegOptions getJpegOptions() {
        this.b(com.aspose.imaging.internal.jE.m.c());
        return this.l;
    }

    @Override
    public int getBitsPerPixel() {
        this.b(com.aspose.imaging.internal.jE.m.c());
        return 8 * this.getRawDataFormat().getChannelsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return this.l.getComment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComment(String string) {
        Object object = this.c;
        synchronized (object) {
            this.l.setComment(string);
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpegExifData getExifData() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return this.l.getExifData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExifData(JpegExifData jpegExifData) {
        Object object = this.c;
        synchronized (object) {
            if (this.l != null && this.l.getExifData() != null && this.l.getExifData().getThumbnail() != null) {
                this.q.addItem(this.l.getExifData().getThumbnail());
            }
            if (this.l != null) {
                this.l.setExifData(jpegExifData);
            }
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmpPacketWrapper getXmpData() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return this.l.getXmpData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        Object object = this.c;
        synchronized (object) {
            this.l.setXmpData(xmpPacketWrapper);
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    @Override
    public int getHeight() {
        return this.k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getHorizontalResolution() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
                return this.getExifData().getXResolution().getValueD();
            }
            return this.getJfif() != null ? (double)this.getJfif().getXDensity() : 72.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHorizontalResolution(double d2) {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            JpegExifData jpegExifData = this.getExifData();
            if (jpegExifData == null) {
                jpegExifData = new JpegExifData();
                this.setExifData(jpegExifData);
            }
            jpegExifData.setResolutionUnit(2);
            jpegExifData.setXResolution(new TiffRational(com.aspose.imaging.internal.rj.d.f(d2)));
            JFIFData jFIFData = this.getJfif();
            if (jFIFData == null) {
                jFIFData = new JFIFData();
                this.setJfif(jFIFData);
            }
            jFIFData.setDensityUnits((byte)1);
            jFIFData.setXDensity(com.aspose.imaging.internal.rj.d.c(d2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFIFData getJfif() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return this.l.getJfif();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJfif(JFIFData jFIFData) {
        Object object = this.c;
        synchronized (object) {
            if (this.l != null && this.l.getJfif() != null && this.l.getJfif().getThumbnail() != null) {
                this.q.addItem(this.l.getJfif().getThumbnail());
            }
            if (this.l != null) {
                this.l.setJfif(jFIFData);
                this.b(com.aspose.imaging.internal.jE.m.c());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PixelDataFormat getRawDataFormat() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return JpegImage.a(this.l.getColorType(), this.l.getBitsPerChannel() & 0xFF, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getVerticalResolution() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
                return this.getExifData().getYResolution().getValueD();
            }
            return this.getJfif() != null ? (double)this.getJfif().getYDensity() : 72.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVerticalResolution(double d2) {
        Object object = this.c;
        synchronized (object) {
            if (this.getExifData() == null) {
                this.setExifData(new JpegExifData());
            }
            this.getExifData().setResolutionUnit(2);
            this.getExifData().setYResolution(new TiffRational(com.aspose.imaging.internal.rj.d.f(d2)));
            if (this.getJfif() == null) {
                this.setJfif(new JFIFData());
            }
            this.getJfif().setDensityUnits((byte)1);
            this.getJfif().setYDensity(com.aspose.imaging.internal.rj.d.c(d2));
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    @Override
    public int getWidth() {
        return this.m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource getRgbColorProfile() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return this.o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRgbColorProfile(StreamSource streamSource) {
        Object object = this.c;
        synchronized (object) {
            this.o = streamSource;
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource getCmykColorProfile() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return this.p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCmykColorProfile(StreamSource streamSource) {
        Object object = this.c;
        synchronized (object) {
            this.p = streamSource;
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource getDestinationRgbColorProfile() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return this.l.getRgbColorProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationRgbColorProfile(StreamSource streamSource) {
        Object object = this.c;
        synchronized (object) {
            this.l.setRgbColorProfile(streamSource);
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource getDestinationCmykColorProfile() {
        Object object = this.c;
        synchronized (object) {
            this.b(com.aspose.imaging.internal.jE.m.c());
            return this.l.getCmykColorProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationCmykColorProfile(StreamSource streamSource) {
        Object object = this.c;
        synchronized (object) {
            this.l.setCmykColorProfile(streamSource);
            this.b(com.aspose.imaging.internal.jE.m.c());
        }
    }

    public boolean getIgnoreEmbeddedColorProfile() {
        this.b(com.aspose.imaging.internal.jE.m.c());
        return this.n;
    }

    public void setIgnoreEmbeddedColorProfile(boolean bl2) {
        this.n = bl2;
        this.b(com.aspose.imaging.internal.jE.m.c());
    }

    public byte[] p() {
        return this.r;
    }

    public void a(byte[] byArray) {
        this.r = byArray;
    }

    @Override
    public com.aspose.imaging.internal.mh.Q e(boolean bl2) {
        if (!bl2 && this.getExifData() != null && !aV.b(this.getExifData().getDateTime())) {
            String[] stringArray = aV.a(this.getExifData().getDateTime(), ' ');
            if (stringArray.length != 2) {
                throw new FrameworkException(aV.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            String[] stringArray2 = aV.a(stringArray[0], ':');
            if (stringArray2.length != 3) {
                throw new FrameworkException(aV.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            String[] stringArray3 = aV.a(stringArray[1], ':');
            if (stringArray3.length != 3) {
                throw new FrameworkException(aV.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            this.b(com.aspose.imaging.internal.jE.m.c());
            String string = stringArray2[0];
            int n2 = com.aspose.imaging.internal.na.j.a(string);
            string = stringArray2[1];
            int n3 = com.aspose.imaging.internal.na.j.a(string);
            string = stringArray2[2];
            int n4 = com.aspose.imaging.internal.na.j.a(string);
            string = stringArray3[0];
            int n5 = com.aspose.imaging.internal.na.j.a(string);
            string = stringArray3[1];
            int n6 = com.aspose.imaging.internal.na.j.a(string);
            string = stringArray3[2];
            return new com.aspose.imaging.internal.mh.Q(n2, n3, n4, n5, n6, com.aspose.imaging.internal.na.j.a(string));
        }
        return super.e(bl2);
    }

    @Override
    public void setResolution(double d2, double d3) {
        this.setHorizontalResolution(d2);
        this.setVerticalResolution(d3);
        this.b(com.aspose.imaging.internal.jE.m.c());
    }

    public void autoRotate() {
        JpegExifData jpegExifData = this.getExifData();
        if (jpegExifData != null) {
            int n2 = jpegExifData.getOrientation();
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: {
                    this.rotateFlip(4);
                    break;
                }
                case 3: {
                    this.rotateFlip(12);
                    break;
                }
                case 4: {
                    this.rotateFlip(8);
                    break;
                }
                case 5: {
                    this.rotateFlip(5);
                    break;
                }
                case 6: {
                    this.rotateFlip(1);
                    break;
                }
                case 7: {
                    this.rotateFlip(9);
                    break;
                }
                case 8: {
                    this.rotateFlip(13);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException("The 'Orientation' value of 'JpegExifData' is out of allowed range [1...8], so auto-rotation can not be performed.");
                }
            }
            jpegExifData.setOrientation(1);
        }
    }

    @Override
    protected boolean b(int n2) {
        if (n2 == 3 || n2 == 2) {
            return true;
        }
        return super.b(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseManagedResources() {
        JFIFData jFIFData;
        JpegExifData jpegExifData = this.getExifData();
        if (jpegExifData != null && jpegExifData.getThumbnail() != null) {
            this.q.addItem(jpegExifData.getThumbnail());
            jpegExifData.setThumbnail(null);
        }
        if ((jFIFData = this.getJfif()) != null && jFIFData.getThumbnail() != null) {
            this.q.addItem(jFIFData.getThumbnail());
            jFIFData.setThumbnail(null);
        }
        IGenericEnumerator iGenericEnumerator = this.q.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Image image = (Image)iGenericEnumerator.next();
                IDisposable iDisposable = (IDisposable)((Object)com.aspose.imaging.internal.rj.d.a(image, IDisposable.class));
                if (iDisposable == null) continue;
                iDisposable.dispose();
            }
        }
        finally {
            if (com.aspose.imaging.internal.rj.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        super.releaseManagedResources();
    }

    @Override
    protected void updateMetadata() {
        if (this.getUpdateXmpData()) {
            try {
                JpegExifData jpegExifData = this.getExifData();
                if (jpegExifData == null) {
                    jpegExifData = new JpegExifData();
                }
                JpegExifData jpegExifData2 = jpegExifData;
                com.aspose.imaging.internal.mh.Q q2 = com.aspose.imaging.internal.mh.Q.m();
                String string = aV.a("{0:D4}:{1:D2}:{2:D2} {3:D2}:{4:D2}:{5:D2}", q2.t(), q2.l(), q2.e(), q2.h(), q2.k(), q2.p());
                jpegExifData2.setDateTime(string);
                this.setExifData(jpegExifData2);
            }
            catch (RuntimeException runtimeException) {
                com.aspose.imaging.internal.mo.a.d(aV.a(new String[]{"Exception on WaveletMap.Duplicate: ", runtimeException.toString()}));
            }
        }
        super.updateMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] a(JpegExifData jpegExifData) {
        byte[] byArray;
        byte[] byArray2 = jpegExifData.serializeExifData();
        if (byArray2.length > 65528) {
            throw new JpegException("Exif segment is excessively big to be stored in jpeg file. Consider JpegExifData.serializeExifData() method for result data size estimation.");
        }
        StreamContainer streamContainer = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer);
            byte[] byArray3 = new byte[]{-1, -31};
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.writeUShort(byArray2.length + 8 & 0xFFFF);
            byte[] byArray4 = new byte[]{69, 120, 105, 102, 0, 0};
            tiffBigEndianStreamWriter.write(byArray4);
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer.toBytes();
        }
        finally {
            streamContainer.dispose();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] a(XmpPacketWrapper xmpPacketWrapper) {
        byte[] byArray;
        int n2;
        int n3;
        if (xmpPacketWrapper == null) {
            throw new ArgumentNullException("xmpData");
        }
        String string = xmpPacketWrapper.b();
        byte[] byArray2 = com.aspose.imaging.internal.mU.l.x().c(string);
        int n4 = byArray2.length + 2 + (n3 = "http://ns.adobe.com/xap/1.0/".length() + 1);
        if (n4 > (n2 = 65533 - n3)) {
            throw new JpegException(aV.a("XMP could not be grater than {0} bytes", new Object[]{n2}));
        }
        int n5 = n4 & 0xFFFF;
        String string2 = aV.a(new Object[]{"http://ns.adobe.com/xap/1.0/", Character.valueOf('\u0000')});
        byte[] byArray3 = com.aspose.imaging.internal.mU.l.x().c(string2);
        StreamContainer streamContainer = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer);
            byte[] byArray4 = new byte[]{-1, -31};
            tiffBigEndianStreamWriter.write(byArray4);
            tiffBigEndianStreamWriter.writeUShort(n5 & 0xFFFF);
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer.toBytes();
        }
        finally {
            streamContainer.dispose();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(RasterImage rasterImage, Stream stream, JFIFData jFIFData, JpegExifData jpegExifData, XmpPacketWrapper xmpPacketWrapper, byte[] byArray, JpegOptions jpegOptions, Rectangle rectangle) {
        if (rasterImage.getWidth() > 65535 || rasterImage.getHeight() > 65535) {
            throw new NotSupportedException(aV.a("JPEG supports maximum size dimension of {0}. Saved image is {1} x {2}", new Object[]{65535, rasterImage.getWidth(), rasterImage.getHeight()}));
        }
        XmpPacketWrapper[] xmpPacketWrapperArray = new V(stream);
        try {
            int n2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            block103: {
                Object object7;
                int n3;
                Object object8;
                object6 = xmpPacketWrapperArray;
                ((StreamContainer)object6).writeByte((byte)-1);
                ((StreamContainer)object6).writeByte((byte)-40);
                ResolutionSetting resolutionSetting = jpegOptions.getResolutionSettings();
                if (resolutionSetting != null) {
                    if (jpegExifData == null) {
                        jpegExifData = new JpegExifData();
                    }
                    jpegExifData.setXResolution(new TiffRational(com.aspose.imaging.internal.rj.d.f(jpegOptions.getResolutionSettings().getHorizontalResolution()), 1L));
                    jpegExifData.setYResolution(new TiffRational(com.aspose.imaging.internal.rj.d.f(jpegOptions.getResolutionSettings().getVerticalResolution()), 1L));
                    switch (jpegOptions.getResolutionUnit()) {
                        case 0: {
                            jpegExifData.setResolutionUnit(1);
                            break;
                        }
                        case 1: {
                            jpegExifData.setResolutionUnit(2);
                            break;
                        }
                        case 2: {
                            jpegExifData.setResolutionUnit(3);
                            break;
                        }
                        default: {
                            throw new NotSupportedException(aV.a(new String[]{"Unsupported resolution unit ", EnumExtensions.toString(ResolutionUnit.class, jpegOptions.getResolutionUnit())}));
                        }
                    }
                }
                if (jFIFData != null) {
                    JFIFData.write(jFIFData, (V)xmpPacketWrapperArray);
                }
                XmpPacketWrapper[] xmpPacketWrapperArray2 = new XmpPacketWrapper[]{xmpPacketWrapper};
                object5 = jpegOptions;
                object6 = xmpPacketWrapperArray2;
                if (object6[0] == null) {
                    object6[0] = new XmpPacketWrapper();
                }
                if ((object8 = (com.aspose.imaging.internal.kC.c)((Object)com.aspose.imaging.internal.rj.d.a(object6[0].getPackage("https://products.aspose.com/imaging/"), com.aspose.imaging.internal.kC.c.class))) == null) {
                    object8 = new com.aspose.imaging.internal.kC.c();
                    object6[0].addPackage((XmpPackage)object8);
                }
                ((com.aspose.imaging.internal.kC.c)object8).a(au.b(((JpegOptions)object5).getQuality()));
                xmpPacketWrapper = xmpPacketWrapperArray2[0];
                object5 = jpegExifData;
                object6 = xmpPacketWrapperArray;
                if (object5 != null) {
                    object8 = JpegImage.a((JpegExifData)object5);
                    ((StreamContainer)object6).write((byte[])object8, 0, ((Object)object8).length);
                }
                object5 = xmpPacketWrapper;
                object6 = xmpPacketWrapperArray;
                if (object5 != null) {
                    object8 = JpegImage.a((XmpPacketWrapper)object5);
                    ((StreamContainer)object6).write((byte[])object8, 0, ((Object)object8).length);
                }
                if (!aV.b(jpegOptions.getComment())) {
                    object5 = jpegOptions.getComment();
                    object6 = xmpPacketWrapperArray;
                    if (!aV.b((String)object5)) {
                        object8 = com.aspose.imaging.internal.mU.l.x().c((String)object5);
                        StreamContainer streamContainer = new StreamContainer(new MemoryStream(), true);
                        try {
                            object4 = new TiffBigEndianStreamWriter(streamContainer);
                            object3 = new byte[]{-1, -2};
                            ((TiffStreamWriter)object4).write((byte[])object3);
                            ((TiffStreamWriter)object4).writeUShort(((Object)object8).length + 2 & 0xFFFF);
                            ((TiffStreamWriter)object4).write((byte[])object8);
                            object2 = streamContainer.toBytes();
                        }
                        finally {
                            streamContainer.dispose();
                        }
                        ((StreamContainer)object6).write((byte[])object2, 0, ((Object)object2).length);
                    }
                }
                if (byArray != null) {
                    com.aspose.imaging.internal.fY.a a2 = new com.aspose.imaging.internal.fY.a();
                    a2.a(byArray);
                    a2.a(stream);
                }
                if ((n3 = jpegOptions.getColorType()) == 3 || n3 == 2) {
                    object7 = jpegOptions.getCmykColorProfile() != null ? jpegOptions.getCmykColorProfile().getStream() : aO.a().getStream();
                    cs cs2 = ct.a().a((Stream)object7);
                    try {
                        Object object9 = cs2.getSyncRoot();
                        synchronized (object9) {
                            Object object10;
                            object7 = jpegOptions.getCmykColorProfile() != null ? jpegOptions.getCmykColorProfile().getStream() : ((object10 = (JpegImage)((Object)com.aspose.imaging.internal.rj.d.a(rasterImage, JpegImage.class))) != null && ((JpegImage)object10).getCmykColorProfile() != null ? ((JpegImage)object10).getCmykColorProfile().getStream() : aO.a().getStream());
                            object5 = stream;
                            object6 = object7;
                            ((Stream)object6).seek(0L, 0);
                            int n4 = 65515;
                            int n5 = (int)((Stream)object6).getLength();
                            long l2 = (n5 + n4 - 1) / n4;
                            int n6 = 1;
                            while ((long)n6 <= l2) {
                                ((Stream)object5).writeByte((byte)-1);
                                ((Stream)object5).writeByte((byte)-30);
                                object4 = new MemoryStream();
                                try {
                                    object3 = new byte[65515];
                                    int n7 = ((Stream)object6).read((byte[])object3, 0, ((byte[])object3).length);
                                    object = new byte[]{73, 67, 67, 95, 80, 82, 79, 70, 73, 76, 69, 0};
                                    ((MemoryStream)object4).write((byte[])object, 0, ((Object)object).length);
                                    ((MemoryStream)object4).writeByte((byte)n6);
                                    ((MemoryStream)object4).writeByte((byte)l2);
                                    ((MemoryStream)object4).write((byte[])object3, 0, n7);
                                    n2 = (int)((MemoryStream)object4).getLength() + 2;
                                    ((Stream)object5).writeByte((byte)(n2 >> 8 & 0xFF));
                                    ((Stream)object5).writeByte((byte)(n2 & 0xFF));
                                    ((Stream)object5).write(((MemoryStream)object4).toArray(), 0, (int)((MemoryStream)object4).getLength());
                                }
                                finally {
                                    ((Stream)object4).dispose();
                                }
                                ++n6;
                            }
                            object10 = new b();
                            ((b)object10).c(100);
                            ((b)object10).a(0);
                            ((b)object10).b(0);
                            if (n3 == 3) {
                                ((b)object10).a((byte)2);
                            } else {
                                ((b)object10).a((byte)0);
                            }
                            com.aspose.imaging.internal.fY.b.a(stream, (b)object10);
                            jpegOptions.setCmykColorProfile(new StreamSource((Stream)object7));
                            if (jpegOptions.getRgbColorProfile() == null) {
                                jpegOptions.setRgbColorProfile(aO.b());
                            }
                            break block103;
                        }
                    }
                    finally {
                        ct.a().a(cs2);
                    }
                }
                if (n3 == 4) {
                    object7 = new b();
                    ((b)object7).c(100);
                    ((b)object7).a(0);
                    ((b)object7).b(0);
                    ((b)object7).a((byte)0);
                    com.aspose.imaging.internal.fY.b.a(stream, (b)object7);
                }
            }
            switch (jpegOptions.getCompressionType()) {
                case 0: 
                case 1: {
                    object2 = rectangle;
                    XmpPacketWrapper[] xmpPacketWrapperArray3 = xmpPacketWrapperArray;
                    object5 = jpegOptions;
                    object6 = rasterImage;
                    RawDataSettings rawDataSettings = new RawDataSettings();
                    object4 = JpegImage.a(((JpegOptions)object5).getColorType(), ((JpegOptions)object5).getBitsPerChannel() & 0xFF, true);
                    object3 = new Rectangle(0, 0, ((Rectangle)object2).getWidth(), ((Rectangle)object2).getHeight());
                    List<e[]> list = null;
                    object = null;
                    n2 = 2;
                    boolean bl2 = true;
                    while (bl2) {
                        c c2;
                        c c3 = c2 = new c((Rectangle)object3, (JpegOptions)object5, (V)xmpPacketWrapperArray3, (PixelDataFormat)object4, n2, list, ((Image)object6).h());
                        try {
                            a a3 = new a((V)xmpPacketWrapperArray3, (JpegOptions)object5, (Rectangle)object3, (PixelDataFormat)object4, c3, n2, (com.aspose.imaging.internal.gf.c)object);
                            rawDataSettings.setPixelDataFormat((PixelDataFormat)object4);
                            Rectangle rectangle2 = Rectangle.intersect(((Image)object6).getBounds(), (Rectangle)object2);
                            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                                if (((RasterImage)object6).isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == ((RasterImage)object6).getRawDataFormat().getBitsPerPixel() && ((JpegOptions)object5).getColorType() != 3) {
                                    rawDataSettings.setColorPalette(null);
                                    rawDataSettings.setCustomColorConverter(((RasterImage)object6).getRawCustomColorConverter());
                                    rawDataSettings.setFallbackIndex(((RasterImage)object6).getRawFallbackIndex());
                                    rawDataSettings.setIndexedColorConverter(((RasterImage)object6).getRawIndexedColorConverter());
                                    rawDataSettings.setLineSize(((Rectangle)object2).getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                                    bx bx2 = new bx((RasterImage)object6, rawDataSettings, (Rectangle)object2, a3);
                                    try {
                                        ((RasterImage)object6).loadRawData(rectangle2, rectangle2, rawDataSettings, bx2);
                                    }
                                    finally {
                                        bx2.dispose();
                                    }
                                }
                                o o2 = com.aspose.imaging.internal.fY.o.a(a3, (JpegOptions)object5);
                                bt bt2 = new bt((RasterImage)object6, (Rectangle)object2, o2, ((Image)object6).getPalette());
                                try {
                                    IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bt2;
                                    if (((RasterImage)object6).hasTransparentColor()) {
                                        iPartialArgb32PixelLoader = new cv(((RasterImage)object6).getTransparentColor().toArgb(), ((Image)object6).getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                                    }
                                    if (((RasterImage)object6).hasAlpha() && ((JpegOptions)object5).getPreblendAlphaIfPresent()) {
                                        iPartialArgb32PixelLoader = new com.aspose.imaging.internal.aS.b(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                                    }
                                    ((RasterImage)object6).a(rectangle2, iPartialArgb32PixelLoader, true);
                                }
                                finally {
                                    bt2.dispose();
                                }
                            }
                            a3.a(true);
                            n2 = a3.b();
                            if (n2 == 2) {
                                object = a3.a();
                                boolean bl3 = com.aspose.imaging.internal.gc.c.a((JpegOptions)object5);
                                n2 = bl3 ? 0 : 1;
                                continue;
                            }
                            if (n2 == 0) {
                                list = c3.a();
                                n2 = 1;
                                continue;
                            }
                            if (n2 != 1) continue;
                            bl2 = false;
                        }
                        finally {
                            c3.dispose();
                        }
                    }
                    break;
                }
                case 2: {
                    PixelDataFormat pixelDataFormat;
                    object2 = rectangle;
                    XmpPacketWrapper[] xmpPacketWrapperArray4 = xmpPacketWrapperArray;
                    object5 = jpegOptions;
                    object6 = rasterImage;
                    RawDataSettings rawDataSettings = new RawDataSettings();
                    byte by2 = ((JpegOptions)object5).getBitsPerChannel();
                    int n8 = ((JpegOptions)object5).getColorType();
                    if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 16) {
                        throw new NotSupportedException("Lossless JPEG supports only 2 - 16 bits per channel");
                    }
                    if ((by2 & 0xFF) > 8) {
                        throw new NotSupportedException("More than 8 bits per channel is not supported yet.");
                    }
                    switch (n8) {
                        case 0: {
                            pixelDataFormat = PixelDataFormat.getGrayscale(by2 & 0xFF);
                            break;
                        }
                        case 1: {
                            pixelDataFormat = PixelDataFormat.getYCbCr(by2 & 0xFF);
                            break;
                        }
                        case 4: {
                            pixelDataFormat = PixelDataFormat.getRgb(by2 & 0xFF);
                            break;
                        }
                        case 2: {
                            pixelDataFormat = PixelDataFormat.getCmyk(by2 & 0xFF);
                            break;
                        }
                        case 3: {
                            pixelDataFormat = PixelDataFormat.getYcck(by2 & 0xFF);
                            break;
                        }
                        default: {
                            throw new ArgumentOutOfRangeException("colorType");
                        }
                    }
                    object4 = pixelDataFormat;
                    object3 = Rectangle.intersect(((Image)object6).getBounds(), (Rectangle)object2);
                    g g2 = new g(new Rectangle(Point.getEmpty(), ((Rectangle)object3).getSize()), (JpegOptions)object5, (V)xmpPacketWrapperArray4, ((Image)object6).h());
                    try {
                        object = new t((V)xmpPacketWrapperArray4, (PixelDataFormat)object4, g2);
                        rawDataSettings.setPixelDataFormat((PixelDataFormat)object4);
                        if (((Rectangle)object3).getWidth() <= 0 || ((Rectangle)object3).getHeight() <= 0) break;
                        if (((RasterImage)object6).isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == ((RasterImage)object6).getRawDataFormat().getBitsPerPixel() && ((JpegOptions)object5).getColorType() != 3) {
                            rawDataSettings.setColorPalette(null);
                            rawDataSettings.setCustomColorConverter(((RasterImage)object6).getRawCustomColorConverter());
                            rawDataSettings.setFallbackIndex(((RasterImage)object6).getRawFallbackIndex());
                            rawDataSettings.setIndexedColorConverter(((RasterImage)object6).getRawIndexedColorConverter());
                            rawDataSettings.setLineSize(((Rectangle)object2).getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                            bx bx3 = new bx((RasterImage)object6, rawDataSettings, (Rectangle)object2, (IPartialRawDataLoader)object);
                            try {
                                ((RasterImage)object6).loadRawData((Rectangle)object3, (Rectangle)object3, rawDataSettings, bx3);
                                break;
                            }
                            finally {
                                bx3.dispose();
                            }
                        }
                        o o3 = com.aspose.imaging.internal.fY.o.a((IPartialRawDataLoader)object, (JpegOptions)object5);
                        bt bt3 = new bt((RasterImage)object6, (Rectangle)object2, o3, ((Image)object6).getPalette());
                        try {
                            IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bt3;
                            if (((RasterImage)object6).hasTransparentColor() && ((Image)object6).hasBackgroundColor()) {
                                iPartialArgb32PixelLoader = new cv(((RasterImage)object6).getTransparentColor().toArgb(), ((Image)object6).getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                            }
                            if (((RasterImage)object6).hasAlpha() && ((JpegOptions)object5).getPreblendAlphaIfPresent()) {
                                iPartialArgb32PixelLoader = new com.aspose.imaging.internal.aS.b(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                            }
                            ((RasterImage)object6).a((Rectangle)object3, iPartialArgb32PixelLoader, true);
                            break;
                        }
                        finally {
                            bt3.dispose();
                        }
                    }
                    finally {
                        g2.dispose();
                    }
                }
                case 3: {
                    PixelDataFormat pixelDataFormat;
                    object2 = rectangle;
                    XmpPacketWrapper[] xmpPacketWrapperArray5 = xmpPacketWrapperArray;
                    object5 = jpegOptions;
                    object6 = rasterImage;
                    byte by3 = ((JpegOptions)object5).getBitsPerChannel();
                    int n9 = ((JpegOptions)object5).getColorType();
                    if ((by3 & 0xFF) < 2 || (by3 & 0xFF) > 16) {
                        throw new NotSupportedException("JPEG-LS supports only 2-16 bits per channel");
                    }
                    if ((by3 & 0xFF) > 8) {
                        throw new NotSupportedException("Only 2-8 bits per channel is supported in JPEG-LS at the moment.");
                    }
                    switch (n9) {
                        case 0: {
                            pixelDataFormat = PixelDataFormat.getGrayscale(by3 & 0xFF);
                            break;
                        }
                        case 1: {
                            pixelDataFormat = PixelDataFormat.getYCbCr(by3 & 0xFF);
                            break;
                        }
                        case 4: {
                            pixelDataFormat = PixelDataFormat.getRgb(by3 & 0xFF);
                            break;
                        }
                        case 2: {
                            pixelDataFormat = PixelDataFormat.getCmyk(by3 & 0xFF);
                            break;
                        }
                        case 3: {
                            pixelDataFormat = PixelDataFormat.getYcck(by3 & 0xFF);
                            break;
                        }
                        default: {
                            throw new ArgumentOutOfRangeException("colorType");
                        }
                    }
                    PixelDataFormat pixelDataFormat2 = pixelDataFormat;
                    object4 = Rectangle.intersect(((Image)object6).getBounds(), (Rectangle)object2);
                    object3 = new E();
                    ((E)object3).a(((Rectangle)object4).getWidth());
                    ((E)object3).b(((Rectangle)object4).getHeight());
                    ((E)object3).f(((JpegOptions)object5).getJpegLsAllowedLossyError());
                    ((E)object3).g(((JpegOptions)object5).getJpegLsInterleaveMode());
                    ((E)object3).a(((JpegOptions)object5).getJpegLsPreset());
                    ((E)object3).c(((JpegOptions)object5).getBitsPerChannel() & 0xFF);
                    ((E)object3).e(pixelDataFormat2.getChannelsCount());
                    byte[] byArray2 = ((JpegOptions)object5).getHorizontalSampling();
                    object = ((JpegOptions)object5).getVerticalSampling();
                    byte[] byArray3 = new byte[((E)object3).e()];
                    byte[] byArray4 = new byte[((E)object3).e()];
                    for (int i2 = 0; i2 < ((E)object3).e(); ++i2) {
                        byArray3[i2] = byArray2 == null ? (byte)1 : byArray2[i2];
                        byArray4[i2] = object == null ? (byte)1 : (byte)object[i2];
                    }
                    ((E)object3).a(byArray3);
                    ((E)object3).b(byArray4);
                    ((E)object3).p();
                    I i3 = new I((V)xmpPacketWrapperArray5, (E)object3, new Rectangle(Point.getEmpty(), ((Rectangle)object4).getSize()), ((Image)object6).h());
                    try {
                        RawDataSettings rawDataSettings = new RawDataSettings();
                        rawDataSettings.setPixelDataFormat(pixelDataFormat2);
                        if (((Rectangle)object4).getWidth() <= 0 || ((Rectangle)object4).getHeight() <= 0) break;
                        if (((RasterImage)object6).isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == ((RasterImage)object6).getRawDataFormat().getBitsPerPixel() && ((JpegOptions)object5).getColorType() != 3) {
                            rawDataSettings.setColorPalette(null);
                            rawDataSettings.setCustomColorConverter(((RasterImage)object6).getRawCustomColorConverter());
                            rawDataSettings.setFallbackIndex(((RasterImage)object6).getRawFallbackIndex());
                            rawDataSettings.setIndexedColorConverter(((RasterImage)object6).getRawIndexedColorConverter());
                            rawDataSettings.setLineSize(((Rectangle)object2).getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                            bx bx4 = new bx((RasterImage)object6, rawDataSettings, (Rectangle)object2, i3);
                            try {
                                ((RasterImage)object6).loadRawData((Rectangle)object4, (Rectangle)object4, rawDataSettings, bx4);
                                break;
                            }
                            finally {
                                bx4.dispose();
                            }
                        }
                        o o4 = com.aspose.imaging.internal.fY.o.a(i3, (JpegOptions)object5);
                        bt bt4 = new bt((RasterImage)object6, (Rectangle)object2, o4, ((Image)object6).getPalette());
                        try {
                            IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bt4;
                            if (((RasterImage)object6).hasTransparentColor() && ((Image)object6).hasBackgroundColor()) {
                                iPartialArgb32PixelLoader = new cv(((RasterImage)object6).getTransparentColor().toArgb(), ((Image)object6).getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                            }
                            if (((RasterImage)object6).hasAlpha() && ((JpegOptions)object5).getPreblendAlphaIfPresent()) {
                                iPartialArgb32PixelLoader = new com.aspose.imaging.internal.aS.b(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                            }
                            ((RasterImage)object6).a((Rectangle)object4, iPartialArgb32PixelLoader, true);
                            break;
                        }
                        finally {
                            bt4.dispose();
                        }
                    }
                    finally {
                        i3.dispose();
                    }
                }
                default: {
                    throw new ArgumentException();
                }
            }
            object6 = xmpPacketWrapperArray;
            ((StreamContainer)object6).writeByte((byte)-1);
            ((StreamContainer)object6).writeByte((byte)-39);
        }
        finally {
            xmpPacketWrapperArray.close();
        }
    }

    private static void a(XmpPacketWrapper[] xmpPacketWrapperArray, JpegOptions jpegOptions) {
        com.aspose.imaging.internal.kC.c c2;
        if (xmpPacketWrapperArray[0] == null) {
            xmpPacketWrapperArray[0] = new XmpPacketWrapper();
        }
        if ((c2 = (com.aspose.imaging.internal.kC.c)((Object)com.aspose.imaging.internal.rj.d.a(xmpPacketWrapperArray[0].getPackage("https://products.aspose.com/imaging/"), com.aspose.imaging.internal.kC.c.class))) == null) {
            c2 = new com.aspose.imaging.internal.kC.c();
            xmpPacketWrapperArray[0].addPackage(c2);
        }
        c2.a(au.b(jpegOptions.getQuality()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(RasterImage rasterImage, JpegOptions jpegOptions, V v2, Rectangle rectangle) {
        RawDataSettings rawDataSettings = new RawDataSettings();
        PixelDataFormat pixelDataFormat = JpegImage.a(jpegOptions.getColorType(), jpegOptions.getBitsPerChannel() & 0xFF, true);
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.getWidth(), rectangle.getHeight());
        List<e[]> list = null;
        com.aspose.imaging.internal.gf.c c2 = null;
        int n2 = 2;
        boolean bl2 = true;
        while (bl2) {
            c c3;
            c c4 = c3 = new c(rectangle2, jpegOptions, v2, pixelDataFormat, n2, list, rasterImage.h());
            try {
                a a2 = new a(v2, jpegOptions, rectangle2, pixelDataFormat, c4, n2, c2);
                rawDataSettings.setPixelDataFormat(pixelDataFormat);
                Rectangle rectangle3 = Rectangle.intersect(rasterImage.getBounds(), rectangle);
                if (rectangle3.getWidth() > 0 && rectangle3.getHeight() > 0) {
                    if (rasterImage.isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == rasterImage.getRawDataFormat().getBitsPerPixel() && jpegOptions.getColorType() != 3) {
                        rawDataSettings.setColorPalette(null);
                        rawDataSettings.setCustomColorConverter(rasterImage.getRawCustomColorConverter());
                        rawDataSettings.setFallbackIndex(rasterImage.getRawFallbackIndex());
                        rawDataSettings.setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
                        rawDataSettings.setLineSize(rectangle.getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                        bx bx2 = new bx(rasterImage, rawDataSettings, rectangle, a2);
                        try {
                            rasterImage.loadRawData(rectangle3, rectangle3, rawDataSettings, bx2);
                        }
                        finally {
                            bx2.dispose();
                        }
                    }
                    o o2 = com.aspose.imaging.internal.fY.o.a(a2, jpegOptions);
                    bt bt2 = new bt(rasterImage, rectangle, o2, rasterImage.getPalette());
                    try {
                        IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bt2;
                        if (rasterImage.hasTransparentColor()) {
                            iPartialArgb32PixelLoader = new cv(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                        }
                        if (rasterImage.hasAlpha() && jpegOptions.getPreblendAlphaIfPresent()) {
                            iPartialArgb32PixelLoader = new com.aspose.imaging.internal.aS.b(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                        }
                        rasterImage.a(rectangle3, iPartialArgb32PixelLoader, true);
                    }
                    finally {
                        bt2.dispose();
                    }
                }
                a2.a(true);
                n2 = a2.b();
                if (n2 == 2) {
                    c2 = a2.a();
                    boolean bl3 = com.aspose.imaging.internal.gc.c.a(jpegOptions);
                    n2 = bl3 ? 0 : 1;
                    continue;
                }
                if (n2 == 0) {
                    list = c4.a();
                    n2 = 1;
                    continue;
                }
                if (n2 != 1) continue;
                bl2 = false;
            }
            finally {
                c4.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(RasterImage rasterImage, JpegOptions jpegOptions, V v2, Rectangle rectangle) {
        block21: {
            PixelDataFormat pixelDataFormat;
            RawDataSettings rawDataSettings = new RawDataSettings();
            byte by2 = jpegOptions.getBitsPerChannel();
            int n2 = jpegOptions.getColorType();
            if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 16) {
                throw new NotSupportedException("Lossless JPEG supports only 2 - 16 bits per channel");
            }
            if ((by2 & 0xFF) > 8) {
                throw new NotSupportedException("More than 8 bits per channel is not supported yet.");
            }
            switch (n2) {
                case 0: {
                    pixelDataFormat = PixelDataFormat.getGrayscale(by2 & 0xFF);
                    break;
                }
                case 1: {
                    pixelDataFormat = PixelDataFormat.getYCbCr(by2 & 0xFF);
                    break;
                }
                case 4: {
                    pixelDataFormat = PixelDataFormat.getRgb(by2 & 0xFF);
                    break;
                }
                case 2: {
                    pixelDataFormat = PixelDataFormat.getCmyk(by2 & 0xFF);
                    break;
                }
                case 3: {
                    pixelDataFormat = PixelDataFormat.getYcck(by2 & 0xFF);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException("colorType");
                }
            }
            PixelDataFormat pixelDataFormat2 = pixelDataFormat;
            Rectangle rectangle2 = Rectangle.intersect(rasterImage.getBounds(), rectangle);
            g g2 = new g(new Rectangle(Point.getEmpty(), rectangle2.getSize()), jpegOptions, v2, rasterImage.h());
            try {
                t t2 = new t(v2, pixelDataFormat2, g2);
                rawDataSettings.setPixelDataFormat(pixelDataFormat2);
                if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) break block21;
                if (rasterImage.isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == rasterImage.getRawDataFormat().getBitsPerPixel() && jpegOptions.getColorType() != 3) {
                    rawDataSettings.setColorPalette(null);
                    rawDataSettings.setCustomColorConverter(rasterImage.getRawCustomColorConverter());
                    rawDataSettings.setFallbackIndex(rasterImage.getRawFallbackIndex());
                    rawDataSettings.setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
                    rawDataSettings.setLineSize(rectangle.getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                    bx bx2 = new bx(rasterImage, rawDataSettings, rectangle, t2);
                    try {
                        rasterImage.loadRawData(rectangle2, rectangle2, rawDataSettings, bx2);
                        break block21;
                    }
                    finally {
                        bx2.dispose();
                    }
                }
                o o2 = com.aspose.imaging.internal.fY.o.a(t2, jpegOptions);
                bt bt2 = new bt(rasterImage, rectangle, o2, rasterImage.getPalette());
                try {
                    IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bt2;
                    if (rasterImage.hasTransparentColor() && rasterImage.hasBackgroundColor()) {
                        iPartialArgb32PixelLoader = new cv(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                    }
                    if (rasterImage.hasAlpha() && jpegOptions.getPreblendAlphaIfPresent()) {
                        iPartialArgb32PixelLoader = new com.aspose.imaging.internal.aS.b(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                    }
                    rasterImage.a(rectangle2, iPartialArgb32PixelLoader, true);
                }
                finally {
                    bt2.dispose();
                }
            }
            finally {
                g2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void c(RasterImage rasterImage, JpegOptions jpegOptions, V v2, Rectangle rectangle) {
        block22: {
            PixelDataFormat pixelDataFormat;
            byte by2 = jpegOptions.getBitsPerChannel();
            int n2 = jpegOptions.getColorType();
            if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 16) {
                throw new NotSupportedException("JPEG-LS supports only 2-16 bits per channel");
            }
            if ((by2 & 0xFF) > 8) {
                throw new NotSupportedException("Only 2-8 bits per channel is supported in JPEG-LS at the moment.");
            }
            switch (n2) {
                case 0: {
                    pixelDataFormat = PixelDataFormat.getGrayscale(by2 & 0xFF);
                    break;
                }
                case 1: {
                    pixelDataFormat = PixelDataFormat.getYCbCr(by2 & 0xFF);
                    break;
                }
                case 4: {
                    pixelDataFormat = PixelDataFormat.getRgb(by2 & 0xFF);
                    break;
                }
                case 2: {
                    pixelDataFormat = PixelDataFormat.getCmyk(by2 & 0xFF);
                    break;
                }
                case 3: {
                    pixelDataFormat = PixelDataFormat.getYcck(by2 & 0xFF);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException("colorType");
                }
            }
            PixelDataFormat pixelDataFormat2 = pixelDataFormat;
            Rectangle rectangle2 = Rectangle.intersect(rasterImage.getBounds(), rectangle);
            E e2 = new E();
            e2.a(rectangle2.getWidth());
            e2.b(rectangle2.getHeight());
            e2.f(jpegOptions.getJpegLsAllowedLossyError());
            e2.g(jpegOptions.getJpegLsInterleaveMode());
            e2.a(jpegOptions.getJpegLsPreset());
            e2.c(jpegOptions.getBitsPerChannel() & 0xFF);
            e2.e(pixelDataFormat2.getChannelsCount());
            byte[] byArray = jpegOptions.getHorizontalSampling();
            byte[] byArray2 = jpegOptions.getVerticalSampling();
            byte[] byArray3 = new byte[e2.e()];
            byte[] byArray4 = new byte[e2.e()];
            for (int i2 = 0; i2 < e2.e(); ++i2) {
                byArray3[i2] = byArray == null ? (byte)1 : byArray[i2];
                byArray4[i2] = byArray2 == null ? (byte)1 : byArray2[i2];
            }
            e2.a(byArray3);
            e2.b(byArray4);
            e2.p();
            I i3 = new I(v2, e2, new Rectangle(Point.getEmpty(), rectangle2.getSize()), rasterImage.h());
            try {
                RawDataSettings rawDataSettings = new RawDataSettings();
                rawDataSettings.setPixelDataFormat(pixelDataFormat2);
                if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) break block22;
                if (rasterImage.isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == rasterImage.getRawDataFormat().getBitsPerPixel() && jpegOptions.getColorType() != 3) {
                    rawDataSettings.setColorPalette(null);
                    rawDataSettings.setCustomColorConverter(rasterImage.getRawCustomColorConverter());
                    rawDataSettings.setFallbackIndex(rasterImage.getRawFallbackIndex());
                    rawDataSettings.setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
                    rawDataSettings.setLineSize(rectangle.getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                    bx bx2 = new bx(rasterImage, rawDataSettings, rectangle, i3);
                    try {
                        rasterImage.loadRawData(rectangle2, rectangle2, rawDataSettings, bx2);
                        break block22;
                    }
                    finally {
                        bx2.dispose();
                    }
                }
                o o2 = com.aspose.imaging.internal.fY.o.a(i3, jpegOptions);
                bt bt2 = new bt(rasterImage, rectangle, o2, rasterImage.getPalette());
                try {
                    IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bt2;
                    if (rasterImage.hasTransparentColor() && rasterImage.hasBackgroundColor()) {
                        iPartialArgb32PixelLoader = new cv(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                    }
                    if (rasterImage.hasAlpha() && jpegOptions.getPreblendAlphaIfPresent()) {
                        iPartialArgb32PixelLoader = new com.aspose.imaging.internal.aS.b(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                    }
                    rasterImage.a(rectangle2, iPartialArgb32PixelLoader, true);
                }
                finally {
                    bt2.dispose();
                }
            }
            finally {
                i3.dispose();
            }
        }
    }

    private static PixelDataFormat a(int n2, int n3, boolean bl2) {
        PixelDataFormat pixelDataFormat;
        if (bl2 && n3 != 8 && n3 != 12) {
            throw new NotSupportedException("Jpeg DCT supports only 8 or 12 bits per channel.");
        }
        switch (n2) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale(n3);
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr(n3);
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCmyk(n3);
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb(n3);
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck(n3);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    private static PixelDataFormat a(int n2, byte by2) {
        PixelDataFormat pixelDataFormat;
        if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 16) {
            throw new NotSupportedException("Lossless JPEG supports only 2 - 16 bits per channel");
        }
        if ((by2 & 0xFF) > 8) {
            throw new NotSupportedException("More than 8 bits per channel is not supported yet.");
        }
        switch (n2) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale(by2 & 0xFF);
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr(by2 & 0xFF);
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb(by2 & 0xFF);
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCmyk(by2 & 0xFF);
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck(by2 & 0xFF);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    private static PixelDataFormat b(int n2, byte by2) {
        PixelDataFormat pixelDataFormat;
        if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 16) {
            throw new NotSupportedException("JPEG-LS supports only 2-16 bits per channel");
        }
        if ((by2 & 0xFF) > 8) {
            throw new NotSupportedException("Only 2-8 bits per channel is supported in JPEG-LS at the moment.");
        }
        switch (n2) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale(by2 & 0xFF);
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr(by2 & 0xFF);
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb(by2 & 0xFF);
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCmyk(by2 & 0xFF);
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck(by2 & 0xFF);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    @Override
    protected void saveData(Stream stream) {
        this.updateMetadata();
        JpegImage.a(this, stream, this.getJfif(), this.getExifData(), this.getXmpData(), this.r, this.l, this.getBounds());
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.m = n2;
        this.k = n3;
    }

    private static void a(StreamContainer streamContainer, JpegExifData jpegExifData) {
        if (jpegExifData == null) {
            return;
        }
        byte[] byArray = JpegImage.a(jpegExifData);
        streamContainer.write(byArray, 0, byArray.length);
    }

    private static void a(StreamContainer streamContainer, XmpPacketWrapper xmpPacketWrapper) {
        if (xmpPacketWrapper == null) {
            return;
        }
        byte[] byArray = JpegImage.a(xmpPacketWrapper);
        streamContainer.write(byArray, 0, byArray.length);
    }

    private static void b(StreamContainer streamContainer) {
        streamContainer.writeByte((byte)-1);
        streamContainer.writeByte((byte)-40);
    }

    private static void a(V v2) {
        v2.writeByte((byte)-1);
        v2.writeByte((byte)-39);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(StreamContainer streamContainer, String string) {
        byte[] byArray;
        if (aV.b(string)) {
            return;
        }
        byte[] byArray2 = com.aspose.imaging.internal.mU.l.x().c(string);
        StreamContainer streamContainer2 = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer2);
            byte[] byArray3 = new byte[]{-1, -2};
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.writeUShort(byArray2.length + 2 & 0xFFFF);
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer2.toBytes();
        }
        finally {
            streamContainer2.dispose();
        }
        streamContainer.write(byArray, 0, byArray.length);
    }

    private void a(bQ bQ2) {
        this.a(bQ2, bQ2.a().getWidth(), bQ2.a().getHeight());
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3) {
        Object object;
        Object object2;
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        this.m = n2;
        this.k = n3;
        this.l = new JpegOptions();
        n n4 = (n)((Object)com.aspose.imaging.internal.rj.d.a(iRasterImageArgb32PixelLoader, n.class));
        if (n4 != null) {
            if (n4.d() == 3) {
                object2 = n4.e().g();
                this.l.setJpegLsAllowedLossyError(((T)object2).c & 0xFF);
                this.l.setJpegLsInterleaveMode(((T)object2).b);
                this.l.setJpegLsPreset(n4.e().h());
            }
            object2 = n4.e().e();
            object = ((r)object2).b();
            byte[] byArray = new byte[((l[])object).length];
            byte[] byArray2 = new byte[((l[])object).length];
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                byArray[i2] = ((l)object[i2]).c();
                byArray2[i2] = ((l)object[i2]).k();
            }
            this.l.setHorizontalSampling(byArray);
            this.l.setVerticalSampling(byArray2);
            this.l.setCompressionType(n4.d());
        }
        if ((object2 = (bQ)((Object)com.aspose.imaging.internal.rj.d.a(iRasterImageArgb32PixelLoader, bQ.class))) != null && ((bQ)object2).a() != null && (object = (JpegImage)((Object)com.aspose.imaging.internal.rj.d.a(((bQ)object2).a(), JpegImage.class))) != null) {
            this.l.setExifData(((JpegImage)object).getExifData());
            this.l.setComment(((JpegImage)object).getComment());
            this.l.setJfif(((JpegImage)object).getJfif());
            this.l.setXmpData(((JpegImage)object).getXmpData());
        }
    }

    public static JpegImage a(int n2, int n3, int n4, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new JpegImage(n2, n3, n4, iRasterImageArgb32PixelLoader);
    }
}

