/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.imagefilters.complexutils;

import com.aspose.imaging.internal.Exceptions.DivideByZeroException;
import com.aspose.imaging.internal.Exceptions.FormatException;
import com.aspose.imaging.internal.mh.aV;
import com.aspose.imaging.internal.mh.aa;
import com.aspose.imaging.internal.mh.aq;
import com.aspose.imaging.internal.mh.bC;
import com.aspose.imaging.internal.rj.i;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Complex
extends i<Complex>
implements aq<Complex> {
    public static final int SIZE_OF_DOUBLE = 8;
    public static final int SIZE_OF_COMPLEX = 16;
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex I = new Complex(0.0, 1.0);
    private double a;
    private double b;

    public Complex() {
    }

    public Complex(double d2, double d3) {
        this.a = d2;
        this.b = d3;
    }

    public Complex(Complex complex) {
        this.a = complex.a;
        this.b = complex.b;
    }

    public static Complex to_Complex(double d2) {
        return new Complex(d2, 0.0);
    }

    public static Complex to_Complex(float f2) {
        return new Complex(f2, 0.0);
    }

    public static boolean op_Equality(Complex complex, Complex complex2) {
        return complex.a == complex2.a && complex.b == complex2.b;
    }

    public static boolean op_Inequality(Complex complex, Complex complex2) {
        return !Complex.op_Equality(complex, complex2);
    }

    public static Complex op_UnaryNegation(Complex complex) {
        return Complex.negate(complex);
    }

    public static Complex op_Addition(Complex complex, Complex complex2) {
        return Complex.add(complex, complex2);
    }

    public static Complex op_Addition(Complex complex, double d2) {
        return Complex.add(complex, d2);
    }

    public static Complex op_Addition(double d2, Complex complex) {
        return Complex.add(complex, d2);
    }

    public static Complex op_Subtraction(Complex complex, Complex complex2) {
        return Complex.subtract(complex, complex2);
    }

    public static Complex op_Subtraction(Complex complex, double d2) {
        return Complex.subtract(complex, d2);
    }

    public static Complex op_Subtraction(double d2, Complex complex) {
        return Complex.subtract(d2, complex);
    }

    public static Complex op_Multiply(Complex complex, Complex complex2) {
        return Complex.multiply(complex, complex2);
    }

    public static Complex op_Multiply(double d2, Complex complex) {
        return Complex.multiply(complex, d2);
    }

    public static Complex op_Multiply(Complex complex, double d2) {
        return Complex.multiply(complex, d2);
    }

    public static Complex op_Division(Complex complex, Complex complex2) {
        return Complex.divide(complex, complex2);
    }

    public static Complex op_Division(Complex complex, double d2) {
        return Complex.divide(complex, d2);
    }

    public static Complex op_Division(double d2, Complex complex) {
        return Complex.divide(d2, complex);
    }

    public static Complex add(Complex complex, Complex complex2) {
        return new Complex(complex.a + complex2.a, complex.b + complex2.b);
    }

    public static Complex add(Complex complex, double d2) {
        return new Complex(complex.a + d2, complex.b);
    }

    public static void add(Complex complex, Complex complex2, Complex[] complexArray) {
        complexArray[0].a = complex.a + complex2.a;
        complexArray[0].b = complex.b + complex2.b;
    }

    public static void add(Complex complex, double d2, Complex[] complexArray) {
        complexArray[0].a = complex.a + d2;
        complexArray[0].b = complex.b;
    }

    public static Complex subtract(Complex complex, Complex complex2) {
        return new Complex(complex.a - complex2.a, complex.b - complex2.b);
    }

    public static Complex subtract(Complex complex, double d2) {
        return new Complex(complex.a - d2, complex.b);
    }

    public static Complex subtract(double d2, Complex complex) {
        return new Complex(d2 - complex.a, complex.b);
    }

    public static void subtract(Complex complex, Complex complex2, Complex[] complexArray) {
        complexArray[0].a = complex.a - complex2.a;
        complexArray[0].b = complex.b - complex2.b;
    }

    public static void subtract(Complex complex, double d2, Complex[] complexArray) {
        complexArray[0].a = complex.a - d2;
        complexArray[0].b = complex.b;
    }

    public static void subtract(double d2, Complex complex, Complex[] complexArray) {
        complexArray[0].a = d2 - complex.a;
        complexArray[0].b = complex.b;
    }

    public static Complex multiply(Complex complex, Complex complex2) {
        double d2 = complex.a;
        double d3 = complex.b;
        double d4 = complex2.a;
        double d5 = complex2.b;
        return new Complex(d2 * d4 - d3 * d5, d2 * d5 + d3 * d4);
    }

    public static Complex multiply(Complex complex, double d2) {
        return new Complex(complex.a * d2, complex.b * d2);
    }

    public Complex multiply_internalize(double d2) {
        this.a *= d2;
        this.b *= d2;
        return this;
    }

    public static void multiply(Complex complex, Complex complex2, Complex[] complexArray) {
        double d2 = complex.a;
        double d3 = complex.b;
        double d4 = complex2.a;
        double d5 = complex2.b;
        complexArray[0].a = d2 * d4 - d3 * d5;
        complexArray[0].b = d2 * d5 + d3 * d4;
    }

    public static void multiply(Complex complex, double d2, Complex[] complexArray) {
        complexArray[0].a = complex.a * d2;
        complexArray[0].b = complex.b * d2;
    }

    public static Complex divide(Complex complex, Complex complex2) {
        double d2 = complex.a;
        double d3 = complex.b;
        double d4 = complex2.a;
        double d5 = complex2.b;
        double d6 = d4 * d4 + d5 * d5;
        if (d6 == 0.0) {
            throw new DivideByZeroException("Can not divide by zero.");
        }
        double d7 = 1.0 / d6;
        return new Complex((d2 * d4 + d3 * d5) * d7, (d3 * d4 - d2 * d5) * d7);
    }

    public static Complex divide(Complex complex, double d2) {
        if (d2 == 0.0) {
            throw new DivideByZeroException("Can not divide by zero.");
        }
        return new Complex(complex.a / d2, complex.b / d2);
    }

    public static Complex divide(double d2, Complex complex) {
        if (complex.a == 0.0 || complex.b == 0.0) {
            throw new DivideByZeroException("Can not divide by zero.");
        }
        return new Complex(d2 / complex.a, d2 / complex.b);
    }

    public static void divide(Complex complex, Complex complex2, Complex[] complexArray) {
        double d2 = complex.a;
        double d3 = complex.b;
        double d4 = complex2.a;
        double d5 = complex2.b;
        double d6 = d4 * d4 + d5 * d5;
        if (d6 == 0.0) {
            throw new DivideByZeroException("Can not divide by zero.");
        }
        double d7 = 1.0 / d6;
        complexArray[0].a = (d2 * d4 + d3 * d5) * d7;
        complexArray[0].b = (d3 * d4 - d2 * d5) * d7;
    }

    public static void divide(Complex complex, double d2, Complex[] complexArray) {
        if (d2 == 0.0) {
            throw new DivideByZeroException("Can not divide by zero.");
        }
        complexArray[0].a = complex.a / d2;
        complexArray[0].b = complex.b / d2;
    }

    public static void divide(double d2, Complex complex, Complex[] complexArray) {
        if (complex.a == 0.0 || complex.b == 0.0) {
            throw new DivideByZeroException("Can not divide by zero.");
        }
        complexArray[0].a = d2 / complex.a;
        complexArray[0].b = d2 / complex.b;
    }

    public static Complex negate(Complex complex) {
        return new Complex(-complex.a, -complex.b);
    }

    public static boolean approxEqual(Complex complex, Complex complex2) {
        return Complex.approxEqual(complex, complex2, 8.881784197001252E-16);
    }

    public static boolean approxEqual(Complex complex, Complex complex2, double d2) {
        return bC.a(complex.a - complex2.a) <= d2 && bC.a(complex.b - complex2.b) <= d2;
    }

    public static Complex parse(String string) {
        Matcher matcher = Pattern.compile("\\((?<real>.*),(?<imaginary>.*)\\)", 32).matcher(string);
        if (!matcher.find()) {
            throw new FormatException("String representation of the complex number is not correctly formatted.");
        }
        return new Complex(aa.a(Matcher.quoteReplacement("${real}")), aa.a(Matcher.quoteReplacement("${imaginary}")));
    }

    public static boolean tryParse(String string, Complex[] complexArray) {
        try {
            Complex complex;
            complexArray[0] = complex = Complex.parse(string);
            return true;
        }
        catch (FormatException formatException) {
            complexArray[0] = new Complex();
            return false;
        }
    }

    public static Complex sqrt(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.a != 0.0 || complex.b != 0.0) {
            if (complex.b == 0.0) {
                double d2;
                if (complex.a > 0.0) {
                    double d3 = complex.a;
                    d2 = Math.sqrt(d3);
                } else {
                    double d4 = -complex.a;
                    d2 = Math.sqrt(d4);
                }
                complex2.a = d2;
                complex2.b = 0.0;
                return complex2;
            }
            double d5 = complex.getMagnitude();
            double d6 = 0.5 * (d5 + complex.a);
            complex2.a = Math.sqrt(d6);
            d6 = 0.5 * (d5 - complex.a);
            complex2.b = Math.sqrt(d6);
            if (complex.b < 0.0) {
                complex2.b = -complex2.b;
            }
        }
        return complex2;
    }

    public static Complex log(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.a > 0.0 && complex.b == 0.0) {
            double d2 = complex.a;
            complex2.a = Math.log(d2);
            complex2.b = 0.0;
            return complex2;
        }
        if (complex.a == 0.0) {
            if (complex.b > 0.0) {
                double d3 = complex.b;
                complex2.a = Math.log(d3);
                complex2.b = 1.5707963267948966;
                return complex2;
            }
            double d4 = -complex.b;
            complex2.a = Math.log(d4);
            complex2.b = -1.5707963267948966;
            return complex2;
        }
        double d5 = complex.getMagnitude();
        complex2.a = Math.log(d5);
        double d6 = complex.a;
        d5 = complex.b;
        complex2.b = Math.atan2(d5, d6);
        return complex2;
    }

    public static Complex exp(Complex complex) {
        Complex complex2 = ZERO.Clone();
        double d2 = complex.a;
        double d3 = Math.exp(d2);
        d2 = complex.b;
        complex2.a = d3 * Math.cos(d2);
        d2 = complex.b;
        complex2.b = d3 * Math.sin(d2);
        return complex2;
    }

    public static Complex sin(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.b == 0.0) {
            double d2 = complex.a;
            complex2.a = Math.sin(d2);
            complex2.b = 0.0;
            return complex2;
        }
        double d3 = complex.a;
        double d4 = Math.sin(d3);
        d3 = complex.b;
        complex2.a = d4 * Math.cosh(d3);
        d3 = complex.a;
        double d5 = Math.cos(d3);
        d3 = complex.b;
        complex2.b = d5 * Math.sinh(d3);
        return complex2;
    }

    public static Complex cos(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.b == 0.0) {
            double d2 = complex.a;
            complex2.a = Math.cos(d2);
            complex2.b = 0.0;
            return complex2;
        }
        double d3 = complex.a;
        double d4 = Math.cos(d3);
        d3 = complex.b;
        complex2.a = d4 * Math.cosh(d3);
        d3 = complex.a;
        double d5 = -Math.sin(d3);
        d3 = complex.b;
        complex2.b = d5 * Math.sinh(d3);
        return complex2;
    }

    public static Complex tan(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.b == 0.0) {
            double d2 = complex.a;
            complex2.a = Math.tan(d2);
            complex2.b = 0.0;
            return complex2;
        }
        double d3 = 2.0 * complex.a;
        double d4 = 2.0 * complex.b;
        double d5 = d3;
        double d6 = Math.cos(d5);
        d5 = d3;
        double d7 = d6 + Math.cosh(d5);
        d5 = d3;
        complex2.a = Math.sin(d5) / d7;
        d5 = d4;
        complex2.b = Math.sinh(d5) / d7;
        return complex2;
    }

    public static boolean isEquals(Complex complex, Complex complex2) {
        return complex.equals(complex2);
    }

    public final double getRe() {
        return this.a;
    }

    public final void setRe(double d2) {
        this.a = d2;
    }

    public final double getIm() {
        return this.b;
    }

    public final void setIm(double d2) {
        this.b = d2;
    }

    public final Complex set(double d2, double d3) {
        this.a = d2;
        this.b = d3;
        return this;
    }

    public final double getMagnitude() {
        double d2 = this.a * this.a + this.b * this.b;
        return Math.sqrt(d2);
    }

    public final double getPhase() {
        double d2 = this.a;
        double d3 = this.b;
        return Math.atan2(d3, d2);
    }

    public final double getSquaredMagnitude() {
        return this.a * this.a + this.b * this.b;
    }

    public int hashCode() {
        return aa.a(this.a) ^ aa.a(this.b);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)object;
        return this.a == complex.a && this.b == complex.b;
    }

    public String toString() {
        return aV.a("({0}, {1})", this.a, this.b);
    }

    public final Complex deepClone() {
        return new Complex(this);
    }

    @Override
    public void CloneTo(Complex complex) {
        complex.a = this.a;
        complex.b = this.b;
    }

    @Override
    public Complex Clone() {
        Complex complex = new Complex();
        this.CloneTo(complex);
        return complex;
    }
}

