/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.imagefilters.convolution;

import com.aspose.imaging.imagefilters.complexutils.Complex;
import com.aspose.imaging.imagefilters.convolution.a;
import com.aspose.imaging.imagefilters.convolution.b;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.aZ.b;
import com.aspose.imaging.internal.mh.bC;
import com.aspose.imaging.internal.mh.g;
import com.aspose.imaging.internal.rj.d;

public final class ConvolutionFilter {
    public static final int a = 3;
    public static final int b = 99;
    public static final double c = 0.001;

    private ConvolutionFilter() {
    }

    public static double[][] getSharpen3x3() {
        return new double[][]{{0.0, -1.0, 0.0}, {-1.0, 5.0, -1.0}, {0.0, -1.0, 0.0}};
    }

    public static double[][] getSharpen5x5() {
        return new double[][]{{-1.0, -1.0, -1.0, -1.0, -1.0}, {-1.0, 2.0, 2.0, 2.0, -1.0}, {-1.0, 2.0, 8.0, 2.0, 1.0}, {-1.0, 2.0, 2.0, 2.0, -1.0}, {-1.0, -1.0, -1.0, -1.0, -1.0}};
    }

    public static double[][] getEmboss3x3() {
        return new double[][]{{-2.0, -1.0, 0.0}, {-1.0, 1.0, 1.0}, {0.0, 1.0, 2.0}};
    }

    public static double[][] getEmboss5x5() {
        return new double[][]{{-2.0, -1.0, 0.0, 1.0, 2.0}, {-1.0, -1.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, -1.0, -1.0}, {2.0, 1.0, 0.0, -1.0, -2.0}};
    }

    public static double[][] getBlurMotion(int n2, double d2) {
        double d3;
        double[][] dArray = new double[n2][n2];
        double d4 = d3 = d2 * Math.PI / 180.0;
        double d5 = Math.cos(d4);
        d4 = d3;
        double d6 = Math.sin(d4);
        double d7 = ((double)n2 - 1.0) / 2.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                double d8 = (double)i2 - d7;
                double d9 = (double)i3 - d7;
                double d10 = d8 * d5 - d9 * d6;
                double d11 = d8 * d6 + d9 * d5;
                double d12 = 0.0;
                if (bC.a(d11) <= bC.a(d10)) {
                    d12 = 1.0f / (float)n2;
                }
                dArray[i2][i3] = d12;
            }
        }
        return dArray;
    }

    public static double[][] getGaussian(int n2, double d2) {
        n2 = ConvolutionFilter.a(n2);
        d2 = bC.c(0.001, d2);
        int n3 = n2 / 2;
        double[][] dArray = new double[n2][n2];
        double[] dArray2 = new double[]{0.0};
        for (int i2 = -n3; i2 <= n3; ++i2) {
            for (int i3 = -n3; i3 <= n3; ++i3) {
                double d3;
                double d4;
                double d5 = d4 = (double)(-(i3 * i3 + i2 * i2)) / (2.0 * d2 * d2);
                dArray[i2 + n3][i3 + n3] = d3 = Math.exp(d5) / (Math.PI * 2 * d2 * d2);
                dArray2[0] = dArray2[0] + d3;
            }
        }
        ConvolutionFilter.a(dArray, new a(dArray2));
        return dArray;
    }

    public static double[][] getBlurBox(int n2) {
        n2 = ConvolutionFilter.a(n2);
        double[][] dArray = new double[n2][n2];
        double d2 = 1.0 / (double)(n2 * n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray[i2][i3] = d2;
            }
        }
        return dArray;
    }

    public static Complex[][] toComplex(double[][] dArray) {
        if (dArray == null) {
            throw new ArgumentNullException("kernel");
        }
        int n2 = dArray.length;
        int n3 = dArray[1].length;
        Complex[][] complexArray = (Complex[][])g.a(g.a(d.a(Complex.class), n2, n3));
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                complexArray[i2][i3].setRe(dArray[i2][i3]);
            }
        }
        return complexArray;
    }

    public static double[][] a(int n2, double d2) {
        int n3;
        n2 = ConvolutionFilter.a(n2);
        if (d2 <= 0.0) {
            d2 = bC.c(0.5, d2);
        }
        double[][] dArray = ConvolutionFilter.getGaussian(n2, d2);
        double d3 = dArray[0][0];
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                double d4 = dArray[n3][i2] / d3;
                if (d4 > 65535.0) {
                    d4 = 65535.0;
                }
                dArray[n3][i2] = d.e(d4);
                n4 += d.e(dArray[n3][i2]);
            }
        }
        n3 = n2 / 2;
        int[] nArray = new int[]{0};
        for (int i3 = 0; i3 < n2; ++i3) {
            for (int i4 = 0; i4 < n2; ++i4) {
                dArray[i3][i4] = i3 == n3 && i4 == n3 ? (double)(2 * n4) - dArray[i3][i4] : -dArray[i3][i4];
                nArray[0] = nArray[0] + d.e(dArray[i3][i4]);
            }
        }
        ConvolutionFilter.a(dArray, new b(nArray));
        return dArray;
    }

    public static Complex[][] b(int n2, double d2) {
        double[][] dArray;
        if (n2 == 0) {
            n2 = 5;
            dArray = ConvolutionFilter.getGaussian(n2, 1.0);
        } else {
            dArray = ConvolutionFilter.getGaussian(n2, d2);
        }
        Complex[][] complexArray = (Complex[][])g.a(g.a(d.a(Complex.class), n2, n2));
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                complexArray[i3][i2].setRe(dArray[i3][i2]);
            }
        }
        return complexArray;
    }

    public static Complex[][] a(int n2, double d2, double d3) {
        int n3;
        int n4;
        double d4;
        int n5 = n2;
        double d5 = d2;
        double d6 = d4 = Math.PI * d3 / 180.0;
        double d7 = Math.sin(d6);
        d6 = d4;
        double d8 = Math.cos(d6);
        double d9 = ((double)(n5 - 1) - d8 * (double)(n5 - 1)) / 2.0;
        double d10 = ((double)(n5 - 1) - d7 * (double)(n5 - 1)) / 2.0;
        double d11 = 1.0 / (2.0 * d5 * d5 * Math.PI);
        double d12 = 0.0;
        Complex[][] complexArray = (Complex[][])g.a(g.a(d.a(Complex.class), n5, n5));
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = n5 - n4;
            int n6 = d.e(bC.d(d8 * (double)n4 + d9));
            int n7 = d.e(bC.d(d7 * (double)n4 + d10));
            d6 = d11 * (double)(n3 * n3);
            complexArray[n6][n7] = new Complex(Math.exp(d6), 0.0);
            d12 += complexArray[n6][n7].getRe();
        }
        if (d12 == 0.0) {
            d12 = 1.0;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                Complex.op_Division(complexArray[n3][n4], d12).CloneTo(complexArray[n3][n4]);
            }
        }
        return complexArray;
    }

    public static int a(int n2) {
        int n3 = 3;
        int n4 = n2;
        return bC.d(bC.b(n3, n4 % 2 == 0 ? n4 + 1 : n4), 99);
    }

    public static int a(int n2, int n3) {
        return bC.d(bC.b(n3, n2 % 2 == 0 ? n2 + 1 : n2), 99);
    }

    public static void a(double[][] dArray, b.b<Double, Double> b2) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            for (int i3 = 0; i3 < dArray[0].length; ++i3) {
                dArray[i2][i3] = b2.a(dArray[i2][i3]);
            }
        }
    }

    public static <T> void a(T[][] TArray, com.aspose.imaging.internal.mh.a<T> a2) {
        for (T[] TArray2 : TArray) {
            for (int i2 = 0; i2 < TArray[1].length; ++i2) {
                a2.a(TArray2[i2]);
            }
        }
    }
}

