/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.shapes;

import com.aspose.imaging.Matrix;
import com.aspose.imaging.Pen;
import com.aspose.imaging.PointF;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.ShapeSegment;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.aN.bj;
import com.aspose.imaging.internal.mh.aV;
import com.aspose.imaging.internal.mh.au;
import com.aspose.imaging.shapes.PolygonShape;
import com.aspose.imaging.shapesegments.BezierSegment;
import com.aspose.imaging.shapesegments.LineSegment;
import com.aspose.imaging.system.SerializableAttribute;
import com.aspose.imaging.system.collections.Generic.List;

@SerializableAttribute
public final class BezierShape
extends PolygonShape {
    public BezierShape() {
    }

    public BezierShape(PointF[] pointFArray) {
        super(pointFArray);
    }

    public BezierShape(PointF[] pointFArray, boolean bl2) {
        super(pointFArray, bl2);
    }

    @Override
    public RectangleF getBounds() {
        PointF[] pointFArray = this.getPoints();
        if (pointFArray == null || pointFArray.length == 0) {
            return RectangleF.getEmpty();
        }
        PointF[] pointFArray2 = pointFArray;
        if ((pointFArray2.length - 2) % 3 != 0) {
            throw new ArgumentException(aV.a(new String[]{"The number of points is not correct, count= ", au.b(pointFArray2.length), " The count MUST be one more than three times the number of curves to be drawn, because each Bezier curve requires two control points and an endpoint, and the initial curve requires an additional starting point."}));
        }
        int n2 = (pointFArray2.length - 1) / 3;
        List<PointF> list = new List<PointF>();
        PointF pointF = pointFArray2[0];
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            PointF pointF2 = pointFArray2[n3++];
            PointF pointF3 = pointFArray2[n3++];
            PointF pointF4 = pointFArray2[n3++];
            double d2 = BezierShape.a(pointF, pointF2) + BezierShape.a(pointF2, pointF3) + BezierShape.a(pointF3, pointF4);
            double d3 = d2 < 100.0 ? 0.1 : 0.01;
            double d4 = 1.0 + d3;
            for (double d5 = 0.0; d5 < d4; d5 += d3) {
                PointF pointF5 = pointF4;
                PointF pointF6 = pointF3;
                PointF pointF7 = pointF2;
                PointF pointF8 = pointF;
                double d6 = d5;
                PointF pointF9 = new PointF();
                double d7 = d6 * d6 * d6;
                double d8 = d6 * d6;
                double d9 = 1.0 - d6;
                double d10 = d9 * d9 * d9;
                double d11 = d9 * d9;
                pointF9.setX((float)(d10 * (double)pointF8.getX() + 3.0 * d11 * d6 * (double)pointF7.getX() + 3.0 * d9 * d8 * (double)pointF6.getX() + d7 * (double)pointF5.getX()));
                pointF9.setY((float)(d10 * (double)pointF8.getY() + 3.0 * d11 * d6 * (double)pointF7.getY() + 3.0 * d9 * d8 * (double)pointF6.getY() + d7 * (double)pointF5.getY()));
                list.addItem(pointF9);
            }
            pointF = pointF4;
        }
        PointF[] pointFArray3 = list.toArray(new PointF[0]);
        return bj.b(pointFArray3);
    }

    @Override
    public PointF getCenter() {
        throw new NotImplementedException();
    }

    @Override
    public ShapeSegment[] getSegments() {
        ShapeSegment[] shapeSegmentArray;
        PointF[] pointFArray = this.getPoints();
        if (pointFArray.length > 3) {
            int n2 = (pointFArray.length - 1) / 3;
            int n3 = n2 * 3;
            if (this.isClosed() && PointF.op_Inequality(pointFArray[n3], pointFArray[0])) {
                shapeSegmentArray = new ShapeSegment[n2 + 1];
                shapeSegmentArray[n2] = new LineSegment(pointFArray[n3], pointFArray[0]);
            } else {
                shapeSegmentArray = new ShapeSegment[n2];
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                shapeSegmentArray[i2] = new BezierSegment(pointFArray[i2 * 3], pointFArray[i2 * 3 + 1], pointFArray[i2 * 3 + 2], pointFArray[i2 * 3 + 3]);
            }
        } else {
            shapeSegmentArray = new ShapeSegment[]{};
        }
        return shapeSegmentArray;
    }

    @Override
    public boolean hasSegments() {
        return this.getPoints().length > 3;
    }

    @Override
    public PointF getEndPoint() {
        PointF[] pointFArray = this.getPoints();
        if (pointFArray.length > 0) {
            int n2 = (pointFArray.length - 1) / 3 * 3;
            return pointFArray[n2];
        }
        return PointF.getEmpty();
    }

    @Override
    public RectangleF getBounds(Matrix matrix) {
        throw new NotImplementedException();
    }

    @Override
    public RectangleF getBounds(Matrix matrix, Pen pen) {
        throw new NotImplementedException();
    }

    public static PointF a(double d2, PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
        PointF pointF5 = new PointF();
        double d3 = d2 * d2 * d2;
        double d4 = d2 * d2;
        double d5 = 1.0 - d2;
        double d6 = d5 * d5 * d5;
        double d7 = d5 * d5;
        pointF5.setX((float)(d6 * (double)pointF.getX() + 3.0 * d7 * d2 * (double)pointF2.getX() + 3.0 * d5 * d4 * (double)pointF3.getX() + d3 * (double)pointF4.getX()));
        pointF5.setY((float)(d6 * (double)pointF.getY() + 3.0 * d7 * d2 * (double)pointF2.getY() + 3.0 * d5 * d4 * (double)pointF3.getY() + d3 * (double)pointF4.getY()));
        return pointF5;
    }

    public static PointF[] a(PointF[] pointFArray) {
        if ((pointFArray.length - 2) % 3 != 0) {
            throw new ArgumentException(aV.a(new String[]{"The number of points is not correct, count= ", au.b(pointFArray.length), " The count MUST be one more than three times the number of curves to be drawn, because each Bezier curve requires two control points and an endpoint, and the initial curve requires an additional starting point."}));
        }
        int n2 = (pointFArray.length - 1) / 3;
        List<PointF> list = new List<PointF>();
        PointF pointF = pointFArray[0];
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            PointF pointF2 = pointFArray[n3++];
            PointF pointF3 = pointFArray[n3++];
            PointF pointF4 = pointFArray[n3++];
            double d2 = BezierShape.a(pointF, pointF2) + BezierShape.a(pointF2, pointF3) + BezierShape.a(pointF3, pointF4);
            double d3 = d2 < 100.0 ? 0.1 : 0.01;
            double d4 = 1.0 + d3;
            for (double d5 = 0.0; d5 < d4; d5 += d3) {
                PointF pointF5 = pointF4;
                PointF pointF6 = pointF3;
                PointF pointF7 = pointF2;
                PointF pointF8 = pointF;
                double d6 = d5;
                PointF pointF9 = new PointF();
                double d7 = d6 * d6 * d6;
                double d8 = d6 * d6;
                double d9 = 1.0 - d6;
                double d10 = d9 * d9 * d9;
                double d11 = d9 * d9;
                pointF9.setX((float)(d10 * (double)pointF8.getX() + 3.0 * d11 * d6 * (double)pointF7.getX() + 3.0 * d9 * d8 * (double)pointF6.getX() + d7 * (double)pointF5.getX()));
                pointF9.setY((float)(d10 * (double)pointF8.getY() + 3.0 * d11 * d6 * (double)pointF7.getY() + 3.0 * d9 * d8 * (double)pointF6.getY() + d7 * (double)pointF5.getY()));
                list.addItem(pointF9);
            }
            pointF = pointF4;
        }
        return list.toArray(new PointF[0]);
    }

    private static double a(PointF pointF, PointF pointF2) {
        double d2 = pointF2.getX() - pointF.getX();
        double d3 = pointF2.getY() - pointF.getY();
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BezierShape)) {
            return false;
        }
        BezierShape bezierShape = (BezierShape)object;
        return super.equals(bezierShape);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

