/*
 * Decompiled with CFR 0.152.
 */
package asposewobfuscated;

import asposewobfuscated.zz8F;
import asposewobfuscated.zz9N;
import java.io.IOException;

public class zz8H
extends zz8F {
    private byte[] zzez;
    private int zzey;
    private int _position;
    private int _length;
    private int _capacity;
    private boolean zzex;
    private boolean zzew;
    private boolean zzev;
    private boolean zzeu;

    public zz8H() {
        this(0);
    }

    public zz8H(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity");
        }
        this.zzez = new byte[n];
        this._capacity = n;
        this.zzex = true;
        this.zzew = true;
        this.zzev = true;
        this.zzey = 0;
        this.zzeu = true;
    }

    public zz8H(byte[] byArray) {
        this(byArray, true);
    }

    private zz8H(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        this.zzez = byArray;
        this._length = this._capacity = byArray.length;
        this.zzew = true;
        this.zzev = false;
        this.zzey = 0;
        this.zzeu = true;
    }

    public zz8H(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true, false);
    }

    private zz8H(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        if (n < 0) {
            throw new IllegalArgumentException("index");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("count");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("The buffer length minus index is less than count.");
        }
        this.zzez = byArray;
        this.zzey = this._position = n;
        this._length = this._capacity = n + n2;
        this.zzew = true;
        this.zzev = false;
        this.zzex = false;
        this.zzeu = true;
    }

    @Override
    public final boolean zzVW() {
        return this.zzeu;
    }

    @Override
    public final boolean canWrite() {
        return this.zzew;
    }

    @Override
    public final void dispose() throws IOException {
        this.close();
    }

    @Override
    public final void close() throws IOException {
        this.zzeu = false;
        this.zzew = false;
        this.zzex = false;
    }

    public final void zzCO() throws IOException {
        this.zzeu = true;
        this.zzew = true;
        this.zzex = true;
    }

    @Override
    public void flush() throws Exception {
    }

    private boolean zzUX(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("value");
        }
        if (n > this._capacity) {
            int n2 = n;
            if (n2 < 256) {
                n2 = 256;
            }
            if (n2 < this._capacity << 1) {
                n2 = this._capacity << 1;
            }
            int n3 = n2;
            zz8H zz8H2 = this;
            if (!zz8H2.zzeu) {
                zz8H.zzCN();
            }
            if (n3 != zz8H2._capacity) {
                if (!zz8H2.zzex) {
                    throw new UnsupportedOperationException("This stream is not expandable.");
                }
                if (n3 < zz8H2._length) {
                    throw new IllegalArgumentException("capacity");
                }
                if (n3 > 0) {
                    byte[] byArray = new byte[n3];
                    if (zz8H2._length > 0) {
                        System.arraycopy(zz8H2.zzez, 0, byArray, 0, zz8H2._length);
                    }
                    zz8H2.zzez = byArray;
                } else {
                    zz8H2.zzez = null;
                }
                zz8H2._capacity = n3;
            }
            return true;
        }
        return false;
    }

    public final byte[] getBuffer() {
        if (!this.zzev) {
            throw new UnsupportedOperationException("UnauthorizedAccess_MemStreamBuffer");
        }
        return this.zzez;
    }

    @Override
    public final long getLength() throws IOException {
        if (!this.zzeu) {
            zz8H.zzCN();
        }
        return this._length - this.zzey;
    }

    @Override
    public final long getPosition() throws IOException {
        if (!this.zzeu) {
            zz8H.zzCN();
        }
        return this._position - this.zzey;
    }

    @Override
    public final void zzq(long l) throws IOException {
        if (!this.zzeu) {
            zz8H.zzCN();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("length = " + l);
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("length = " + l);
        }
        this._position = this.zzey + (int)l;
    }

    @Override
    public final long zzY(long l, int n) throws IOException {
        switch (n) {
            case 0: {
                this.zzq(l);
                break;
            }
            case 1: {
                this.zzq(this.getPosition() + l);
                break;
            }
            case 2: {
                this.zzq(this.getLength() + l);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SeekOrigin type.");
            }
        }
        assert (this._position >= 0);
        return this._position;
    }

    @Override
    public final int read(byte[] buffer, int offset, int count) throws IOException {
        if (!this.zzeu) {
            zz8H.zzCN();
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (buffer.length - offset < count) {
            throw new IllegalArgumentException("The buffer length minus index is less than count.");
        }
        int n = this._length - this._position;
        if (n > count) {
            n = count;
        }
        if (n <= 0) {
            return 0;
        }
        assert (this._position + n >= 0) : "_position + n >= 0";
        if (n <= 8) {
            int n2 = n;
            while (--n2 >= 0) {
                buffer[offset + n2] = this.zzez[this._position + n2];
            }
        } else {
            System.arraycopy(this.zzez, this._position, buffer, offset, n);
        }
        this._position += n;
        return n;
    }

    @Override
    public final int zzVX() throws IOException {
        if (!this.zzeu) {
            zz8H.zzCN();
        }
        if (this._position >= this._length) {
            return -1;
        }
        return this.zzez[this._position++] & 0xFF;
    }

    @Override
    public final void setLength(long value) throws IOException {
        if (!this.zzew) {
            zz8H.zzCM();
        }
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value");
        }
        if (value < 0L || value > (long)(Integer.MAX_VALUE - this.zzey)) {
            throw new IllegalArgumentException("value");
        }
        int n = this.zzey + (int)value;
        boolean bl = this.zzUX(n);
        if (!bl && n > this._length) {
            zz9N.fill(this.zzez, this._length, n - this._length, (byte)0);
        }
        this._length = n;
        if (this._position > n) {
            this._position = n;
        }
    }

    public final byte[] toArray() {
        byte[] byArray = new byte[this._length - this.zzey];
        System.arraycopy(this.zzez, this.zzey, byArray, 0, this._length - this.zzey);
        return byArray;
    }

    @Override
    public final void write(byte[] buffer, int offset, int count) throws IOException {
        int n;
        if (!this.zzeu) {
            zz8H.zzCN();
        }
        if (!this.zzew) {
            zz8H.zzCM();
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (buffer.length - offset < count) {
            throw new IllegalArgumentException("Argument_InvalidOffLen");
        }
        int n2 = this._position + count;
        if (n2 < 0) {
            throw new IOException("StreamTooLong");
        }
        if (n2 > this._length) {
            boolean bl;
            int n3 = n = this._position > this._length ? 1 : 0;
            if (n2 > this._capacity && (bl = this.zzUX(n2))) {
                n = 0;
            }
            if (n != 0) {
                zz9N.fill(this.zzez, this._length, n2 - this._length, (byte)0);
            }
            this._length = n2;
        }
        if (count <= 8) {
            n = count;
            while (--n >= 0) {
                this.zzez[this._position + n] = buffer[offset + n];
            }
        } else {
            System.arraycopy(buffer, offset, this.zzez, this._position, count);
        }
        this._position = n2;
    }

    @Override
    public final void writeByte(byte value) throws IOException {
        if (!this.zzeu) {
            zz8H.zzCN();
        }
        if (!this.zzew) {
            zz8H.zzCM();
        }
        if (this._position >= this._length) {
            boolean bl;
            boolean bl2;
            int n = this._position + 1;
            boolean bl3 = bl2 = this._position > this._length;
            if (n >= this._capacity && (bl = this.zzUX(n))) {
                bl2 = false;
            }
            if (bl2) {
                zz9N.zzN(this.zzez, this._length, this._position - this._length);
            }
            this._length = n;
        }
        this.zzez[this._position++] = value;
    }

    public final void zzg(zz8F zz8F2) throws Exception {
        if (!this.zzeu) {
            zz8H.zzCN();
        }
        if (zz8F2 == null) {
            throw new IllegalArgumentException("stream");
        }
        zz8F2.write(this.zzez, this.zzey, this._length - this.zzey);
    }

    private static void zzCN() throws IOException {
        throw new IOException("The stream is closed.");
    }

    private static void zzCM() {
        throw new UnsupportedOperationException("The stream does not support write operations.");
    }

    public String toString() {
        int n = this._length;
        int n2 = this.zzey;
        byte[] byArray = this.zzez;
        StringBuilder stringBuilder = new StringBuilder();
        n -= n2;
        int n3 = 16;
        for (int i = n2; i < n; i += 16) {
            if (i + n3 > n) {
                n3 = n - i;
            }
            stringBuilder.append(zz9N.zzW(byArray, i, n3)).append(" | ").append(zz9N.zzL(byArray, i, n3)).append("\n");
        }
        return stringBuilder.toString();
    }
}

