/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz9M;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.zz9F;
import com.aspose.words.zzAI;
import com.aspose.words.zzC0;
import com.aspose.words.zzCK;
import com.aspose.words.zzI2;
import com.aspose.words.zzIN;
import com.aspose.words.zzIQ;
import com.aspose.words.zzJI;
import com.aspose.words.zzLB;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable {
    private zzLB zzZXl;

    ChartSeriesCollection(zzLB dmlChart) {
        this.zzZXl = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return (ChartSeries)chartSeriesCollection.zzZXl.zzlK().get(index);
    }

    public Iterator iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZXl.zzlK().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZXl.zzlK().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZXl.zzlK().clear();
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, values);
        chartSeries.zzuK().zzZ(ChartSeriesCollection.zzS(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzuK().zzZ(ChartSeriesCollection.zzY(xValues));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        double[] dArray = values;
        zz9M[] zz9MArray = zz9M.zzZ(dates);
        String string = seriesName;
        ChartSeriesCollection chartSeriesCollection = this;
        if (zz9MArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zz9MArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zz9MArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = chartSeriesCollection.zzZ(string, dArray);
        chartSeries.zzuK().zzZ(ChartSeriesCollection.zzZ(zz9MArray));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZXl.zzmK() != 15) {
            this.zzZXl.zzU(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzuQ().zzuZ().zzN(3, this.zzZXl.zzlH());
        chartSeries.zzuK().zzZ(ChartSeriesCollection.zzY(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzuG().zzZ(ChartSeriesCollection.zzY(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzZ(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZXl);
        chartSeries.setName(string);
        ChartSeries chartSeries2 = chartSeries;
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeries2.zzuQ().zzuZ().zzN(5, new zzIQ());
        switch (chartSeriesCollection.zzZXl.zzmK()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZ(chartSeries2, 5);
                break;
            }
            case 4: {
                ChartSeriesCollection.zzZ(chartSeries2, 5);
                ChartSeriesCollection.zzX(chartSeries2);
                break;
            }
            case 6: {
                ChartSeriesCollection.zzZ(chartSeries2, 1);
                ChartSeriesCollection.zzX(chartSeries2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeries chartSeries3 = chartSeries2;
                zzIQ zzIQ2 = new zzIQ();
                zzIQ2.zzZ(new zzC0());
                zzAI zzAI2 = new zzAI();
                zzAI2.setValue(1);
                zzIQ2.zzol().zzZ(new zz9F(zzAI2));
                zzIQ2.zzol().zzYW(19050.0);
                chartSeries3.zzuQ().zzuZ().zzN(5, zzIQ2);
            }
        }
        chartSeries.setIndex(this.zzZXl.zzlK().size());
        chartSeries.zzT6(chartSeries.getIndex());
        chartSeries.zzuI().zzZ(ChartSeriesCollection.zzY(dArray));
        chartSeries.zzuJ().zzZ(chartSeries.zzuI().zzkP());
        this.zzZXl.zzW(chartSeries);
        return chartSeries;
    }

    private static void zzX(ChartSeries chartSeries) {
        zzIQ zzIQ2 = new zzIQ();
        zzIQ2.zzZ(new zzC0());
        zzIQ2.zzol().zzZ(new zzCK());
        zzIQ2.zzol().setEndCap(0);
        zzIQ2.zzol().zzYW(19050.0);
        chartSeries.zzuQ().zzuZ().zzN(5, zzIQ2);
    }

    private static void zzZ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzuS().zzN(0, n);
        chartSeries.zzuQ().zzuZ().zzN(4, chartMarker);
    }

    private static zzI2 zzY(double[] dArray) {
        int n = 0;
        zzI2 zzI22 = new zzI2(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzI22.zzX(new zzJI(n, d, "General"));
            }
            ++n;
        }
        zzI22.zzR4(dArray.length);
        zzI22.zzgi();
        return zzI22;
    }

    private static zzI2 zzZ(zz9M[] zz9MArray) {
        int n = 0;
        zzI2 zzI22 = new zzI2(2, false);
        zz9M[] zz9MArray2 = zz9MArray;
        int n2 = zz9MArray.length;
        for (int i = 0; i < n2; ++i) {
            zz9M zz9M2 = zz9MArray2[i];
            zzI22.zzX(new zzJI(n++, zz9M2.zzE5(), "m/d/yyyy"));
        }
        zzI22.zzR4(zz9MArray.length);
        zzI22.zzgi();
        return zzI22;
    }

    private static zzI2 zzS(String[] stringArray) {
        int n = 0;
        zzI2 zzI22 = new zzI2(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzI22.zzX(new zzIN(n++, string));
        }
        zzI22.zzR4(stringArray.length);
        zzI22.zzgi();
        return zzI22;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZXl.zzlK().size();
    }
}

