/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz3M;
import asposewobfuscated.zz8F;
import asposewobfuscated.zz8G;
import asposewobfuscated.zz8H;
import asposewobfuscated.zz8N;
import asposewobfuscated.zz9O;
import asposewobfuscated.zzBF;
import asposewobfuscated.zzBG;
import asposewobfuscated.zzCR;
import asposewobfuscated.zzE3;
import asposewobfuscated.zzYC;
import asposewobfuscated.zzYO;
import asposewobfuscated.zzYP;
import asposewobfuscated.zzZ;
import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.zz1F;
import com.aspose.words.zz1K;
import com.aspose.words.zz6;
import com.aspose.words.zz77;
import com.aspose.words.zzBI;
import com.aspose.words.zzC6;
import com.aspose.words.zzCC;
import com.aspose.words.zzEH;
import com.aspose.words.zzHR;
import com.aspose.words.zzLP;
import com.aspose.words.zzX;
import com.aspose.words.zzYH;
import com.aspose.words.zzYOW;
import com.aspose.words.zzYRF;
import com.aspose.words.zzYTS;
import com.aspose.words.zzYU3;
import com.aspose.words.zzYUQ;
import com.aspose.words.zzYYK;
import com.aspose.words.zzYZS;
import com.aspose.words.zzZ6N;
import com.aspose.words.zzZ7I;
import com.aspose.words.zzZ7M;
import com.aspose.words.zzZGD;
import com.aspose.words.zzZJ;
import com.aspose.words.zzZND;
import com.aspose.words.zzZNG;
import com.aspose.words.zzZOA;
import com.aspose.words.zzZOM;
import com.aspose.words.zzZQB;
import com.aspose.words.zzZQD;
import com.aspose.words.zzZSU;
import com.aspose.words.zzZTF;
import com.aspose.words.zzZUX;
import com.aspose.words.zzZY1;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Iterator;

public class DocumentBuilder
implements zzZND,
zzZNG,
zzZQD {
    private Document zzZru;
    private Node zzZpY;
    private Node zzZpX;
    private zzYZS zzZpW;
    private Font zzZpV;
    private zz9O zzZpU;
    private zzYTS zzZpT = zzYTS.zzZeQ();
    private zzYH zzZYh = new zzYH();
    private RowFormat zzZpS;
    private CellFormat zzZYg;
    private zz9O zzZpR;
    private int zzZpQ = 0;
    private int zzZpP = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzP(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzP(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzP(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        this.zzZ(this.getCurrentSection(), zzYOW.zzyj(headerFooterType), 0, 0);
    }

    private void zzP(int n, int n2, int n3, int n4) {
        this.zzZru.ensureMinimum();
        Section section = (Section)this.zzZru.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.zzZ(section, 1, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYOW.zzyi(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZru, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZru));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.zzY(paragraph, n2);
    }

    final void zzY(Paragraph paragraph, int n) {
        if (n == 0) {
            this.zzZ(paragraph, paragraph.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzZ(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zz5b().isRemoved() ? zzZGD.zzT(this.zzZru, fieldName) : zzZGD.zzS(this.zz5b(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZOM zzZOM2 = field.getFormat().zzZY8();
        Inline inline = zzZOM2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zzZY9(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZJ.zzX(this.zzZru, bookmarkName) : zzZJ.zzW(this.zzZru, bookmarkName);
        if (node == null) {
            return false;
        }
        this.zzZ((Paragraph)node.zzZCQ(), isAfter ? node.getNextSibling() : node);
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        this.zzZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.zzZ1(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzY(cell.getFirstParagraph(), 0);
            return;
        }
        if (characterIndex == -1) {
            this.zzY(cell.getLastParagraph(), -1);
        }
    }

    private void zzZ(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || zzX.zzM(node)) {
            this.zzf(node);
        } else if (zzX.zzP(node)) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzf(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zz5m();
            return;
        }
        if (!this.zz5n()) {
            this.zz5m();
        }
    }

    private boolean zz5n() {
        Node node = this.zz5b();
        if (!(node instanceof zzZOA)) {
            while (node != null && !(node instanceof zzZOA)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zz5b(); node != null && !(node instanceof zzZOA); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            zzZOA zzZOA2 = (zzZOA)((Object)node);
            this.zzZ(zzZOA2.getRunPr_IInline(), true);
            return true;
        }
        return false;
    }

    private void zz5m() {
        this.zzZ(this.getCurrentParagraph().zzZuT(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZ1(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zz5e() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz5b().zzZk(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZCM();
                this.zzY(paragraph, 0);
            }
        }
        row.remove();
        if (!table.zzt1()) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzJ(text, false);
    }

    public void writeln(String text) {
        this.zzJ(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYUQ zzYUQ2 = new zzYUQ(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZru, this.zz5j(), this.zz5k());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zz5b(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYUQ2.dispose();
        }
        if (this.getDocument().zz5L()) {
            zzX.zzX(paragraph, this.getDocument().zz5Q());
        }
        return this.getCurrentParagraph();
    }

    public void insertBreak(int breakType) {
        this.zzp(breakType, true);
    }

    final void zzp(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzXy(bl)) {
                    this.zzSy(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzXy(bl)) {
                    this.zzSy(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzXy(bl)) {
                    this.zzNV(1);
                }
                return;
            }
            case 5: {
                if (this.zzXy(bl)) {
                    this.zzNV(2);
                }
                return;
            }
            case 3: {
                if (this.zzXy(bl)) {
                    this.zzNV(0);
                }
                return;
            }
            case 6: {
                if (this.zzXy(bl)) {
                    this.zzNV(3);
                }
                return;
            }
            case 7: {
                if (this.zzXy(bl)) {
                    this.zzNV(4);
                }
                return;
            }
            case 8: {
                this.zzSy(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzE3.zzYN(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zz3M.format("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzX.zzZ(fieldType, updateField, this.zz5k(), this.zz5b(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzX.zzZ(fieldCode, this.zz5k(), this.zz5b(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzX.zzZ(fieldCode, fieldValue, this.zz5k(), this.zz5b(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZ.zzZ((Object)displayText, "displayText");
        zzZ.zzZ((Object)urlOrBookmark, "hrefOrBookmark");
        zz1K zz1K2 = this.zzZ(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zz1K2.zzY(documentBuilder.zzo(88, true));
        return zzX.zzZ(zz1K2.getStart(), zz1K2.getSeparator(), zz1K2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.zzNU(70);
        if (zzE3.zzYN(name)) {
            this.startBookmark(name);
        }
        this.zzSx(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzNT(70);
        String string = zzE3.zzYN(fieldValue) ? fieldValue : FormField.zzZ7U;
        Run run = new Run(this.zzZru, string, this.zz5k());
        this.insertNode(run);
        this.zzo(70, true);
        if (zzE3.zzYN(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzg(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        return this.insertCheckBox(name, checkedValue, checkedValue, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.zzNU(71);
        if (zzE3.zzYN(name)) {
            this.startBookmark(name);
        }
        this.zzSx(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzo(71, false);
        if (zzE3.zzYN(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzg(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.zzNU(83);
        if (zzE3.zzYN(name)) {
            this.startBookmark(name);
        }
        this.zzSx(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzo(83, false);
        if (zzE3.zzYN(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzg(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzZru, footnoteType);
        footnote.getFont().setStyleIdentifier(zzX.zzUm(footnoteType));
        if (zzE3.zzYN(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZru);
        paragraph.getParagraphFormat().setStyleIdentifier(zzX.zzUl(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZru, '\u0002', new zzYZS()) : new Run(this.zzZru, footnote.getReferenceMark(), new zzYZS());
        inline.getFont().setStyleIdentifier(zzX.zzUm(footnoteType));
        paragraph.appendChild(inline);
        if (zzE3.zzYN(footnoteText)) {
            Node node = this.zz5b();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzf(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zza(zz8F zz8F2) throws Exception {
        return this.zzZ(zz8F2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zza(zz8F.zzY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ(zz8F zz8F2, double d, double d2) throws Exception {
        return this.zzZ(zz8F2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz8F.zzY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zz8H zz8H2 = new zz8H();
        try {
            zzYC.zzZ(image, zz8H2);
            Shape shape = this.zzZ(zz8H2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zz8H2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZ.zzZ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzCR.zzYy(fileName);
        try {
            Shape shape = this.zzZ((zz8F)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz8F)object).close();
            }
        }
    }

    private Shape zzZ(zz8F zz8F2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz8F2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZ.zzZ(zz8F2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz8F.zzY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzZru.getCompatibilityOptions().zzta() > 12 || this.zzZru.getCompatibilityOptions().zzta() == 0) {
            shape = new Shape((DocumentBase)this.zzZru, 0);
            zzBI zzBI2 = new zzBI();
            zzBI2.zzZ(zzEH.zzST("rect"));
            zzBI2.zzZ(new zzLP());
            zzC6 zzC62 = new zzC6();
            zzC62.zzY(new zzCC(shape.getId(), ""));
            zzC62.zzZ(new zzHR());
            zzBI2.zzZ(zzC62);
            shape.zzMt(75);
            shape.zzX(zzBI2);
        } else {
            shape = new Shape((DocumentBase)this.zzZru, 75);
        }
        shape.zzR(this.zz5k());
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        shape.zzE(width, height);
        return shape;
    }

    private Shape zzN(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zz8H zz8H2 = new zz8H();
        try {
            zzYC.zzZ(bufferedImage, zz8H2);
            byArray = zzZ.zzZ(zz8H2);
        }
        finally {
            zz8H2.close();
        }
        return this.zzZt(byArray);
    }

    private Shape zzZt(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZru, 1);
        shape.zzMt(75);
        shape.zzR(this.zz5k());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzE(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        BufferedImage bufferedImage = presentation;
        boolean bl = asIcon;
        String string = progId;
        zz8H zz8H2 = zz8F.zzY(stream);
        DocumentBuilder documentBuilder = this;
        zzZ7M zzZ7M2 = zzZ7M.zzLo(string);
        Shape shape = bufferedImage != null ? documentBuilder.zzN(bufferedImage) : documentBuilder.zzZt(zzZ7I.zzZ(zzZ7M2, bl));
        shape.zzMt(-2);
        shape.getOleFormat().setProgId(zzZ7M2.zzYuQ);
        shape.getOleFormat().zzY(zzZ7I.zzZ(zz8H2, string, bl));
        return shape;
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ7M zzZ7M2 = zzZ7M.zzLn(zz8G.zzXJ(fileName));
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ7M2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ7M zzZ7M2 = zzZ7M.zzLo(progId);
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ7M2);
    }

    private Shape zzZ(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzZ7M zzZ7M2) throws Exception {
        Shape shape = bufferedImage != null ? this.zzN(bufferedImage) : this.zzZt(zzZ7I.zzZ(zzZ7M2, bl2));
        shape.zzMt(-2);
        shape.getOleFormat().setProgId(zzZ7M2.zzYuQ);
        shape.getOleFormat().zzY(zzZ7I.zzV(string, bl, bl2));
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    final Shape zzZ(zzZSU zzZSU2, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzN(bufferedImage);
        shape.zzMt(201);
        shape.getOleFormat().zzY(zzZSU2.zzZQt());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZTF zzZTF2 = new zzZTF();
        zzZTF2.zzWG(useBuilderFormatting);
        zzZTF2.zzWF(useBuilderFormatting);
        this.zzZ(html, zzZTF2);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZQB zzZQB2 = new zzZQB();
        return zzZQB2.zzZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYRF(this).zzZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYRF(this).zzZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZru, 75);
        shape.zzR(this.zz5k());
        boolean bl = true;
        Shape shape2 = shape;
        if (!shape2.isSignatureLine()) {
            shape2.setShapeAttr(1983, true);
            shape2.setShapeAttr(1921, zz8N.zzCR().toString("B").toUpperCase());
            shape2.setShapeAttr(1922, zz8N.zzeO.toString("B").toUpperCase());
        }
        shape.getSignatureLine().zzZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzE(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    private void zzZ(String string, zzZTF zzZTF2) throws Exception {
        Object object;
        Object object2 = this;
        boolean bl = false;
        if (((DocumentBuilder)object2).zz5b().getParentNode().getNodeType() == 28) {
            object = (StructuredDocumentTag)((DocumentBuilder)object2).zz5b().getParentNode();
            switch (((StructuredDocumentTag)object).getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        if (bl) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzSz(documentBuilder.getDocument().toString(70)));
            return;
        }
        object = this;
        zzZTF zzZTF3 = zzZTF2;
        object2 = string;
        zzZUX zzZUX2 = new zzZUX((String)object2, zzZTF3, (DocumentBuilder)object);
        zzZUX2.read();
    }

    private static String zzSz(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zz5e() == null) {
            this.startTable();
        }
        if (this.zz5e().zzZfU() == 1) {
            this.zz5e().zzZfX();
        }
        if (this.zz5e().zzZfU() == 3) {
            this.zz5e().zzZfV();
        }
        return this.zz5e().zzZfW();
    }

    public Table startTable() {
        this.zzZpR.push(new zzYU3(this));
        return this.zz5e().startTable();
    }

    public Table endTable() {
        if (this.zz5e() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zz5e().endTable();
        this.zzZpR.pop();
        return table;
    }

    public Row endRow() {
        if (this.zz5e() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zz5e().endRow();
        if (this.zzZpV != null && this.zzZpV.getHidden()) {
            row.zz5a().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZru, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZru, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZru);
        this.zzZpP = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZpP == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZru, this.zzZpP);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZru, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return new zz77(this).zzZ(srcDoc, importFormatMode, 93);
    }

    public Document getDocument() {
        return this.zzZru;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZru) {
            return;
        }
        this.zzZru = value;
        this.zzf(null);
        this.zzZpW = new zzYZS();
        this.zzZpU = null;
        this.zzZpV = null;
        this.zzZpR = new zz9O();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZpV == null) {
            this.zzZpV = new Font(this, this.getDocument());
        }
        return this.zzZpV;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZpS == null) {
            this.zzZpS = new RowFormat(this);
        }
        return this.zzZpS;
    }

    public CellFormat getCellFormat() {
        if (this.zzZYg == null) {
            this.zzZYg = new CellFormat(this);
        }
        return this.zzZYg;
    }

    public void pushFont() {
        this.zz5c().push(this.zz5k());
    }

    public void popFont() {
        zz9O zz9O2 = this.zz5c();
        if (zz9O2.size() > 0) {
            this.zzZ((zzYZS)this.zz5c().pop(), false);
        }
    }

    private zz1K zzZ(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzNU(88);
        zz1F zz1F2 = new zz1F();
        zz1F2.setTarget(string2);
        zz1F2.setScreenTip(string3);
        if (bl) {
            zz1F2.setSubAddress(string);
        } else {
            zz1F2.setAddress(zzBF.zzYs(string));
            zz1F2.setSubAddress(zzBF.zzYr(string));
        }
        this.zzSx(zz1F2.toString());
        FieldSeparator fieldSeparator = this.zzNT(88);
        return new zz1K(fieldStart, fieldSeparator, null);
    }

    final zz1K zzS(String string, String string2, String string3) {
        boolean bl = zzBF.zzYj(string);
        String string4 = bl ? zzBF.zzYr(string) : string;
        return this.zzZ(string4, bl, string2, string3);
    }

    final FieldEnd zz5l() {
        return this.zzo(88, true);
    }

    final zzYZS zz5k() {
        return (zzYZS)this.zzZpW.zzzt();
    }

    final zzZ6N zz5j() {
        return (zzZ6N)this.getCurrentParagraph().zzZSF().zzzt();
    }

    final zzYTS zz5i() {
        return (zzYTS)this.zz5a().zzzt();
    }

    final zzYH zz5h() {
        return (zzYH)this.zzxn().zzzt();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz5b(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz5b().getNodeType() == 8;
    }

    private void zzJ(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYOW.zzI8(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.zzSw(string2.substring(n, n + n2));
                }
                switch (this.zzZpQ) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzSy(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.zzSw(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzSy(String string) {
        Run run = new Run(this.zzZru, string, this.zz5k());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zz5e() != null && this.zz5e().zzZfU() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zz5b().getParentNode().insertBefore(node, this.zz5b());
    }

    final void zzNW(int n) {
        this.zzXy(true);
        this.zzNV(n);
    }

    private void zzNV(int n) {
        this.insertParagraph();
        zzYUQ zzYUQ2 = new zzYUQ(this.getDocument());
        try {
            zzYYK zzYYK2 = (zzYYK)this.getCurrentSection().zzZzh().zzzt();
            Section section = new Section(this.zzZru, zzYYK2);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZru));
            this.zzZru.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYUQ2.dispose();
        }
    }

    final FieldStart zzNU(int n) {
        return zzX.zzZ(n, this.zz5k(), this.zz5b(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzSx(String string) {
        return zzX.zzY(string, this.zz5k(), this.zz5b(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzo(int n, boolean bl) {
        return zzX.zzY(n, bl, this.zz5k(), this.zz5b(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzNT(int n) {
        return zzX.zzY(n, this.zz5k(), this.zz5b(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzg(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZru, new zzZY1(), this.zz5k());
        this.getCurrentParagraph().insertBefore(formField, node);
        return formField;
    }

    private boolean zzXy(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zz5e() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZ1(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    private void zzSw(String string) {
        boolean bl;
        block4: {
            String string2 = string;
            DocumentBuilder documentBuilder = this;
            boolean bl2 = documentBuilder.getFont().getBidi();
            for (int i = 0; i < string2.length(); ++i) {
                boolean bl3;
                char c = string2.charAt(i);
                int n = zzBG.zzA(c);
                boolean bl4 = n == 0;
                boolean bl5 = bl3 = n == 3 || n == 4;
                if ((!bl2 || !bl4) && (bl2 || !bl3)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            zzYP zzYP10 = new zzYP(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYO zzYO2 : zzYP10.zzI(this.getParagraphFormat().getBidi())) {
                zz6 zz610 = zz6.zzZr(zzYO2.zzYc());
                zzYZS zzYZS2 = this.zz5k();
                zzYZS2.zzU(265, zz610);
                if (zzYO2.zzY9()) {
                    zzYZS2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZru, zzYO2.getText(), zzYZS2);
                this.insertNode(run);
            }
            return;
        }
        this.zzSy(string);
    }

    final void zzZ(zzYZS zzYZS2, boolean bl) {
        this.zzZpW = bl ? (zzYZS)zzYZS2.zzzt() : zzYZS2;
    }

    final void zz5g() {
        this.zzZpW.zzzv();
    }

    final void zz5f() {
        if (this.zz5d() != null) {
            zzYH zzYH2 = this.zz5d().zzxn();
            zzYH zzYH3 = this.zzZYh = (zzYH)zzYH2.zzzt();
            zzYH zzYH4 = zzYH2;
            Iterator iterator = zzYH.zzZXZ.zzEd().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (zzYH4.contains(n)) {
                    Border border = new Border();
                    border.zzV((Border)zzYH4.get(n));
                    zzYH3.set(n, border);
                    continue;
                }
                zzYH3.remove(n);
            }
        }
    }

    final void zzNS(int n) {
        this.zzZpQ = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zz5b();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz5b();
        }
        return (Paragraph)this.zz5b().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYU3 zz5e() {
        zz9O zz9O2 = this.zzZpR;
        if (zz9O2.size() > 0) {
            return zzZ.zzZ(this.zzZpR.peek(), zzYU3.class);
        }
        return null;
    }

    private Cell zz5d() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZYq();
    }

    private zz9O zz5c() {
        if (this.zzZpU == null) {
            this.zzZpU = new zz9O();
        }
        return this.zzZpU;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZpW.zzU1(fontAttr);
    }

    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunAttrsCount() {
        return this.zzZpW.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZD(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZD(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZpW.zzU(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZuK()) {
            this.getCurrentParagraph().zzZuT().zzU(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZpW.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZpW.zzzv();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZuK()) {
            this.getCurrentParagraph().zzZuT().zzzv();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zz5a().zzU1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zz5a().zzU0(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zz5a().zzTZ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zz5a().zzU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zz5a().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zz5a().clear();
        zzYTS.zzZeQ().zzZ(this.zz5a());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzxn().zzU1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzxn().fetchCellAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzxn().zzTZ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZ.zzZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zz5d() != null ? this.zz5d().getCellFormat() : this.getCellFormat();
            border.zzZ(cellFormat);
        }
        this.zzxn().zzU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzxn().zzzv();
    }

    private Node zz5b() {
        Node node = this.zzZpY != null && this.zzZpY.getParentNode() == null ? this.zzZpX : this.zzZpY;
        if (node != null && node.zzZCH() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzf(Node node) {
        this.zzZpY = node;
        if (this.zzZpY != null) {
            this.zzZpX = this.zzZpY.getParentNode();
        }
    }

    private zzYTS zz5a() {
        if (this.zz5e() != null && this.zz5e().zzZfU() == 1) {
            return this.zzZpT;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zz5a();
        }
        return this.zzZpT;
    }

    private zzYH zzxn() {
        if (this.zz5e() != null && this.zz5e().zzZfU() != 3) {
            return this.zzZYh;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZYq().zzxn();
        }
        return this.zzZYh;
    }
}

