/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz8F;
import asposewobfuscated.zz8I;
import asposewobfuscated.zzE3;
import asposewobfuscated.zzEJ;
import asposewobfuscated.zzS3;
import asposewobfuscated.zzW;
import asposewobfuscated.zzZ;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zzZZD;
import java.io.EOFException;
import java.io.InputStream;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zzEJ zzZam = new zzEJ();
    private static zzEJ zzZal = new zzEJ();
    private static zzEJ zzZak = new zzEJ();
    private static zzEJ zzZaj = new zzEJ();
    private static zzEJ zzZai = new zzEJ();
    private static zzEJ zzZah = new zzEJ();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ.zzZ(fileName, "fileName");
        zz8I zz8I2 = zzZ.zzT(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz5(zz8I2);
            return fileFormatInfo;
        }
        finally {
            ((zz8F)zz8I2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz5(zzW.zzZ(stream));
    }

    static FileFormatInfo zz5(zz8F zz8F2) throws Exception {
        if (zz8F2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzZZD zzZZD2 = new zzZZD();
            zz8F zz8F3 = zz8F2;
            zzZZD zzZZD3 = zzZZD2;
            return zzZZD2.zzY(zz8F3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzLb(zzS3.zzj(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzLg(zzS3.zzj(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzS3.zzY0(FileFormatUtil.zzLd(loadFormat));
        if (zzE3.zzYN(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzLb(FileFormatUtil.zzLc(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzLg(FileFormatUtil.zzLd(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzS3.zzY0(FileFormatUtil.zzLc(saveFormat));
        if (zzE3.zzYN(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzLg(zzS3.zzi(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        int n = imageType;
        Object object = zzZak.get(n);
        return "." + zzS3.zzY0(object == null ? 0 : (Integer)object);
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzLh(int n) {
        return zzS3.toString(FileFormatUtil.zzLc(n));
    }

    static int zzLg(int n) {
        Object object = zzZai.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzLf(int n) {
        Object object = zzZah.get(n);
        if (object != null) {
            return (Integer)object;
        }
        return 1;
    }

    static boolean zzLe(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzLd(int n) {
        Object object = zzZam.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzLc(int n) {
        Object object = zzZal.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzLb(int n) {
        Object object = zzZaj.get(n);
        if (object == null) {
            return 255;
        }
        return (Integer)object;
    }

    static {
        Object[] objectArray = new Object[]{11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 28, null, 52, null, 22, 60, 60, null, 23, 61, 61, null, 31, 40, null, null, 39, 47, null, null, 32, 41, null, null, 33, 46, null, null, 36, 42, null, null, 34, 43, null, null, 35, 44, null, null, 29, 52, null, null, 30, 70, 62, null, 37, 71, null, null, 8, 100, null, null, 9, 105, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 38, 72, null, null, 2, 103, null, 2};
        for (int i = 0; i < 156; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZai.add((Integer)object, object2);
                zzZal.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZaj.contains((Integer)object)) {
                    zzZaj.add((Integer)object, object3);
                }
                zzZam.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZah.add((Integer)object, object4);
            zzZak.add((Integer)object4, object);
        }
    }
}

