/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz2X;
import asposewobfuscated.zz3M;
import asposewobfuscated.zz9M;
import asposewobfuscated.zzE3;
import asposewobfuscated.zzR9;
import asposewobfuscated.zzZ;
import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldChar;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.zzYOW;
import com.aspose.words.zzYZS;
import com.aspose.words.zzZEF;
import com.aspose.words.zzZNY;
import com.aspose.words.zzZY1;

public class FormField
extends SpecialChar {
    private zzZY1 zzZ7W;
    private Field zzZ7V;
    static String zzZ7U = zz3M.zzV('\u2002', 5);
    private static final zz2X zzVJ = new zz2X("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZY1 formFieldPr, zzYZS runPr) {
        super(doc, '\u0001', runPr);
        this.zzZ7W = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZNY zzZNY2) {
        FormField formField = (FormField)super.zzZ(bl, zzZNY2);
        ((FormField)super.zzZ(bl, zzZNY2)).zzZ7W = (zzZY1)this.zzZ7W.zzzt();
        formField.zzZ7V = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZCQ().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n;
                String string = this.getTextInputFormat();
                string = string.toLowerCase();
                switch (zzVJ.zzWW(string)) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int n2 = n;
                this.setResult(zzE3.zzI((String)newValue, n2));
                return;
            }
            case 1: {
                double d;
                FieldOptions fieldOptions = this.zzZCP().getFieldOptions();
                Object object = newValue;
                if (object == null) {
                    d = 0.0;
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Double) {
                    d = (Double)object;
                } else {
                    throw new ClassCastException("Cannot convert a value to double.");
                }
                this.setResult(zzR9.zzZ(d, this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYOW.zzY((zz9M)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZ7W.getName();
    }

    public void setName(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(value);
        }
        this.zzZ7W.setName(value);
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZU2() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Field getField() {
        if (this.zzZ7V == null) {
            FieldChar fieldChar;
            FieldChar fieldChar2;
            block7: {
                FormField formField = this;
                int n = 0;
                Node node = formField.getPreviousSibling();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 22: {
                            if (n-- != 0) break;
                            fieldChar2 = (FieldStart)node;
                            break block7;
                        }
                        case 24: {
                            ++n;
                        }
                    }
                    node = node.getPreviousSibling();
                }
                fieldChar2 = fieldChar = null;
            }
            if (fieldChar2 != null) {
                this.zzZ7V = fieldChar.getField();
            }
        }
        return this.zzZ7V;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                if (zz3M.equals(string, zzZ7U)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZU1();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzR9.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzQA(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZ7W.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZ7W.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZ7W.zzZTX();
    }

    public void setOwnStatus(boolean value) {
        this.zzZ7W.zzWP(value);
    }

    public String getHelpText() {
        return this.zzZ7W.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZ7W.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZ7W.zzZTY();
    }

    public void setOwnHelp(boolean value) {
        this.zzZ7W.zzWQ(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZ7W.zzZTZ();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZ7W.zzWR(value);
    }

    public String getEntryMacro() {
        return this.zzZ7W.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZ7W.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZ7W.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZ7W.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZ7W.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZ7W.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZ7W.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZ7W.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZ7W.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZ7W.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZ7W.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZ7W.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzGl(21);
            zzZEF.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZCP());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZ7W.zzZTW();
    }

    public void setMaxLength(int value) {
        this.zzZ7W.zzKx(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZ7W.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZY1 zzZY12 = this.zzZ7W;
        if (zzZY12.contains(21070)) {
            return this.zzZ7W.zzZTQ();
        }
        return this.zzZ7W.zzZTR();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZ7W.zzKu(value);
    }

    final String zzZU1() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzQA(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzE3.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZY1 zzZY12 = this.zzZ7W;
        if (zzZY12.contains(21010)) {
            return this.zzZ7W.zzZTS();
        }
        return this.zzZ7W.zzZTT();
    }

    public void setChecked(boolean value) {
        this.zzZ7W.zzWM(value);
    }

    public boolean getDefault() {
        return this.zzZ7W.zzZTT();
    }

    public void setDefault(boolean value) {
        this.zzZ7W.zzWN(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZ7W.zzZTV();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZ7W.zzWO(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZ7W.zzZTU();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZ7W.zzKw(zzZ.zzV(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzZY1 zzZU0() {
        return this.zzZ7W;
    }
}

