/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz9O;
import asposewobfuscated.zzZ;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.zzX;
import com.aspose.words.zzYSF;
import com.aspose.words.zzZNY;
import com.aspose.words.zzZPA;
import com.aspose.words.zzZUY;

public abstract class Node
implements Cloneable {
    private Node zzYGO;
    private Node zzYGN;
    private Node zzYGM;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzZ(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYGO == null) {
            return null;
        }
        if (this.zzYGO.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYGO;
    }

    final CompositeNode zzZCQ() {
        if (zzX.zzK(this.getParentNode())) {
            return this.getParentNode().zzZCQ();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYGO == null) {
            return null;
        }
        return this.zzYGO.getDocument();
    }

    final Document zzZCP() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZCO() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz6Q();
    }

    public Node getPreviousSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getFirstChild()) {
            Node node = this;
            return node.zzYGM;
        }
        return null;
    }

    final Node zzZCN() {
        Node node = zzX.zzI(this.getPreviousSibling());
        if (node == null && zzX.zzK(this.getParentNode())) {
            node = this.getParentNode().zzZCN();
        }
        return node;
    }

    final Node zzZCM() {
        Node node = zzX.zzJ(this.getNextSibling());
        if (node == null && zzX.zzK(this.getParentNode())) {
            node = this.getParentNode().zzZCM();
        }
        return node;
    }

    public Node getNextSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getLastChild()) {
            Node node = this;
            return node.zzYGN;
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZCL() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    final boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    final boolean zzZCK() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzX.zzT(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZCJ() {
        return this.zzYGN;
    }

    final void zzZn(Node node) {
        this.zzYGN = node;
    }

    final Node zzZCI() {
        return this.zzYGM;
    }

    final void zzZm(Node node) {
        this.zzYGM = node;
    }

    final int zzZCH() {
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        if (zzX.zzP(this)) {
            return 3;
        }
        if (zzX.zzO(this)) {
            return 4;
        }
        if (zzX.zzN(this)) {
            return 5;
        }
        if (zzX.zzM(this)) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZNY zzZNY2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYGO != null) {
            node.zzYGO = this.getDocument().zz5A();
        }
        node.zzYGN = null;
        node.zzYGM = null;
        if (zzZNY2 != null) {
            zzZNY2.zzU(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzU(StringBuilder stringBuilder) {
        zzZ.zzY(stringBuilder, this.getText());
    }

    public Node getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public Node getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZl(Node node) {
        this.zzYGO = node != null ? node : this.getDocument().zz5A();
    }

    final void zzZ(DocumentBase documentBase) {
        this.zzYGO = documentBase != null ? documentBase.zz5A() : null;
    }

    final boolean zzZk(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZCG() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzGl(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzGk(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzUd(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    @Deprecated
    public String toTxt() throws Exception {
        return this.toString(70);
    }

    public String toString(int saveFormat) throws Exception {
        zzZPA zzZPA2;
        int n = saveFormat;
        switch (n) {
            case 50: {
                zzZPA2 = new zzZUY();
                break;
            }
            case 70: {
                zzZPA2 = new zzYSF();
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZPA zzZPA3 = zzZPA2;
        return zzZPA2.zzZz(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZPA zzZPA2;
        SaveOptions saveOptions2 = saveOptions;
        switch (saveOptions2.getSaveFormat()) {
            case 50: {
                zzZPA2 = new zzZUY((HtmlSaveOptions)saveOptions2);
                break;
            }
            case 70: {
                zzZPA2 = new zzYSF((TxtSaveOptions)saveOptions2);
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZPA zzZPA3 = zzZPA2;
        return zzZPA2.zzZz(this);
    }

    final Node zzGj(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzX.zzQ(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final boolean zzZj(Node node) {
        Node node2;
        zz9O zz9O2;
        zz9O zz9O3;
        Node node3 = node;
        Node node4 = this;
        if (node4 == null || node3 == null) {
            return false;
        }
        zz9O zz9O4 = Node.zzZi(node4);
        zz9O zz9O5 = zz9O3 = Node.zzZi(node3);
        zz9O zz9O6 = zz9O4;
        Object var13_8 = null;
        while (zz9O6.peek() == zz9O5.peek()) {
            var13_8 = zz9O6.pop();
            zz9O5.pop();
            zz9O2 = zz9O6;
            if (zz9O2.size() != 0 && (zz9O2 = zz9O5).size() != 0) continue;
        }
        if ((node2 = (Node)var13_8) != null) {
            zz9O2 = zz9O4;
            if (zz9O2.size() == 0 || (zz9O2 = zz9O3).size() == 0) {
                zz9O2 = zz9O3;
                boolean bl = zz9O2.size() > 0;
                return bl;
            }
            Object e = zz9O4.peek();
            Object e2 = zz9O3.peek();
            for (Node node5 : ((CompositeNode)node2).getChildNodes()) {
                if (node5 == e) {
                    return true;
                }
                if (node5 != e2) continue;
            }
        }
        return false;
    }

    final boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    private static zz9O zzZi(Node node) {
        zz9O zz9O2 = new zz9O();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zz9O2.push(node2);
        }
        return zz9O2;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

