/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz8G;
import asposewobfuscated.zzS3;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.SwfSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean zzYdv = false;
    private boolean zzYdu = true;
    private boolean zzGh;
    private String zzYdt;
    private boolean zzYds;
    private boolean zzYdr = false;
    private boolean zzYdq = true;
    private int zzYdp = 1;
    private int zzYYc = 0;
    private IWarningCallback zz27;
    private int zzFg = 0;
    private String zzYdo = "";
    private boolean zzYdn = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZPY() {
        return false;
    }

    boolean zzZVi() {
        return true;
    }

    final boolean zzZnz() {
        return this.zzYdu;
    }

    public String getTempFolder() {
        return this.zzYdt;
    }

    public void setTempFolder(String value) {
        this.zzYdt = value;
    }

    public boolean getPrettyFormat() {
        return this.zzGh;
    }

    public void setPrettyFormat(boolean value) {
        this.zzGh = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYds;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYds = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYdr;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYdr = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYdq;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYdq = value;
    }

    public int getColorMode() {
        return this.zzFg;
    }

    public void setColorMode(int value) {
        this.zzFg = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYdp;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYdp = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYYc;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYYc = value;
    }

    public String getDefaultTemplate() {
        return this.zzYdo;
    }

    public void setDefaultTemplate(String value) {
        this.zzYdo = value;
    }

    public boolean getUpdateFields() {
        return this.zzYdn;
    }

    public void setUpdateFields(boolean value) {
        this.zzYdn = value;
    }

    @Deprecated
    public IWarningCallback getWarningCallback() {
        return this.zz27;
    }

    @Deprecated
    public void setWarningCallback(IWarningCallback value) {
        this.zz27 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYdv;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYdv = value;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 43: {
                return new SwfSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzLg(zzS3.zzi(zz8G.zzXJ(fileName))));
    }
}

