/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Story;
import com.aspose.words.zzYYK;
import com.aspose.words.zzZNB;
import com.aspose.words.zzZNY;

public class Section
extends CompositeNode<Node>
implements zzZNB {
    private zzYYK zzYzh;
    private PageSetup zzYcI;
    private HeaderFooterCollection zzYcH;

    public Section(DocumentBase doc) {
        this(doc, new zzYYK());
    }

    Section(DocumentBase doc, zzYYK sectPr) {
        super(doc);
        this.zzYzh = sectPr;
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    public Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public HeaderFooterCollection getHeadersFooters() {
        if (this.zzYcH == null) {
            this.zzYcH = new HeaderFooterCollection(this);
        }
        return this.zzYcH;
    }

    public PageSetup getPageSetup() {
        if (this.zzYcI == null) {
            this.zzYcI = new PageSetup(this, this.getDocument().zz5s());
        }
        return this.zzYcI;
    }

    public boolean getProtectedForForms() {
        return !this.getPageSetup().zzZvq();
    }

    public void setProtectedForForms(boolean value) {
        this.getPageSetup().zzT4(!value);
    }

    final zzYYK zzZzh() {
        return this.zzYzh;
    }

    final void zzY(zzYYK zzYYK2) {
        this.zzYzh = zzYYK2;
    }

    public Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZ(boolean bl, zzZNY zzZNY2) {
        zzYYK zzYYK2;
        Section section = (Section)super.zzZ(bl, zzZNY2);
        section.zzYzh = zzYYK2 = (zzYYK)this.zzYzh.zzzt();
        section.zzYcI = null;
        section.zzYcH = null;
        return section;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public void prependContent(Section sourceSection) {
        this.zzW(sourceSection, false);
    }

    public void appendContent(Section sourceSection) {
        this.zzW(sourceSection, true);
    }

    public void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzBA(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzn(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzBA(n) == null;
            }
        }
        return false;
    }

    private void zzW(Section section, boolean bl) {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zzY(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectSectionAttr(int key) {
        return this.zzYzh.zzU1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zz5s().zzZsP.zzU0(key);
        }
        return zzYYK.zzTw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYzh.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zz5s().zzZsP.zzU(key, value);
            return;
        }
        this.zzYzh.zzU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearSectionAttrs() {
        this.zzYzh.zzzv();
    }

    final boolean zzZmR() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZmQ() {
        return this.getParentNode().getLastChild() == this;
    }
}

