/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz9M;
import asposewobfuscated.zzNQ;
import asposewobfuscated.zzNR;
import asposewobfuscated.zzNW;
import asposewobfuscated.zzZ;
import asposewobfuscated.zzZG;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.RowCollection;
import com.aspose.words.Shading;
import com.aspose.words.Style;
import com.aspose.words.zzX;
import com.aspose.words.zzYH;
import com.aspose.words.zzYP1;
import com.aspose.words.zzYTS;
import com.aspose.words.zzYTW;
import com.aspose.words.zzYTY;
import com.aspose.words.zzZKL;
import com.aspose.words.zzZNY;
import com.aspose.words.zzZWP;
import com.aspose.words.zzZY0;
import com.aspose.words.zzZYO;
import java.awt.Color;
import java.util.Iterator;

public class Table
extends CompositeNode<Row> {
    private RowCollection zzY4I;
    private zzYTS zzZpT;

    public Table(DocumentBase doc) {
        super(doc);
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    public Row getFirstRow() {
        Table table = this;
        return (Row)zzX.zzJ(table.getFirstChild());
    }

    public Row getLastRow() {
        Table table = this;
        return (Row)zzX.zzI(table.getLastChild());
    }

    public RowCollection getRows() {
        if (this.zzY4I == null) {
            this.zzY4I = new RowCollection(this);
        }
        return this.zzY4I;
    }

    final boolean zzZg5() {
        for (Row row : this.getRows()) {
            Iterator iterator = row.getCells().iterator();
            if (!iterator.hasNext()) continue;
            iterator.next();
            return true;
        }
        return false;
    }

    @Override
    final Node zzZ(boolean bl, zzZNY zzZNY2) {
        Table table = (Table)super.zzZ(bl, zzZNY2);
        if (this.zzZpT != null) {
            table.zzZpT = (zzYTS)this.zzZpT.zzzt();
        }
        table.zzY4I = null;
        return table;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableEnd(this);
    }

    public void ensureMinimum() {
        Row row = this.getFirstRow();
        if (row == null) {
            row = (Row)this.appendChild(new Row(this.getDocument()));
        }
        row.ensureMinimum();
    }

    final Cell zzXE(int n, int n2) {
        try {
            if (n2 < 0 || n2 >= this.getRows().getCount()) {
                return null;
            }
            CellCollection cellCollection = this.getRows().get(n2).getCells();
            if (n < 0 || n >= cellCollection.getCount()) {
                return null;
            }
            return cellCollection.get(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final int getColumnCount() {
        int n = 0;
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Row row2 = row;
            int n2 = 0;
            Cell cell = row2.getFirstCell();
            while (cell != null) {
                n2 += cell.zzxn().zzzd();
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZCM();
            }
            n = Math.max(n, n2);
            compositeNode = row;
            row = (Row)compositeNode.zzZCM();
        }
        return n;
    }

    final zzZKL zzZg4() {
        zzYTW zzYTW2 = new zzYTW(this);
        return zzYTW2.zzZfa();
    }

    final void zzZg3() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZrS()) {
            Cell cell = null;
            block6: for (Cell cell2 = row.getFirstCell(); cell2 != null; cell2 = cell2.zzxp()) {
                switch (cell2.zzxn().getHorizontalMerge()) {
                    case 1: {
                        cell = cell2;
                        cell.zzxn().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 2: {
                        if (cell != null) {
                            Cell cell3;
                            cell.zzxn().setWidth(cell.zzxn().getWidth() + cell2.zzxn().getWidth());
                            cell.zzxn().zzTQ(cell.zzxn().zzzd() + cell2.zzxn().zzzd());
                            if (cell2.zzxn().getWidth() != 0 && cell.zzxn().getPreferredWidth().zzB9() && cell2.zzxn().getPreferredWidth().zzB9()) {
                                int n = cell.zzxn().getPreferredWidth().zzZto() + cell2.zzxn().getPreferredWidth().zzZto();
                                cell.zzxn().setPreferredWidth(PreferredWidth.zzDv(n));
                            }
                            if ((Cell)(cell3 = cell2).zzZCM() == null || ((Cell)(cell3 = cell2).zzZCM()).zzxn().getHorizontalMerge() != 2) {
                                Object object = cell2.zzxn().zzU1(3140);
                                if (object != null) {
                                    cell.zzxn().zzU(3140, object);
                                } else {
                                    cell.zzxn().remove(3140);
                                }
                            }
                            cell2.remove();
                            cell2 = cell;
                            continue block6;
                        }
                        cell2.zzxn().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 0: {
                        cell = null;
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown cell merge type.");
                    }
                }
            }
        }
    }

    final void zzZg2() {
        Object object;
        if (!this.zzt1()) {
            return;
        }
        zzYTY zzYTY2 = new zzYTY(this);
        if (zzYTY2.zzwc().length == 0) {
            return;
        }
        zzNR zzNR2 = new zzNR();
        zzNQ zzNQ2 = new zzNQ();
        CompositeNode compositeNode = this.getFirstRow();
        while (compositeNode != null) {
            zzYTY2.zzF((Row)compositeNode);
            zzNR zzNR3 = new zzNR();
            zzNQ zzNQ3 = new zzNQ();
            int n = zzYTY2.zzZiX();
            Object object2 = ((Row)compositeNode).getFirstCell();
            while (object2 != null) {
                int n2 = zzYTY2.zzZfu();
                if (((Cell)object2).zzxn().getVerticalMerge() != 0) {
                    boolean bl;
                    int n3 = zzNR2.get(n);
                    if (zzNR.zzXC(n3) || n3 != n2) {
                        ((Cell)object2).zzxn().setVerticalMerge(1);
                    }
                    if (bl = !((Row)compositeNode).zz5a().zzXi(4120) && ((Row)compositeNode).getCells().getCount() == 1) {
                        CompositeNode compositeNode2 = compositeNode;
                        int n4 = ((Row)compositeNode2).getFirstCell().getLastParagraph() != null ? (int)(23.0 * ((Row)compositeNode2).getFirstCell().getLastParagraph().getParagraphBreakFont().getSize()) : 276;
                        ((Row)compositeNode2).zz5a().zzU(4120, new zzZWP(0, n4));
                    }
                    zzNR3.set(n, n2);
                    zzNQ3.set(n, object2);
                }
                n += n2;
                object = object2;
                object2 = (Cell)((Node)object).zzZCM();
            }
            object2 = zzNQ2.zzOe();
            while (((zzNQ.zzZ)object2).moveNext()) {
                Cell cell = (Cell)((zzNQ.zzZ)object2).zzOc();
                if (cell.zzxn().getVerticalMerge() != 1 || zzNQ3.get(((zzNQ.zzZ)object2).zzOg()) != null) continue;
                cell.zzxn().setVerticalMerge(0);
            }
            zzNR2 = zzNR3;
            zzNQ2 = zzNQ3;
            object = compositeNode;
            compositeNode = (Row)((Node)object).zzZCM();
        }
        compositeNode = this.getLastRow().getFirstCell();
        while (compositeNode != null) {
            if (((Cell)compositeNode).zzxn().getVerticalMerge() == 1) {
                ((Cell)compositeNode).zzxn().setVerticalMerge(0);
            }
            object = compositeNode;
            compositeNode = (Cell)((Node)object).zzZCM();
        }
    }

    final void zzZg1() throws Exception {
        if (!this.isNested() || this.getFirstRow() == null) {
            return;
        }
        Table table = (Table)this.getAncestor(5);
        boolean bl = table.getAllowAutoFit();
        if (bl != this.getAllowAutoFit()) {
            if (!bl) {
                this.zzZg4();
            }
            this.setAllowAutoFit(bl);
        }
    }

    final int zz6r() {
        Row row = this.getFirstRow();
        if (row == null) {
            return 0;
        }
        zzYH zzYH2 = row.getFirstCell().zzxn();
        boolean bl = this.isNested();
        zzYH zzYH3 = zzYH2;
        zzYTS zzYTS2 = row.zz5a();
        return zzYTS2.zzZHh() - zzYTS2.zzY(zzYH3, bl);
    }

    @Override
    final boolean zzn(Node node) {
        return zzX.zzO(node);
    }

    final boolean isNested() {
        if (this.zzZCQ() == null) {
            return false;
        }
        return this.zzZCQ().getNodeType() == 7;
    }

    public int getAlignment() {
        return (Integer)this.zzzZ(4010);
    }

    public void setAlignment(int value) throws Exception {
        this.zzw(4010, value);
    }

    public boolean getAllowAutoFit() {
        return (Boolean)this.zzzZ(4240);
    }

    public void setAllowAutoFit(boolean value) throws Exception {
        this.zzw(4240, value);
    }

    public PreferredWidth getPreferredWidth() {
        return (PreferredWidth)this.zzzZ(4230);
    }

    public void setPreferredWidth(PreferredWidth value) throws Exception {
        this.zzw(4230, value);
    }

    public boolean getBidi() {
        return (Boolean)this.zzzZ(4380);
    }

    public void setBidi(boolean value) throws Exception {
        this.zzw(4380, value);
    }

    public double getLeftPadding() {
        int n = (Integer)this.zzzZ(4020);
        return (double)n / 20.0;
    }

    public void setLeftPadding(double value) throws Exception {
        this.zzw(4020, zzZ.zzU(value));
    }

    public double getRightPadding() {
        int n = (Integer)this.zzzZ(4320);
        return (double)n / 20.0;
    }

    public void setRightPadding(double value) throws Exception {
        this.zzw(4320, zzZ.zzU(value));
    }

    public double getTopPadding() {
        int n = (Integer)this.zzzZ(4300);
        return (double)n / 20.0;
    }

    public void setTopPadding(double value) throws Exception {
        this.zzw(4300, zzZ.zzU(value));
    }

    public double getBottomPadding() {
        int n = (Integer)this.zzzZ(4310);
        return (double)n / 20.0;
    }

    public void setBottomPadding(double value) throws Exception {
        this.zzw(4310, zzZ.zzU(value));
    }

    public double getCellSpacing() {
        int n = (Integer)this.zzzZ(4290);
        return (double)n / 20.0;
    }

    public void setCellSpacing(double value) throws Exception {
        this.zzw(4290, zzZ.zzU(value));
    }

    public double getLeftIndent() {
        int n = (Integer)this.zzzZ(4340);
        return (double)n / 20.0;
    }

    public void setLeftIndent(double value) throws Exception {
        this.zzw(4340, zzZ.zzU(value));
    }

    public int getStyleOptions() {
        return (Integer)this.zzzZ(4140);
    }

    public void setStyleOptions(int value) throws Exception {
        this.zzw(4140, value);
    }

    public Style getStyle() {
        return this.getDocument().getStyles().zzXG(this.zzZUh(), 11);
    }

    public void setStyle(Style value) throws Exception {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("This style belongs to a different document.");
        }
        if (value.getType() != 3) {
            throw new IllegalArgumentException("This style is not a table style.");
        }
        int n = value.zzZUh();
        Table table = this;
        table.zzw(4005, n);
    }

    public String getStyleName() {
        return this.getStyle().getName();
    }

    public void setStyleName(String value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzJW(value));
    }

    public int getStyleIdentifier() {
        return this.getStyle().getStyleIdentifier();
    }

    public void setStyleIdentifier(int value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzAv(value));
    }

    public int getTextWrapping() {
        if (this.isFloating()) {
            return 1;
        }
        return 0;
    }

    public void setTextWrapping(int value) throws Exception {
        if (value == 1) {
            Table table = this;
            zzYTS zzYTS2 = table.getFirstRow().zz5a();
            table.zzw(4160, 2);
            table.zzw(4190, 0);
            table.zzw(4210, 180);
            table.zzw(4270, 180);
            table.zzw(4350, false);
            int n = (Integer)zzYTS2.zzU0(4010);
            if (n == 2) {
                table.zzw(4180, 3);
            } else if (n == 1) {
                table.zzw(4180, 2);
            }
            table.zzA1(4010);
            if (zzYTS2.contains(4340)) {
                int n2 = (Integer)zzYTS2.zzU1(4340);
                table.zzw(4170, n2 - 1);
            }
            table.zzA1(4340);
            return;
        }
        Table table = this;
        zzYTS zzYTS3 = table.getFirstRow().zz5a();
        int n = (Integer)zzYTS3.zzU0(4180);
        if (n == 3) {
            table.zzw(4010, 2);
        } else if (n == 2) {
            table.zzw(4010, 1);
        }
        table.zzA1(4170);
        table.zzA1(4160);
        table.zzA1(4150);
        table.zzA1(4190);
        table.zzA1(4210);
        table.zzA1(4270);
        table.zzA1(4350);
        table.zzA1(4180);
        table.zzA1(4200);
    }

    final int zzZUh() {
        return (Integer)this.zzzZ(4005);
    }

    final boolean isFloating() {
        return this.getRows().getCount() > 0 && this.getRows().get(0).zz5a().isFloating();
    }

    final zzYTS zz5a() {
        if (this.zzZpT == null) {
            this.zzZpT = new zzYTS();
        }
        return this.zzZpT;
    }

    public void setBorders(int lineStyle, double lineWidth, Color color) throws Exception {
        Iterator iterator = zzYTS.zzZXZ.zzEf().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.setBorder(n, lineStyle, lineWidth, color, true);
        }
    }

    public void setBorder(int borderType, int lineStyle, double lineWidth, Color color, boolean isOverrideCellBorders) throws Exception {
        if (isOverrideCellBorders) {
            int n = borderType;
            Table table = this;
            switch (n) {
                case 3: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzxn().remove(3110);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZCM();
                    }
                    break;
                }
                case 0: {
                    CompositeNode compositeNode;
                    Row row = table.getLastRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzxn().remove(3130);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZCM();
                    }
                    break;
                }
                case 1: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        if (cell != null) {
                            cell.zzxn().remove(3120);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZCM();
                    }
                    break;
                }
                case 2: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getLastCell();
                        if (cell != null) {
                            cell.zzxn().remove(3140);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZCM();
                    }
                    break;
                }
                case 4: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        boolean bl2 = !row.isFirstRow();
                        bl = !row.isLastRow();
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            if (bl2) {
                                cell.zzxn().remove(3110);
                            }
                            if (bl) {
                                cell.zzxn().remove(3130);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZCM();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZCM();
                    }
                    break;
                }
                case 5: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            boolean bl3;
                            bl = !cell.isFirstCell();
                            boolean bl4 = bl3 = !cell.isLastCell();
                            if (bl) {
                                cell.zzxn().remove(3120);
                            }
                            if (bl3) {
                                cell.zzxn().remove(3140);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZCM();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZCM();
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected border type.");
                }
            }
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZrS()) {
            Border border = row.getRowFormat().getBorders().getByBorderType(borderType);
            border.setLineStyle(lineStyle);
            border.setLineWidth(lineWidth);
            border.setColor(color);
        }
    }

    public void clearBorders() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            int n;
            zzYP1 zzYP12 = row.zz5a();
            Iterator iterator = zzYTS.zzZXZ.zzEd().iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                zzYP12.remove(n);
            }
            Cell cell = row.getFirstCell();
            while (cell != null) {
                zzYP12 = cell.zzxn();
                iterator = zzYH.zzZXZ.zzEd().iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    zzYP12.remove(n);
                }
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZCM();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZCM();
        }
    }

    public void setShading(int texture, Color foregroundColor, Color backgroundColor) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                Shading shading = cell.getCellFormat().getShading();
                shading.setTexture(texture);
                shading.setForegroundPatternColor(foregroundColor);
                shading.setBackgroundPatternColor(backgroundColor);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZCM();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZCM();
        }
    }

    public void clearShading() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            zzYP1 zzYP12 = row.zz5a();
            zzYP12.remove(4330);
            Cell cell = row.getFirstCell();
            while (cell != null) {
                zzYP12 = cell.zzxn();
                zzYP12.remove(3170);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZCM();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZCM();
        }
    }

    public void autoFit(int behavior) throws Exception {
        switch (behavior) {
            case 0: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzA1(4230);
                table.zzA0(3020);
                table.zzZg4();
                return;
            }
            case 1: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzw(4230, PreferredWidth.fromPercent(100.0));
                table.zzA0(3020);
                table.zzZg4();
                return;
            }
            case 2: {
                Table table = this;
                table.setAllowAutoFit(false);
                table.setPreferredWidth(PreferredWidth.AUTO);
                Table table2 = table;
                if (table2.zz5a().zzZeH() != null) {
                    table2.zz5a().remove(5106);
                }
                table2 = table;
                Row row = table2.getFirstRow();
                while (row != null) {
                    CompositeNode compositeNode;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        PreferredWidth preferredWidth;
                        Object object = cell.zzxn().zzU1(3010);
                        int n = object == null ? 0 : (Integer)object;
                        if (n <= 0 && (preferredWidth = cell.getCellFormat().getPreferredWidth()).zzB9()) {
                            n = preferredWidth.zzZto();
                            cell.zzxn().setWidth(n);
                        }
                        if (n <= 0) {
                            n = 360 * cell.zzxn().zzzd();
                            cell.zzxn().zzU(3010, n);
                        }
                        cell.zzxn().setPreferredWidth(PreferredWidth.zzDv(n));
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZCM();
                    }
                    compositeNode = row;
                    row = (Row)compositeNode.zzZCM();
                }
                table.zzZfY();
                return;
            }
        }
        throw new IllegalArgumentException("Unknown auto fit behavior.");
    }

    final int zzZg0() {
        if (this.getRows().getCount() == 0) {
            return 0;
        }
        int n = 0;
        for (Row row : this.getRows()) {
            int n2 = 0;
            for (Cell cell : row.getCells()) {
                n2 += cell.zzxn().getWidth();
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    final boolean zzZfZ() {
        for (Row row : this.getRows()) {
            if (row.zz5a().hasRevisions()) {
                return true;
            }
            for (Cell cell : row.getCells()) {
                if (!cell.zzxn().hasRevisions()) continue;
                return true;
            }
        }
        return false;
    }

    final void zzA1(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            row.zz5a().remove(n);
            Row row2 = row;
            row = (Row)row2.zzZCM();
        }
    }

    final void zzw(int n, Object object) throws Exception {
        if (this.getFirstRow() == null) {
            throw new IllegalStateException("Formatting cannot be applied because the table is empty. Add at least one row to the table first.");
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZrS()) {
            if (n == 4005) {
                Row row2 = row;
                Table table = this;
                Object object2 = row2.zz5a().get(4120);
                Object object3 = row2.zz5a().get(4240);
                Object object4 = row2.zz5a().get(4230);
                row2.getRowFormat().clearFormatting();
                table.zzA0(3060);
                if (object2 != null) {
                    row2.zz5a().zzU(4120, object2);
                }
                if (object3 != null) {
                    row2.zz5a().zzU(4240, object3);
                }
                if (object4 != null) {
                    row2.zz5a().zzU(4230, object4);
                }
            }
            row.zz5a().zzU(n, object);
        }
    }

    private void zzA0(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                cell.zzxn().remove(n);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZCM();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZCM();
        }
    }

    final void zzZfY() {
        zzZYO zzZYO2 = this.zz5a().zzZeH();
        if (zzZYO.zzZ(zzZYO2) && this.zz5a().zzU1(5103) != null) {
            return;
        }
        zzYTY zzYTY2 = new zzYTY(this, false);
        zzYTY zzYTY3 = new zzYTY(this, true);
        this.zz5a().zzU(5103, new zzNW(zzYTY2.zzwc()));
        for (Row row : this.getRows()) {
            zzYTY2.zzF(row);
            Table.zzZ(row.zz5a(), zzYTY2);
            for (Object object : row.getCells()) {
                ((Cell)object).zzxn().zzU(3900, zzYTY2.zzZfu());
            }
        }
        if (zzZG.zzU(zzYTY2.zzwc(), zzYTY3.zzwc())) {
            zzYTS zzYTS2 = this.zz5a();
            zzYTS2.remove(10010);
            return;
        }
        if (this.zz5a().zzZsu() == null) {
            this.zz5a().zzZ(new zzZY0(new zzYTS(), "", zz9M.zzks));
        }
        this.zz5a().zzZeE().zzU(5103, new zzNW(zzYTY3.zzwc()));
        for (Row row : this.getRows()) {
            zzYTS zzYTS3 = row.zz5a().zzZeE();
            zzYTY3.zzF(row);
            Table.zzZ(zzYTS3, zzYTY3);
            for (Cell cell : row.getCells()) {
                cell.zzxn().zzwv().zzU(3900, zzYTY3.zzZfu());
            }
        }
    }

    private static void zzZ(zzYTS zzYTS2, zzYTY zzYTY2) {
        zzYTS2.zzU(5104, zzYTY2.zzZiX());
        zzYTS2.zzU(5105, zzYTY2.zzZiY());
        zzYTS2.zzzU(zzYTY2.zzZGO());
        zzYTS2.zzHE(zzYTY2.zzZGN());
    }

    private Object zzzZ(int n) {
        Row row = this.getFirstRow();
        if (row == null) {
            return zzYTS.zzTw(n);
        }
        if (n == 4005) {
            if (row.zz5a() != null) {
                return row.zz5a().zzZUh();
            }
            return zzYTS.zzTw(4005);
        }
        return row.fetchRowAttr(n);
    }
}

