/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;

public class DataRelation {
    private String zzXTX;
    private DataTable zzXTW;
    private DataTable zzXTV;
    private String zzaQ;
    private String zzaP;
    private String[] zzXTU;
    private String[] zzXTT;
    private DataColumn[] zzXTS;
    private DataColumn[] zzXTR;
    private UniqueConstraint zzXTQ;
    private ForeignKeyConstraint zzXTP;
    private boolean zzXTO = true;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        int n;
        if (parentColumnNames == null || parentColumnNames.length == 0) {
            throw new IllegalStateException("Parent column names need to have at least one column name.");
        }
        if (childColumnNames == null || childColumnNames.length == 0) {
            throw new IllegalStateException("Child column names need to have at least one column name.");
        }
        if (parentColumnNames.length != childColumnNames.length) {
            throw new IllegalStateException("The number of parent columns must be the same as the number of child columns.");
        }
        this.zzXTX = relationName;
        this.zzXTW = parentTable;
        this.zzXTV = childTable;
        this.zzaQ = parentTable.getTableName();
        this.zzaP = childTable.getTableName();
        this.zzXTU = parentColumnNames;
        this.zzXTT = childColumnNames;
        this.zzXTS = new DataColumn[this.zzXTU.length];
        for (n = 0; n < this.zzXTU.length; ++n) {
            this.zzXTS[n] = new DataColumn(this.zzXTU[n], this.zzXTW);
        }
        this.zzXTR = new DataColumn[this.zzXTT.length];
        for (n = 0; n < this.zzXTT.length; ++n) {
            this.zzXTR[n] = new DataColumn(this.zzXTT[n], this.zzXTV);
        }
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        int n;
        DataColumn dataColumn;
        int n2;
        String string = this.zzXTX = relationName == null ? "" : relationName;
        if (parentColumns == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        this.zzXTS = parentColumns;
        if (childColumns == null) {
            throw new IllegalArgumentException("childColumns");
        }
        this.zzXTR = childColumns;
        this.zzXTO = createConstraints;
        if (parentColumns.length != childColumns.length) {
            throw new IllegalArgumentException("ParentColumns and ChildColumns should be the same length");
        }
        DataTable dataTable = parentColumns[0].getTable();
        DataTable dataTable2 = childColumns[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        DataColumn[] dataColumnArray = parentColumns;
        int n3 = parentColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray = childColumns;
        n3 = childColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < this.zzXTR.length; ++n) {
            DataColumn dataColumn2 = childColumns[n];
            DataColumn dataColumn3 = parentColumns[n];
            if (dataColumn3.getDataType() == dataColumn2.getDataType()) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzXTU = new String[this.zzXTS.length];
        for (n = 0; n < this.zzXTS.length; ++n) {
            this.zzXTU[n] = this.zzXTS[n].getColumnName();
        }
        this.zzXTT = new String[this.zzXTR.length];
        for (n = 0; n < this.zzXTR.length; ++n) {
            this.zzXTT[n] = this.zzXTR[n].getColumnName();
        }
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    public String getRelationName() {
        return this.zzXTX;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        if (this.zzXTW != null) {
            return this.zzXTW;
        }
        return this.zzXTS[0].getTable();
    }

    public DataTable getChildTable() {
        if (this.zzXTV != null) {
            return this.zzXTV;
        }
        return this.zzXTR[0].getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzXTU;
    }

    public String[] getChildColumnNames() {
        return this.zzXTT;
    }

    public DataColumn[] getParentColumns() {
        return this.zzXTS;
    }

    public DataColumn[] getChildColumns() {
        return this.zzXTR;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzXTQ;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzXTQ = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzXTP;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzXTP = childKeyConstraint;
    }

    public int hashCode() {
        int n = 31 + this.zzXTX.hashCode();
        n = n * 31 + this.zzaQ.hashCode();
        n = n * 31 + this.zzaP.hashCode();
        for (int i = 0; i < this.zzXTU.length; ++i) {
            n = n * 31 + this.zzXTU[i].hashCode();
            n = n * 31 + this.zzXTT[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    final void zzZbr() throws InvalidConstraintException, DataException {
        UniqueConstraint uniqueConstraint;
        Constraint constraint;
        ForeignKeyConstraint foreignKeyConstraint;
        block6: {
            ForeignKeyConstraint foreignKeyConstraint2;
            Constraint constraint2;
            DataRelation dataRelation;
            ConstraintCollection constraintCollection;
            block5: {
                if (!this.zzXTO) {
                    return;
                }
                constraintCollection = this.getChildTable().getConstraints();
                dataRelation = this;
                for (Constraint constraint3 : constraintCollection) {
                    if (!(constraint3 instanceof ForeignKeyConstraint)) continue;
                    constraint2 = (ForeignKeyConstraint)constraint3;
                    if (!DataRelation.zzZ(dataRelation.getChildColumns(), ((ForeignKeyConstraint)constraint2).getColumns()) || !DataRelation.zzZ(dataRelation.getParentColumns(), ((ForeignKeyConstraint)constraint2).getRelatedColumns())) continue;
                    foreignKeyConstraint2 = constraint2;
                    break block5;
                }
                foreignKeyConstraint2 = null;
            }
            foreignKeyConstraint = foreignKeyConstraint2;
            constraintCollection = this.getParentTable().getConstraints();
            dataRelation = this;
            for (Constraint constraint3 : constraintCollection) {
                if (!(constraint3 instanceof UniqueConstraint)) continue;
                constraint2 = (UniqueConstraint)constraint3;
                if (!DataRelation.zzZ(dataRelation.getParentColumns(), ((UniqueConstraint)constraint2).getColumns())) continue;
                constraint = constraint2;
                break block6;
            }
            constraint = uniqueConstraint = null;
        }
        if (constraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private static boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

