/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.zzWHg;
import com.aspose.words.zzWXJ;
import com.aspose.words.zzYKv;
import com.aspose.words.zzYZ9;
import com.aspose.words.zzYd7;
import com.aspose.words.zzYei;
import com.aspose.words.zzYvK;
import com.aspose.words.zzZ2W;
import com.aspose.words.zzZIr;
import com.aspose.words.zzZcd;

public class Cell
extends CompositeNode<Node>
implements zzYKv,
zzYZ9 {
    private zzWXJ zzgx;
    private CellFormat zzW5O;
    private ParagraphCollection zzZMF;
    private TableCollection zzYCN;

    public Cell(DocumentBase doc) {
        this(doc, new zzWXJ());
    }

    Cell(DocumentBase doc, zzWXJ cellPr) {
        super(doc);
        this.zzgx = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzZ4x() {
        return (Cell)this.zzX1d();
    }

    public Row getParentRow() {
        return (Row)this.zzZzK();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzwn() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zz2z(this, true);
        }
        return -1;
    }

    final int zzYf8() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzYf8();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzW5O == null) {
            this.zzW5O = new CellFormat(this);
        }
        return this.zzW5O;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzZMF == null) {
            this.zzZMF = new ParagraphCollection(this);
        }
        return this.zzZMF;
    }

    public TableCollection getTables() {
        if (this.zzYCN == null) {
            this.zzYCN = new TableCollection(this);
        }
        return this.zzYCN;
    }

    final zzWXJ zzXe3() {
        return this.zzgx;
    }

    final void zzWGp(zzWXJ zzWXJ2) {
        this.zzgx = zzWXJ2;
    }

    @Override
    final Node zzWGp(boolean bl, zzZcd zzZcd2) {
        zzWXJ zzWXJ2;
        Cell cell = (Cell)super.zzWGp(bl, zzZcd2);
        zzWXJ zzWXJ3 = this.zzgx;
        cell.zzgx = zzWXJ2 = (zzWXJ)zzWXJ3.zzXc8();
        cell.zzW5O = null;
        cell.zzZMF = null;
        cell.zzYCN = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWGp(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zz2z(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() throws Exception {
        zzWHg.zzZ0H(this);
    }

    @Override
    final boolean zzZU6(Node node) {
        return zzYei.zzWW(node);
    }

    final int zzVTO() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzX1d();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzgx.zzYx3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzgx.zzYx3(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZ2W zzZ2W2 = zzZ23.zzWGp(object, zzZ2W.class);
        if (zzZ2W2 != null && zzZ2W2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzWNQ(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzWXJ.zz0C(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzgx.zzXIh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzgx.clear();
    }

    private Object zzWNQ(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzZ23.zzWGp((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzWGp(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYd7 getInsertRevision() {
        Cell cell = this;
        return cell.zzgx.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzYd7 value) {
        Cloneable cloneable = this;
        zzYd7 zzYd72 = value;
        cloneable = cloneable.zzgx;
        ((zzZIr)cloneable).zzXIh(14, zzYd72);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYd7 getDeleteRevision() {
        Cell cell = this;
        return cell.zzgx.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzYd7 value) {
        Cloneable cloneable = this;
        zzYd7 zzYd72 = value;
        cloneable = cloneable.zzgx;
        ((zzZIr)cloneable).zzXIh(12, zzYd72);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYvK getMoveFromRevision() {
        Cell cell = this;
        return cell.zzgx.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzYvK value) {
        Cloneable cloneable = this;
        zzYvK zzYvK2 = value;
        cloneable = cloneable.zzgx;
        ((zzZIr)cloneable).zzXIh(13, zzYvK2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYvK getMoveToRevision() {
        Cell cell = this;
        return cell.zzgx.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzYvK value) {
        Cloneable cloneable = this;
        zzYvK zzYvK2 = value;
        cloneable = cloneable.zzgx;
        ((zzZIr)cloneable).zzXIh(15, zzYvK2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzgx.remove(13);
        cell = this;
        cell.zzgx.remove(15);
    }

    final zzWXJ zzXO6(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzWXJ zzWXJ2 = new zzWXJ();
        this.zzWGp(3120, zzWXJ2);
        this.zzWGp(3140, zzWXJ2);
        this.zzWGp(3110, zzWXJ2);
        this.zzWGp(3130, zzWXJ2);
        this.zzWGp(3090, zzWXJ2);
        this.zzWGp(3100, zzWXJ2);
        this.zzWGp(3070, zzWXJ2);
        this.zzWGp(3080, zzWXJ2);
        if (bl && (tableStyle = zzZ23.zzWGp((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zz2z(this, zzWXJ2);
        }
        this.zzgx.zz2z((zzZIr)zzWXJ2);
        return zzWXJ2;
    }

    private void zzWGp(int n, zzWXJ zzWXJ2) {
        zzWXJ2.zzXIh(n, this.fetchInheritedCellAttr(n));
    }
}

