/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzVQq;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.internal.zzg1;
import com.aspose.words.zzYei;
import com.aspose.words.zzZcd;
import com.aspose.words.zzZk9;
import com.aspose.words.zzi5;

public abstract class Node
implements Cloneable {
    private Node zzZot;
    private Node zzyM;
    private Node zzWuD;
    private int zzWvX;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zz2z(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzZot == null) {
            return null;
        }
        if (this.zzZot.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzZot;
    }

    final CompositeNode zzZzK() {
        if (zzYei.zz7u(this.getParentNode())) {
            return this.getParentNode().zzZzK();
        }
        return this.getParentNode();
    }

    final CompositeNode zzYXD() {
        if (zzYei.zz7u(this.getParentNode()) || zzYei.zzZzy(this.getParentNode())) {
            return this.getParentNode().zzYXD();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzZot != null) {
            return this.zzZot.getDocument();
        }
        return null;
    }

    final Document zzXxN() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzX7y() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZjg();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzWuD;
    }

    final Node zzZxp() {
        Node node = this;
        while ((node = node.getPreviousSibling()) != null && zzYei.zzWnx(node)) {
        }
        return node;
    }

    final Node zzTy() {
        Node node = zzYei.zzZU6(this.getPreviousSibling(), false);
        if (node == null && zzYei.zz7u(this.getParentNode())) {
            node = this.getParentNode().zzTy();
        }
        return node;
    }

    final Node zz0x() {
        Node node = zzYei.zzVTF(this.getNextSibling(), false);
        if (node == null && zzYei.zz7u(this.getParentNode())) {
            node = this.getParentNode().zz0x();
        }
        return node;
    }

    final CompositeNode zzWSS() {
        Node node = this;
        while ((node = node.zzTy()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzX1d() {
        Node node = this;
        while ((node = node.zz0x()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzyM;
    }

    final Node zzYsZ() {
        Node node = this;
        while ((node = node.getNextSibling()) != null && zzYei.zzWnx(node)) {
        }
        return node;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzW9c() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzVVR() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZ99() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYei.zzZdj(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzXLq() {
        return this.zzyM;
    }

    final void zzXsU(Node node) {
        this.zzyM = node;
    }

    final Node zzXcB() {
        return this.zzWuD;
    }

    final void zzY88(Node node) {
        this.zzWuD = node;
    }

    final Node zzWXL() {
        Node node = this;
        if (node.zzyM != null) {
            node = this;
            return node.zzyM;
        }
        return this.getParentNode();
    }

    final int zzZAb() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYei.zzZsR(this);
        boolean bl2 = zzYei.zzWW(this);
        boolean bl3 = zzYei.zzZuT(this);
        boolean bl4 = zzYei.zzZp7(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZAb() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZAb() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzWGp(isCloneChildren, null);
    }

    Node zzWGp(boolean bl, zzZcd zzZcd2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzZot != null) {
            node.zzZot = this.getDocument().zzWaQ();
        }
        node.zzyM = null;
        node.zzWuD = null;
        if (zzZcd2 != null) {
            zzZcd2.zzXfK(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzWXR(StringBuilder stringBuilder) {
        zzZ23.zz2z(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzW0c(Node node) {
        this.zzZot = node != null ? node : this.getDocument().zzWaQ();
    }

    final void zz2z(DocumentBase documentBase) {
        this.zzZot = documentBase != null ? documentBase.zzWaQ() : null;
    }

    final boolean zzya(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzWJ1() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzXdx(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZj7(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzMu(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzYVP(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzZk9 zzZk92 = zzYei.zzXGD(saveFormat);
        return zzZk92.zzXO6(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZk9 zzZk92 = zzYei.zzWGp(saveOptions);
        return zzZk92.zzXO6(this);
    }

    final Node zzZyt(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYei.zzWO1(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzi5 zzYmg() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzi5.zzZ7S(node);
        }
        return zzi5.zzWrz(this.getParentNode());
    }

    final zzi5 zzUR() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzi5.zzWrz(node);
        }
        return zzi5.zzZ7S(this.getParentNode());
    }

    final boolean zzYwv(Node node) {
        return Node.zzYpp(this, node);
    }

    final boolean zzWu1() {
        return this.getAncestor(1) == null;
    }

    static Node zzYlm(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzg1<Node> zzg12 = Node.zzWML(node);
        zzg1<Node> zzg13 = Node.zzWML(node2);
        return Node.zzWGp(zzg12, zzg13);
    }

    static boolean zzYpp(Node node, Node node2) {
        zzg1<Node> zzg12;
        if (node == null || node2 == null) {
            return false;
        }
        zzg1<Node> zzg13 = Node.zzWML(node);
        Node node3 = Node.zzWGp(zzg13, zzg12 = Node.zzWML(node2));
        if (node3 == null) {
            return false;
        }
        zzg1<Node> zzg14 = zzg13;
        if (zzg14.size() == 0 || (zzg14 = zzg12).size() == 0) {
            zzg14 = zzg12;
            boolean bl = zzg14.size() > 0;
            return bl;
        }
        Object e = zzg13.peek();
        Object e2 = zzg12.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzg1<Node> zzWML(Node node) {
        zzg1<Node> zzg12 = new zzg1<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzg12.push(node2);
        }
        return zzg12;
    }

    private static Node zzWGp(zzg1<Node> zzg12, zzg1<Node> zzg13) {
        Node node = null;
        while (zzg12.peek() == zzg13.peek()) {
            node = (Node)zzg12.pop();
            zzg13.pop();
            zzg1<Node> zzg14 = zzg12;
            if (zzg14.size() != 0 && (zzg14 = zzg13).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzWvX;
    }

    public void setCustomNodeId(int value) {
        this.zzWvX = value;
    }

    private String zzWak() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzZ23.zzWGp(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzVQq.zzXrM(stringBuilder.toString());
    }

    public String toString() {
        return zzVQq.zzXrM(zzVQq.zz2z("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzWak()));
    }

    public void dd() {
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

