/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.zz54;
import com.aspose.words.zzYHJ;
import com.aspose.words.zzZcd;

public final class Section
extends CompositeNode<Node>
implements zzYHJ {
    private zz54 zzZzn;
    private PageSetup zzFN;
    private HeaderFooterCollection zzYDC;

    public Section(DocumentBase doc) {
        this(doc, new zz54());
    }

    Section(DocumentBase doc, zz54 sectPr) {
        super(doc);
        this.zzZzn = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzYDC == null) {
            this.zzYDC = new HeaderFooterCollection(this);
        }
        return this.zzYDC;
    }

    public final PageSetup getPageSetup() {
        if (this.zzFN == null) {
            Section section = this;
            this.zzFN = new PageSetup(section, section.getDocument().zzX7j(), this.getDocument().getStyles(), new zzWGp(this));
        }
        return this.zzFN;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZWx();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzXCG(!value);
    }

    final zz54 zzXGb() {
        return this.zzZzn;
    }

    final void zz2z(zz54 zz542) {
        this.zzZzn = zz542;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzWGp(boolean bl, zzZcd zzZcd2) {
        zz54 zz542;
        Section section = (Section)super.zzWGp(bl, zzZcd2);
        zz54 zz543 = this.zzZzn;
        section.zzZzn = zz542 = (zz54)zz543.zzXc8();
        section.zzFN = null;
        section.zzYDC = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWGp(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zz2z(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) throws Exception {
        this.zzXfK(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) throws Exception {
        this.zzXfK(sourceSection, true);
    }

    public final void clearContent() throws Exception {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() throws Exception {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzZ85(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzZU6(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzZ85(n) == null;
            }
        }
        return false;
    }

    final void zzZuG(Shape shape, boolean bl) throws Exception {
        this.zzWGp(shape, 4, bl);
        this.zzWGp(shape, 0, bl);
        this.zzWGp(shape, 1, bl);
    }

    private void zzWGp(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzYCn() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzW7o()) {
                if (!shape.zzfY()) continue;
                shape.remove();
            }
        }
    }

    private void zzXfK(Section section, boolean bl) throws Exception {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zz2z(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzZzn.zzYx3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzX7j().zzY39.zzYCx(key);
        }
        return zz54.zz0C(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzZzn.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzX7j().zzY39.zzXIh(key, value);
            return;
        }
        this.zzZzn.zzXIh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzZzn.clear();
    }

    final boolean zzZYk() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzYvi() {
        return this.getParentNode().getLastChild() == this;
    }

    static final class zzWGp
    implements zzYHJ {
        private Section zzZ07;

        zzWGp(Section section) {
            this.zzZ07 = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzWbg().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzWbg().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzWbg().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzYHJ zzWbg() {
            Document document = zzZ23.zzWGp((Object)this.zzZ07.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZ07;
        }
    }
}

