/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzXU0;
import com.aspose.words.internal.zzXh5;
import com.aspose.words.internal.zzYBv;
import com.aspose.words.internal.zzYvB;
import com.aspose.words.internal.zzZ3j;
import com.aspose.words.internal.zzZ7O;
import com.aspose.words.internal.zzZT5;
import com.aspose.words.internal.zzZqi;
import com.aspose.words.internal.zzkd;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzWq6
extends CertPathBuilderSpi {
    private final zzZ7O zzXMR;
    private zzZT5 zzYd9;

    zzWq6(zzZ7O zzZ7O2) {
        this.zzXMR = zzZ7O2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzXh5 pkixParams;
        if (params instanceof zzXh5) {
            pkixParams = (zzXh5)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzXh5.zzWGp((PKIXBuilderParameters)params).zzWcY();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzXh5.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzYvB zzYvB2 = pkixParams.zzX83().zzXpi();
        try {
            collection = zzkd.zzWGp(zzYvB2, pkixParams.zzX83().zzZJH());
            collection.addAll(zzkd.zzWGp(zzYvB2, pkixParams.zzX83().zzY5i()));
        }
        catch (zzZT5 zzZT52) {
            throw new CertPathBuilderException("Error finding target certificate.", zzZT52);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzWGp(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzYd9 != null) {
            throw new CertPathBuilderException(this.zzYd9.getMessage(), this.zzYd9.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzWGp(X509Certificate x509Certificate, zzXh5 zzXh52, List list) throws CertPathBuilderException {
        zzZqi zzZqi2;
        zzZ3j zzZ3j2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzXh52.zzWDs().contains(x509Certificate)) {
            return null;
        }
        if (zzXh52.zzWg3() != -1 && list.size() - 1 > zzXh52.zzWg3()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZ3j2 = new zzZ3j(this.zzXMR);
            zzZqi2 = new zzZqi(this.zzXMR);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzkd.zzWGp(x509Certificate, zzXh52.zzX83().zzHq(), zzXh52.zzX83().zzaU()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZ3j2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzZT5("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZqi2.engineValidate(certPath, zzXh52);
                }
                catch (Exception exception) {
                    throw new zzZT5("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzYBv> arrayList = new ArrayList<zzYBv>();
            arrayList.addAll(zzXh52.zzX83().zzZJH());
            try {
                arrayList.addAll(zzkd.zzWGp(x509Certificate.getExtensionValue(zzXU0.zzWXN.getId()), zzXh52.zzX83().zzXH0()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzZT5("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzkd.zzWGp(x509Certificate, zzXh52.zzX83().zzY5i(), arrayList));
            }
            catch (zzZT5 zzZT52) {
                throw new zzZT5("Cannot find issuer certificate for certificate in certification path.", zzZT52);
            }
            if (hashSet.isEmpty()) {
                throw new zzZT5("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzWGp(x509Certificate2, zzXh52, list);
            }
        }
        catch (zzZT5 zzZT53) {
            this.zzYd9 = zzZT53;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

