/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzVQq;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzWzo = new ArrayList();
    private final Map<String, DataColumn> zzWYK = new HashMap<String, DataColumn>();
    private DataTable zzYT1;

    DataColumnCollection(DataTable table) {
        this.zzYT1 = table;
    }

    public void add(DataColumn column) {
        if (zzVQq.zzYYX(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzWS4(column.getColumnName());
        if (this.zzWYK.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zz2z(this.zzYT1);
        column.setOrdinal(this.zzWzo.size());
        this.zzWzo.add(column);
        this.zzWYK.put(string, column);
        this.zzYT1.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYT1);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzVQq.zzYYX(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzWS4(columnName);
        DataColumn dataColumn = this.zzWYK.get(string);
        if (dataColumn != null) {
            int n = this.zzWzo.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzWzo.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzWzo.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzWzo.remove(n);
            this.zzWYK.remove(DataColumnCollection.zzWS4(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzYT1.getRows()) {
                dataRow.remove(n);
            }
            this.zzYT1.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzWzo.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzWzo.iterator();
    }

    public void clear() {
        this.zzWYK.clear();
        this.zzWzo.clear();
    }

    final DataColumn[] zzXyb() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzWzo);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzWGp(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzWzo.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzWzo.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzWS4(string);
            String string3 = DataColumnCollection.zzWS4(dataColumn.getColumnName());
            this.zzWYK.remove(string3);
            this.zzWYK.put(string2, dataColumn);
            return;
        }
    }

    private static String zzWS4(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

