/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzBk;
import com.aspose.words.zzWhT;
import com.aspose.words.zzXUi;
import com.aspose.words.zzXhW;
import com.aspose.words.zzXpD;
import com.aspose.words.zzYG;
import com.aspose.words.zzYqc;
import com.aspose.words.zzYzF;
import com.aspose.words.zzZpe;
import com.aspose.words.zzZu9;
import com.aspose.words.zzbt;

public class Cell
extends CompositeNode<Node>
implements zzXUi,
zzYqc {
    private zzXpD zzWwJ;
    private CellFormat zzZtw;
    private ParagraphCollection zzMq;
    private TableCollection zzW2v;

    public Cell(DocumentBase doc) {
        this(doc, new zzXpD());
    }

    Cell(DocumentBase doc, zzXpD cellPr) {
        super(doc);
        this.zzWwJ = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzYIl() {
        return (Cell)this.zzZkz();
    }

    public Row getParentRow() {
        return (Row)this.zzZah();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzZ7C() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzj0(this, true);
        }
        return -1;
    }

    final int zzWot() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzWot();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzZtw == null) {
            this.zzZtw = new CellFormat(this);
        }
        return this.zzZtw;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzMq == null) {
            this.zzMq = new ParagraphCollection(this);
        }
        return this.zzMq;
    }

    public TableCollection getTables() {
        if (this.zzW2v == null) {
            this.zzW2v = new TableCollection(this);
        }
        return this.zzW2v;
    }

    final zzXpD zzVs() {
        return this.zzWwJ;
    }

    final void zzYN3(zzXpD zzXpD2) {
        this.zzWwJ = zzXpD2;
    }

    @Override
    final Node zzYN3(boolean bl, zzWhT zzWhT2) {
        zzXpD zzXpD2;
        Cell cell = (Cell)super.zzYN3(bl, zzWhT2);
        zzXpD zzXpD3 = this.zzWwJ;
        cell.zzWwJ = zzXpD2 = (zzXpD)zzXpD3.zzYEK();
        cell.zzZtw = null;
        cell.zzMq = null;
        cell.zzW2v = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYN3(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzj0(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzZpe.zzxI(this);
    }

    @Override
    final boolean zzYyq(Node node) {
        return zzYG.zzWHG(node);
    }

    final int zzYBB() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzZkz();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWwJ.zzZsc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzWwJ.zzZsc(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZu9 zzZu92 = zzBk.zzYN3(object, zzZu9.class);
        if (zzZu92 != null && zzZu92.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzYkr(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzXpD.zzZ2t(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzWwJ.zzWwk(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWwJ.clear();
    }

    private Object zzYkr(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzBk.zzYN3((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzYN3(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzbt getInsertRevision() {
        Cell cell = this;
        return cell.zzWwJ.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzbt value) {
        Cloneable cloneable = this;
        zzbt zzbt2 = value;
        cloneable = cloneable.zzWwJ;
        ((zzYzF)cloneable).zzWwk(14, zzbt2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzbt getDeleteRevision() {
        Cell cell = this;
        return cell.zzWwJ.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzbt value) {
        Cloneable cloneable = this;
        zzbt zzbt2 = value;
        cloneable = cloneable.zzWwJ;
        ((zzYzF)cloneable).zzWwk(12, zzbt2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXhW getMoveFromRevision() {
        Cell cell = this;
        return cell.zzWwJ.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzXhW value) {
        Cloneable cloneable = this;
        zzXhW zzXhW2 = value;
        cloneable = cloneable.zzWwJ;
        ((zzYzF)cloneable).zzWwk(13, zzXhW2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXhW getMoveToRevision() {
        Cell cell = this;
        return cell.zzWwJ.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzXhW value) {
        Cloneable cloneable = this;
        zzXhW zzXhW2 = value;
        cloneable = cloneable.zzWwJ;
        ((zzYzF)cloneable).zzWwk(15, zzXhW2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzWwJ.remove(13);
        cell = this;
        cell.zzWwJ.remove(15);
    }

    final zzXpD zzXyH(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzXpD zzXpD2 = new zzXpD();
        this.zzYN3(3120, zzXpD2);
        this.zzYN3(3140, zzXpD2);
        this.zzYN3(3110, zzXpD2);
        this.zzYN3(3130, zzXpD2);
        this.zzYN3(3090, zzXpD2);
        this.zzYN3(3100, zzXpD2);
        this.zzYN3(3070, zzXpD2);
        this.zzYN3(3080, zzXpD2);
        if (bl && (tableStyle = zzBk.zzYN3((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzj0(this, zzXpD2);
        }
        this.zzWwJ.zzj0((zzYzF)zzXpD2);
        return zzXpD2;
    }

    private void zzYN3(int n, zzXpD zzXpD2) {
        zzXpD2.zzWwk(n, this.fetchInheritedCellAttr(n));
    }
}

