/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzBk;
import com.aspose.words.internal.zzWU2;
import com.aspose.words.zzOa;
import com.aspose.words.zzXLg;
import com.aspose.words.zzY8O;
import com.aspose.words.zzYIV;
import com.aspose.words.zzYYr;
import com.aspose.words.zzYrb;
import com.aspose.words.zzYvI;
import com.aspose.words.zzYwv;
import com.aspose.words.zzZ2U;
import com.aspose.words.zzZQ8;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzYvI zzVUb;

    ChartSeriesCollection(zzYvI dmlChart) {
        this.zzVUb = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVUb.zzWMh().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVUb.zzWMh().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzVUb.zzWMh().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzVUb.zzWMh().clear();
        this.zzZ6w(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYN3(seriesName, values);
        chartSeries.zzW54().zzRX(ChartSeriesCollection.zzW3B(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYN3(seriesName, yValues);
        chartSeries.zzW54().zzRX(ChartSeriesCollection.zzRX(xValues));
        return chartSeries;
    }

    private ChartSeries zzYN3(String string, zzWU2[] zzWU2Array, double[] dArray) {
        if (zzWU2Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzWU2Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzWU2Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYN3(string, dArray);
        chartSeries.zzW54().zzRX(ChartSeriesCollection.zzYN3(zzWU2Array));
        if (!this.zzVUb.zzWTk()) {
            this.zzZ6w(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzYN3(seriesName, zzWU2.zzYN3(dates), values);
    }

    private void zzZ6w(boolean bl) {
        zzYwv zzYwv2 = zzBk.zzYN3((Object)this.zzVUb, zzYwv.class);
        if (zzYwv2 != null && zzYwv2.zz4l().zzXz9()) {
            zzYwv2.zz4l().zzZ2S().zzW00(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzVUb.zzZrM() != 15) {
            this.zzVUb.zzZZx(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzYN3(seriesName, yValues);
        chartSeries.zzWdO().zzYdm().zzW00(3, this.zzVUb.zzZEr());
        chartSeries.zzW54().zzRX(ChartSeriesCollection.zzRX(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzWbs().zzRX(ChartSeriesCollection.zzRX(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzYN3(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzVUb);
        chartSeries.setName(string);
        this.zzYyq(chartSeries);
        chartSeries.zzZlB(this.zzVUb.zz6j().zzYYg() + 1);
        chartSeries.zzYJD(this.zzVUb.zz6j().zzg6() + 1);
        chartSeries.zzYkJ().zzRX(ChartSeriesCollection.zzRX(dArray));
        chartSeries.zzWri().zzRX(chartSeries.zzYkJ().zzXdQ());
        this.zzVUb.zzZD2().zzWwd();
        this.zzVUb.zzw7(chartSeries);
        return chartSeries;
    }

    private void zzYyq(ChartSeries chartSeries) {
        chartSeries.zzWdO().zzYdm().zzW00(5, new zzXLg());
        switch (this.zzVUb.zzZrM()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzYN3(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzYN3(chartSeries, 5);
                ChartSeriesCollection.zzXSB(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzYN3(chartSeries, 1);
                ChartSeriesCollection.zzXSB(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzdb(chartSeries);
            }
        }
    }

    private static void zzdb(ChartSeries chartSeries) {
        zzXLg zzXLg2 = new zzXLg();
        zzXLg2.zzj0(new zzYYr());
        zzZQ8 zzZQ82 = new zzZQ8();
        zzZQ82.zzYU6(1);
        zzXLg2.zzZ0W().zzj0(new zzYIV(zzZQ82));
        zzXLg2.zzZ0W().zzX5N(19050.0);
        chartSeries.zzWdO().zzYdm().zzW00(5, zzXLg2);
    }

    private static void zzXSB(ChartSeries chartSeries) {
        zzXLg zzXLg2 = new zzXLg();
        zzXLg2.zzj0(new zzYYr());
        zzXLg2.zzZ0W().zzj0(new zzY8O());
        zzXLg2.zzZ0W().setEndCap(0);
        zzXLg2.zzZ0W().zzX5N(19050.0);
        chartSeries.zzWdO().zzYdm().zzW00(5, zzXLg2);
    }

    private static void zzYN3(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzYZF().zzW00(0, n);
        chartSeries.zzWdO().zzYdm().zzW00(4, chartMarker);
    }

    private static zzOa zzRX(double[] dArray) {
        int n = 0;
        zzOa zzOa2 = new zzOa(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzOa2.zzXSB(new zzZ2U(n, d, "General"));
            }
            ++n;
        }
        zzOa2.zzYju(dArray.length);
        zzOa2.zzXnT();
        return zzOa2;
    }

    private static zzOa zzYN3(zzWU2[] zzWU2Array) {
        int n = 0;
        zzOa zzOa2 = new zzOa(2, false);
        zzWU2[] zzWU2Array2 = zzWU2Array;
        int n2 = zzWU2Array.length;
        for (int i = 0; i < n2; ++i) {
            zzWU2 zzWU22 = zzWU2Array2[i];
            zzOa2.zzXSB(new zzZ2U(n++, zzWU22.zzc2(), "m/d/yyyy"));
        }
        zzOa2.zzYju(zzWU2Array.length);
        zzOa2.zzXnT();
        return zzOa2;
    }

    private static zzOa zzW3B(String[] stringArray) {
        int n = 0;
        zzOa zzOa2 = new zzOa(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzOa2.zzXSB(new zzYrb(n++, string));
        }
        zzOa2.zzYju(stringArray.length);
        zzOa2.zzXnT();
        return zzOa2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVUb.zzWMh().size();
    }
}

