/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzBk;
import com.aspose.words.zzFT;
import com.aspose.words.zzSV;
import com.aspose.words.zzVZ;
import com.aspose.words.zzWVQ;
import com.aspose.words.zzWhT;
import com.aspose.words.zzYG;
import com.aspose.words.zzZ37;
import com.aspose.words.zzZl8;
import com.aspose.words.zzoQ;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZl8,
Iterable<T> {
    private Node zzWjl;
    private Node zzY35;
    private Node zzYI5;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zz5D() {
        return this.zzpk() != null;
    }

    final boolean zzWqX() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzXsj() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzVZ) {
                return true;
            }
            CompositeNode compositeNode = zzBk.zzYN3((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzXsj()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzWjl;
    }

    public Node getLastChild() {
        return this.zzY35;
    }

    final Node zzpk() {
        return zzYG.zzZZx(this.getFirstChild(), false);
    }

    final Node zzYi9() {
        return zzYG.zzYyq(this.getLastChild(), false);
    }

    final CompositeNode zzXLN() {
        return (CompositeNode)zzYG.zzZZx(this.getFirstChild(), true);
    }

    final CompositeNode zzXyW() {
        return (CompositeNode)zzYG.zzYyq(this.getLastChild(), true);
    }

    final Node zzWK() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYG.zzZ1I((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzXFn() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYG.zzZ1I((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzYN3(boolean bl, zzWhT zzWhT2) {
        CompositeNode compositeNode = (CompositeNode)super.zzYN3(bl, zzWhT2);
        ((CompositeNode)super.zzYN3(bl, zzWhT2)).zzY35 = null;
        compositeNode.zzWjl = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWfx(node.zzYN3(true, zzWhT2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXoD(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzXoD(StringBuilder stringBuilder) {
        this.zzW3B(stringBuilder);
        zzBk.zzj0(stringBuilder, this.zzZ3G());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzj0(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYG.zzZUY(nodeType);
            Node node2 = node = bl ? this.zzpk() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzWmT() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzoQ.zzZAU(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzoQ.zzRX(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzFT(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzYN3(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzYN3(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzYN3(oldChild, this, null, 1);
        if (documentBase.zzWgc() && zzZ37.zzZXj(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzYN3(nodeChangingArgs);
        }
        Node node = this.zzWzC(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzj0(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzSV.zzYQi(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWfx(Node node) {
        node.getParentNode();
        if (this.zzY35 == null) {
            node.zzZ6w(null);
            node.zzYMT(null);
            this.zzWjl = node;
        } else {
            node.zzZ6w(this.zzY35);
            node.zzYMT(null);
            this.zzY35.zzYMT(node);
        }
        this.zzY35 = node;
        node.zzVWQ(this);
        return node;
    }

    final void zzYN3(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzj0(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzj0(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYG.zzZ1I(node3.getNodeType())) continue;
            if (zzYG.zzWUu(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZ3G().length();
    }

    String zzZ3G() {
        return "";
    }

    final String zzZUA() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzW3B(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzW3B(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzXoD(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzYN3(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzj0(visitor));
    }

    abstract int zzYN3(DocumentVisitor var1) throws Exception;

    abstract int zzj0(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzYyq(Node var1);

    final Node zzYN3(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzXh9(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzYyq(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzWVQ(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zzWVQ)object).dispose();
            }
        }
        if ((object = documentBase.zzYN3(node, null, this, 0)) != null) {
            documentBase.zzYN3((NodeChangingArgs)object);
        }
        if (this.zzY35 == null) {
            node.zzZ6w(null);
            node.zzYMT(null);
            this.zzWjl = node;
            this.zzY35 = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzj0(node, node2);
            } else {
                this.zzZAU(node, this.zzWjl);
            }
        } else if (node2 != null) {
            this.zzZAU(node, node2);
        } else {
            this.zzj0(node, this.zzY35);
        }
        node.zzVWQ(this);
        if (object != null) {
            documentBase.zzj0((NodeChangingArgs)object);
        }
        if (documentBase.zzWgc()) {
            zzZ37.zzYN3(node, compositeNode, node3);
        }
        return node;
    }

    private void zzj0(Node node, Node node2) {
        Node node3 = node2.zzZq9();
        node.zzZ6w(node2);
        node.zzYMT(node3);
        node2.zzYMT(node);
        if (node3 == null) {
            this.zzY35 = node;
            return;
        }
        node3.zzZ6w(node);
    }

    private void zzZAU(Node node, Node node2) {
        Node node3 = node2.zzZyK();
        node.zzZ6w(node3);
        node.zzYMT(node2);
        node2.zzZ6w(node);
        if (node3 == null) {
            this.zzWjl = node;
            return;
        }
        node3.zzYMT(node);
    }

    private Node zzWzC(Node node) {
        if (node == this.zzWjl) {
            if (this.zzWjl == this.zzY35) {
                this.zzWjl = null;
                this.zzY35 = null;
            } else {
                this.zzWjl = node.zzZq9();
                this.zzWjl.zzZ6w(null);
            }
        } else {
            Node node2 = node.zzZyK();
            Node node3 = node.zzZq9();
            node2.zzYMT(node3);
            if (node3 == null) {
                this.zzY35 = node2;
            } else {
                node3.zzZ6w(node2);
            }
        }
        node.zzYMT(null);
        node.zzZ6w(null);
        node.zzVWQ(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzYI5 = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYI5;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

